/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.ByteBuffer;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRenderer;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefDragData;
import org.cef.handler.CefRenderHandler;

class CefBrowserOsr
extends CefBrowser_N
implements CefRenderHandler {
    private CefRenderer renderer_;
    private GLCanvas canvas_;
    private long window_handle_ = 0L;
    private Rectangle browser_rect_ = new Rectangle(0, 0, 1, 1);
    private Point screenPoint_ = new Point(0, 0);
    private boolean isTransparent_;

    CefBrowserOsr(CefClient client, String url, boolean transparent, CefRequestContext context) {
        this(client, url, transparent, context, null, null);
    }

    private CefBrowserOsr(CefClient client, String url, boolean transparent, CefRequestContext context, CefBrowserOsr parent, Point inspectAt) {
        super(client, url, context, parent, inspectAt);
        this.isTransparent_ = transparent;
        this.renderer_ = new CefRenderer(transparent);
        this.createGLCanvas();
    }

    @Override
    public void createImmediately() {
        this.createBrowserIfRequired(false);
    }

    @Override
    public Component getUIComponent() {
        return this.canvas_;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    protected CefBrowser_N createDevToolsBrowser(CefClient client, String url, CefRequestContext context, CefBrowser_N parent, Point inspectAt) {
        return new CefBrowserOsr(client, url, this.isTransparent_, context, this, inspectAt);
    }

    private synchronized long getWindowHandle() {
        NativeSurface surface;
        if (this.window_handle_ == 0L && (surface = this.canvas_.getNativeSurface()) != null) {
            surface.lockSurface();
            this.window_handle_ = this.getWindowHandle(surface.getSurfaceHandle());
            surface.unlockSurface();
            assert (this.window_handle_ != 0L);
        }
        return this.window_handle_;
    }

    private void createGLCanvas() {
        GLProfile glprofile = GLProfile.getMaxFixedFunc((boolean)true);
        GLCapabilities glcapabilities = new GLCapabilities(glprofile);
        this.canvas_ = new GLCanvas((GLCapabilitiesImmutable)glcapabilities){

            public void paint(Graphics g) {
                CefBrowserOsr.this.createBrowserIfRequired(true);
                super.paint(g);
            }
        };
        this.canvas_.addGLEventListener(new GLEventListener(){

            public void reshape(GLAutoDrawable glautodrawable, int x, int y, int width, int height) {
                CefBrowserOsr.this.browser_rect_.setBounds(CefBrowserOsr.this.canvas_.getBounds());
                CefBrowserOsr.this.screenPoint_ = CefBrowserOsr.this.canvas_.getLocationOnScreen();
                CefBrowserOsr.this.wasResized(width, height);
            }

            public void init(GLAutoDrawable glautodrawable) {
                CefBrowserOsr.this.renderer_.initialize(glautodrawable.getGL().getGL2());
            }

            public void dispose(GLAutoDrawable glautodrawable) {
                CefBrowserOsr.this.renderer_.cleanup(glautodrawable.getGL().getGL2());
            }

            public void display(GLAutoDrawable glautodrawable) {
                CefBrowserOsr.this.renderer_.render(glautodrawable.getGL().getGL2());
            }
        });
        this.canvas_.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                CefBrowserOsr.this.sendMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CefBrowserOsr.this.sendMouseEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CefBrowserOsr.this.sendMouseEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CefBrowserOsr.this.sendMouseEvent(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                CefBrowserOsr.this.sendMouseEvent(e);
            }
        });
        this.canvas_.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                CefBrowserOsr.this.sendMouseEvent(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                CefBrowserOsr.this.sendMouseEvent(e);
            }
        });
        this.canvas_.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                CefBrowserOsr.this.sendMouseWheelEvent(e);
            }
        });
        this.canvas_.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                CefBrowserOsr.this.sendKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                CefBrowserOsr.this.sendKeyEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                CefBrowserOsr.this.sendKeyEvent(e);
            }
        });
        this.canvas_.setFocusable(true);
        this.canvas_.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CefBrowserOsr.this.setFocus(false);
            }

            @Override
            public void focusGained(FocusEvent e) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                CefBrowserOsr.this.setFocus(true);
            }
        });
    }

    @Override
    public Rectangle getViewRect(CefBrowser browser) {
        return this.browser_rect_;
    }

    @Override
    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        Point screenPoint = new Point(this.screenPoint_);
        screenPoint.translate(viewPoint.x, viewPoint.y);
        return screenPoint;
    }

    @Override
    public void onPopupShow(CefBrowser browser, boolean show) {
        if (!show) {
            this.renderer_.clearPopupRects();
            this.invalidate();
        }
    }

    @Override
    public void onPopupSize(CefBrowser browser, Rectangle size) {
        this.renderer_.onPopupSize(size);
    }

    @Override
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        this.canvas_.getContext().makeCurrent();
        this.renderer_.onPaint(this.canvas_.getGL().getGL2(), popup, dirtyRects, buffer, width, height);
        this.canvas_.getContext().release();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserOsr.this.canvas_.display();
            }
        });
    }

    @Override
    public void onCursorChange(CefBrowser browser, final int cursorType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CefBrowserOsr.this.canvas_.setCursor(new Cursor(cursorType));
            }
        });
    }

    @Override
    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser browser, int operation) {
    }

    private void createBrowserIfRequired(boolean hasParent) {
        long windowHandle = 0L;
        if (hasParent) {
            windowHandle = this.getWindowHandle();
        }
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), this.getClient(), windowHandle, true, this.isTransparent_, null, this.getInspectAt());
            } else {
                this.createBrowser(this.getClient(), windowHandle, this.getUrl(), true, this.isTransparent_, null, this.getRequestContext());
            }
        } else {
            this.setFocus(true);
        }
    }
}

