/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProjectEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.testFramework.UsefulTestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public abstract class PlatformLiteFixture
extends UsefulTestCase {
    protected MockProjectEx myProject;

    @NotNull
    public static MockApplication getApplication() {
        MockApplication mockApplication = (MockApplication)ApplicationManager.getApplication();
        if (mockApplication == null) {
            PlatformLiteFixture.$$$reportNull$$$0(0);
        }
        return mockApplication;
    }

    @NotNull
    public MockApplication initApplication() {
        MockApplication app = new MockApplication(this.getTestRootDisposable());
        ApplicationManager.setApplication((Application)app, () -> FileTypeManager.getInstance(), (Disposable)this.getTestRootDisposable());
        app.registerService(EncodingManager.class, EncodingManagerImpl.class);
        MockApplication mockApplication = app;
        if (mockApplication == null) {
            PlatformLiteFixture.$$$reportNull$$$0(1);
        }
        return mockApplication;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myProject = null;
        try {
            super.tearDown();
        }
        finally {
            PlatformLiteFixture.clearFields((Object)this);
        }
    }

    protected <T> void registerExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull T extension) {
        if (extensionPointName == null) {
            PlatformLiteFixture.$$$reportNull$$$0(2);
        }
        if (extension == null) {
            PlatformLiteFixture.$$$reportNull$$$0(3);
        }
        this.registerExtension(Extensions.getRootArea(), extensionPointName, extension);
    }

    public <T> void registerExtension(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> name, @NotNull T extension) {
        if (area == null) {
            PlatformLiteFixture.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PlatformLiteFixture.$$$reportNull$$$0(5);
        }
        if (extension == null) {
            PlatformLiteFixture.$$$reportNull$$$0(6);
        }
        this.registerExtensionPoint(area, name, extension.getClass());
        area.getExtensionPoint(name.getName()).registerExtension(extension, this.getTestRootDisposable());
    }

    protected <T> void registerExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<T> aClass) {
        if (extensionPointName == null) {
            PlatformLiteFixture.$$$reportNull$$$0(7);
        }
        if (aClass == null) {
            PlatformLiteFixture.$$$reportNull$$$0(8);
        }
        this.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass);
    }

    protected <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        if (area == null) {
            PlatformLiteFixture.$$$reportNull$$$0(9);
        }
        if (extensionPointName == null) {
            PlatformLiteFixture.$$$reportNull$$$0(10);
        }
        if (aClass == null) {
            PlatformLiteFixture.$$$reportNull$$$0(11);
        }
        if (!area.hasExtensionPoint(extensionPointName)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            ((ExtensionsAreaImpl)area).registerExtensionPoint(extensionPointName, aClass.getName(), kind, this.getTestRootDisposable());
        }
    }

    protected void registerComponentImplementation(@NotNull MutablePicoContainer container, @NotNull Class<?> key, @NotNull Class<?> implementation) {
        if (container == null) {
            PlatformLiteFixture.$$$reportNull$$$0(12);
        }
        if (key == null) {
            PlatformLiteFixture.$$$reportNull$$$0(13);
        }
        if (implementation == null) {
            PlatformLiteFixture.$$$reportNull$$$0(14);
        }
        container.unregisterComponent(key);
        container.registerComponentImplementation(key, implementation);
    }

    public static <T> T registerComponentInstance(@NotNull MutablePicoContainer container, @NotNull Class<T> key, @NotNull T implementation) {
        if (container == null) {
            PlatformLiteFixture.$$$reportNull$$$0(15);
        }
        if (key == null) {
            PlatformLiteFixture.$$$reportNull$$$0(16);
        }
        if (implementation == null) {
            PlatformLiteFixture.$$$reportNull$$$0(17);
        }
        Object old = container.getComponentInstance(key);
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
        return (T)old;
    }

    public static <T> T registerComponentInstance(@NotNull ComponentManager container, @NotNull Class<T> key, @NotNull T implementation) {
        if (container == null) {
            PlatformLiteFixture.$$$reportNull$$$0(18);
        }
        if (key == null) {
            PlatformLiteFixture.$$$reportNull$$$0(19);
        }
        if (implementation == null) {
            PlatformLiteFixture.$$$reportNull$$$0(20);
        }
        return PlatformLiteFixture.registerComponentInstance((MutablePicoContainer)container.getPicoContainer(), key, implementation);
    }

    protected <T> void registerApplicationService(@NotNull Class<T> aClass, @NotNull T object) {
        if (aClass == null) {
            PlatformLiteFixture.$$$reportNull$$$0(21);
        }
        if (object == null) {
            PlatformLiteFixture.$$$reportNull$$$0(22);
        }
        PlatformLiteFixture.getApplication().registerService(aClass, object, this.getTestRootDisposable());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PlatformLiteFixture";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementation";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplication";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initApplication";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PlatformLiteFixture";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentImplementation";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "registerApplicationService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

