/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.UiInterceptors;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.ListModel;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ChooserInterceptor
extends UiInterceptors.UiInterceptor<JBPopup> {
    final List<String> myOptions;
    final Pattern myToSelect;

    public ChooserInterceptor(@Nullable List<String> expectedOptions, @NotNull @RegExp String pattern) {
        if (pattern == null) {
            ChooserInterceptor.$$$reportNull$$$0(0);
        }
        super(JBPopup.class);
        this.myOptions = expectedOptions;
        this.myToSelect = Pattern.compile(pattern);
    }

    protected void doIntercept(@NotNull JBPopup popup) {
        List matched;
        JBList content;
        if (popup == null) {
            ChooserInterceptor.$$$reportNull$$$0(1);
        }
        JBList jBList = content = popup.isDisposed() ? null : (JBList)UIUtil.findComponentOfType((JComponent)popup.getContent(), JBList.class);
        if (content == null) {
            Assert.fail((String)("JBList not found under " + popup.getContent()));
        }
        ListModel model = content.getModel();
        List actualOptions = IntStreamEx.range((int)model.getSize()).mapToObj(model::getElementAt).map(Object::toString).toList();
        if (this.myOptions != null) {
            Assert.assertEquals(this.myOptions, (Object)actualOptions);
        }
        if ((matched = ((StreamEx)StreamEx.of((Collection)actualOptions).filter(opt -> this.myToSelect.matcher((CharSequence)opt).matches())).toList()).isEmpty()) {
            Assert.fail((String)("No option matches pattern " + this.myToSelect + " (available options: " + String.join((CharSequence)", ", actualOptions) + ")"));
        }
        if (matched.size() > 1) {
            Assert.fail((String)("Several options matched: " + matched + " (pattern: " + this.myToSelect + ")"));
        }
        content.setSelectedIndex(actualOptions.indexOf(matched.get(0)));
        Assert.assertTrue((boolean)popup.canClose());
        popup.closeOk(null);
    }

    public String toString() {
        return "Popup Chooser where '" + this.myToSelect + "' should be selected";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/ChooserInterceptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doIntercept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

