/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.io.DirectoryContentBuilder;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.impl.DirectoryContentBuilderImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0086\b\u001a\"\u0010\u0007\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0086\b\u001a\u0012\u0010\b\u001a\u00020\u0005*\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\u0001\u00a8\u0006\r"}, d2={"directoryContent", "Lcom/intellij/util/io/DirectoryContentSpec;", "content", "Lkotlin/Function1;", "Lcom/intellij/util/io/DirectoryContentBuilder;", "", "Lkotlin/ExtensionFunctionType;", "zipFile", "assertMatches", "Ljava/io/File;", "spec", "generateInVirtualTempDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.testFramework"})
public final class DirectoryContentSpecKt {
    @NotNull
    public static final DirectoryContentSpec directoryContent(@NotNull Function1<? super DirectoryContentBuilder, Unit> content) {
        int $i$f$directoryContent = 0;
        Intrinsics.checkParameterIsNotNull(content, (String)"content");
        DirectoryContentBuilderImpl builder = new DirectoryContentBuilderImpl(new DirectorySpec());
        content.invoke((Object)builder);
        return builder.getResult();
    }

    @NotNull
    public static final DirectoryContentSpec zipFile(@NotNull Function1<? super DirectoryContentBuilder, Unit> content) {
        int $i$f$zipFile = 0;
        Intrinsics.checkParameterIsNotNull(content, (String)"content");
        DirectoryContentBuilderImpl builder = new DirectoryContentBuilderImpl(new ZipSpec());
        content.invoke((Object)builder);
        return builder.getResult();
    }

    public static final void assertMatches(@NotNull File $this$assertMatches, @NotNull DirectoryContentSpec spec) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertMatches, (String)"$this$assertMatches");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        DirectoryContentSpecImplKt.assertDirectoryContentMatches($this$assertMatches, (DirectoryContentSpecImpl)spec, "");
    }

    @NotNull
    public static final VirtualFile generateInVirtualTempDir(@NotNull DirectoryContentSpec $this$generateInVirtualTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateInVirtualTempDir, (String)"$this$generateInVirtualTempDir");
        File ioFile = $this$generateInVirtualTempDir.generateInTempDir();
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026indFileByIoFile(ioFile)!!");
        VirtualFile virtualFile2 = virtualFile;
        UsefulTestCase.refreshRecursively(virtualFile2);
        return virtualFile2;
    }
}

