/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt$WhenMappings;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.DirectorySpecBase;
import com.intellij.util.io.impl.FileSpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0007*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"assertDirectoryContentMatches", "", "file", "Ljava/io/File;", "spec", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "relativePath", "", "assertDirectoryMatches", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "convertToText", "", "intellij.platform.testFramework"})
public final class DirectoryContentSpecImplKt {
    public static final void assertDirectoryContentMatches(@NotNull File file2, @NotNull DirectoryContentSpecImpl spec, @NotNull String relativePath) {
        block4: {
            byte[] actualBytes;
            DirectoryContentSpecImpl directoryContentSpecImpl;
            block5: {
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
                    Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                    Assert.assertTrue((String)(file2 + " doesn't exist"), (boolean)file2.exists());
                    directoryContentSpecImpl = spec;
                    if (!(directoryContentSpecImpl instanceof DirectorySpec)) break block3;
                    DirectoryContentSpecImplKt.assertDirectoryMatches(file2, (DirectorySpecBase)spec, relativePath);
                    break block4;
                }
                if (!(directoryContentSpecImpl instanceof ZipSpec)) break block5;
                Assert.assertTrue((String)(file2 + " is not a file"), (boolean)file2.isFile());
                File file3 = FileUtil.createTempDirectory((String)("extracted-" + file2.getName()), null, (boolean)false);
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"FileUtil.createTempDirec\u2026file.name}\", null, false)");
                File dirForExtracted = file3;
                ZipUtil.extract((File)file2, (File)dirForExtracted, null);
                DirectoryContentSpecImplKt.assertDirectoryMatches(dirForExtracted, (DirectorySpecBase)spec, relativePath);
                FileUtil.delete((File)dirForExtracted);
                break block4;
            }
            if (!(directoryContentSpecImpl instanceof FileSpec)) break block4;
            Assert.assertTrue((String)(file2 + " is not a file"), (boolean)file2.isFile());
            if (((FileSpec)spec).getContent() != null && !Arrays.equals(actualBytes = FileUtil.loadFileBytes((File)file2), ((FileSpec)spec).getContent())) {
                String place;
                Intrinsics.checkExpressionValueIsNotNull((Object)actualBytes, (String)"actualBytes");
                String actualString = DirectoryContentSpecImplKt.convertToText(actualBytes);
                String expectedString = DirectoryContentSpecImplKt.convertToText(((FileSpec)spec).getContent());
                String string = place = Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true ? " at " + relativePath : "";
                if (actualString != null && expectedString != null) {
                    Assert.assertEquals((String)("File content mismatch" + place + ':'), (Object)expectedString, (Object)actualString);
                } else {
                    Assert.fail((String)("Binary file content mismatch" + place));
                }
            }
        }
    }

    private static final String convertToText(@NotNull byte[] $this$convertToText) {
        Charset charset;
        CharsetToolkit.GuessedEncoding guessedEncoding = new CharsetToolkit($this$convertToText, Charsets.UTF_8).guessFromContent($this$convertToText.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)guessedEncoding, (String)"CharsetToolkit(this, Cha\u20268).guessFromContent(size)");
        CharsetToolkit.GuessedEncoding encoding = guessedEncoding;
        switch (DirectoryContentSpecImplKt$WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
            case 1: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 2: {
                charset = Charsets.UTF_8;
                break;
            }
            default: {
                return null;
            }
        }
        Charset charset2 = charset;
        boolean bl = false;
        return new String($this$convertToText, charset2);
    }

    private static final void assertDirectoryMatches(File file2, DirectorySpecBase spec, String relativePath) {
        Assert.assertTrue((String)(file2 + " is not a directory"), (boolean)file2.isDirectory());
        Object[] objectArray = file2.list();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"file.list()");
        List actualChildrenNames = ArraysKt.sortedWith((Object[])objectArray, (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Map<String, DirectoryContentSpecImpl> children = spec.getChildren();
        List expectedChildrenNames = CollectionsKt.sortedWith((Iterable)children.keySet(), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Assert.assertEquals((String)("Directory content mismatch" + (Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true ? " at " + relativePath : "") + ':'), (Object)CollectionsKt.joinToString$default((Iterable)expectedChildrenNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (Object)CollectionsKt.joinToString$default((Iterable)actualChildrenNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        Iterable $this$forEach$iv = actualChildrenNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String child = (String)element$iv;
            boolean bl = false;
            File file3 = new File(file2, child);
            DirectoryContentSpecImpl directoryContentSpecImpl = children.get(child);
            if (directoryContentSpecImpl == null) {
                Intrinsics.throwNpe();
            }
            DirectoryContentSpecImplKt.assertDirectoryContentMatches(file3, directoryContentSpecImpl, relativePath + '/' + child);
        }
    }
}

