/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionWorker {
    @NonNls
    private static final String AT = "at";
    private static final String AT_PREFIX = "at ";
    private static final String STANDALONE_AT = " at ";
    private final Project myProject;
    private Filter.Result myResult;
    private PsiClass[] myClasses;
    private PsiFile[] myFiles;
    private String myMethod;
    private ParsedLine myInfo;
    private final ExceptionInfoCache myCache;
    private PsiElementFilter myLocationRefiner;

    public ExceptionWorker(@NotNull ExceptionInfoCache cache) {
        if (cache == null) {
            ExceptionWorker.$$$reportNull$$$0(0);
        }
        this.myClasses = PsiClass.EMPTY_ARRAY;
        this.myFiles = PsiFile.EMPTY_ARRAY;
        this.myProject = cache.getProject();
        this.myCache = cache;
    }

    public Filter.Result execute(@NotNull String line, int textEndOffset) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(1);
        }
        return this.execute(line, textEndOffset, null);
    }

    public Filter.Result execute(@NotNull String line, int textEndOffset, @Nullable PsiElementFilter elementMatcher) {
        ArrayList<VirtualFile> virtualFiles;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(2);
        }
        this.myResult = null;
        this.myInfo = ExceptionWorker.parseExceptionLine(line);
        if (this.myInfo == null || this.myProject.isDisposed()) {
            return null;
        }
        this.myMethod = this.myInfo.methodNameRange.substring(line);
        Pair<PsiClass[], PsiFile[]> pair = this.myCache.resolveClass(this.myInfo.classFqnRange.substring(line).trim());
        this.myClasses = (PsiClass[])pair.first;
        this.myFiles = (PsiFile[])pair.second;
        if (this.myFiles.length == 0 && this.myInfo.fileName != null) {
            this.myFiles = PsiShortNamesCache.getInstance(this.myProject).getFilesByName(this.myInfo.fileName);
        }
        if (this.myFiles.length == 0) {
            return null;
        }
        int textStartOffset = textEndOffset - line.length();
        int highlightStartOffset = textStartOffset + this.myInfo.fileLineRange.getStartOffset();
        int highlightEndOffset = textStartOffset + this.myInfo.fileLineRange.getEndOffset();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        ArrayList<VirtualFile> virtualFilesInLibraries = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> virtualFilesInContent = new ArrayList<VirtualFile>();
        for (PsiFile file : this.myFiles) {
            VirtualFile virtualFile = file.getVirtualFile();
            if (index.isInContent(virtualFile)) {
                virtualFilesInContent.add(virtualFile);
                continue;
            }
            virtualFilesInLibraries.add(virtualFile);
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
        if (virtualFilesInContent.isEmpty()) {
            Color libTextColor = UIUtil.getInactiveTextColor();
            attributes = attributes.clone();
            attributes.setForegroundColor(libTextColor);
            attributes.setEffectColor(libTextColor);
            virtualFiles = virtualFilesInLibraries;
        } else {
            virtualFiles = virtualFilesInContent;
        }
        ExceptionColumnFinder columnFinder = elementMatcher == null || this.myInfo.lineNumber <= 0 ? null : new ExceptionColumnFinder(elementMatcher, this.myInfo.lineNumber - 1);
        HyperlinkInfo linkInfo = HyperlinkInfoFactory.getInstance().createMultipleFilesHyperlinkInfo(virtualFiles, this.myInfo.lineNumber - 1, this.myProject, (ToIntFunction)columnFinder);
        Filter.Result result = new Filter.Result(highlightStartOffset, highlightEndOffset, linkInfo, attributes);
        this.myLocationRefiner = this.myMethod.startsWith("access$") ? elementMatcher : (this.myMethod.startsWith("lambda$") ? new FunctionCallMatcher() : new StackFrameMatcher(line, this.myInfo));
        this.myResult = result;
        return result;
    }

    public PsiElementFilter getLocationRefiner() {
        return this.myLocationRefiner;
    }

    private static int getLineNumber(@NotNull String lineString) {
        if (lineString == null) {
            ExceptionWorker.$$$reportNull$$$0(3);
        }
        if (lineString.isEmpty() || lineString.length() > 9 || !Character.isDigit(lineString.charAt(0))) {
            return -1;
        }
        try {
            return Integer.parseInt(lineString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @NotNull
    Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExceptionWorker.$$$reportNull$$$0(4);
        }
        return project;
    }

    public Filter.Result getResult() {
        return this.myResult;
    }

    public PsiClass getPsiClass() {
        return (PsiClass)ArrayUtil.getFirstElement((Object[])this.myClasses);
    }

    public String getMethod() {
        return this.myMethod;
    }

    public PsiFile getFile() {
        return (PsiFile)ArrayUtil.getFirstElement((Object[])this.myFiles);
    }

    public ParsedLine getInfo() {
        return this.myInfo;
    }

    private static int findAtPrefix(@NotNull String line) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(5);
        }
        if (line.startsWith(AT_PREFIX)) {
            return 0;
        }
        int startIdx = line.indexOf(STANDALONE_AT);
        return startIdx < 0 ? line.indexOf(AT_PREFIX) : startIdx;
    }

    private static int findFirstRParenAfterDigit(@NotNull String line) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(6);
        }
        int rParenIdx = -1;
        int rParenCandidate = line.lastIndexOf(41);
        while (rParenCandidate > 0) {
            if (Character.isDigit(line.charAt(rParenCandidate - 1))) {
                rParenIdx = rParenCandidate;
            }
            rParenCandidate = line.lastIndexOf(41, rParenCandidate - 1);
        }
        return rParenIdx;
    }

    @Nullable
    public static ParsedLine parseExceptionLine(@NotNull String line) {
        ParsedLine result;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(7);
        }
        if ((result = ExceptionWorker.parseNormalStackTraceLine(line)) == null) {
            result = ExceptionWorker.parseYourKitLine(line);
        }
        if (result == null) {
            result = ExceptionWorker.parseForcedLine(line);
        }
        return result;
    }

    @Nullable
    private static ParsedLine parseNormalStackTraceLine(@NotNull String line) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(8);
        }
        int startIdx = ExceptionWorker.findAtPrefix(line);
        int rParenIdx = ExceptionWorker.findFirstRParenAfterDigit(line);
        if (rParenIdx < 0) {
            return null;
        }
        TextRange methodName = ExceptionWorker.findMethodNameCandidateBefore(line, startIdx, rParenIdx);
        if (methodName == null) {
            return null;
        }
        int lParenIdx = methodName.getEndOffset();
        int dotIdx = methodName.getStartOffset() - 1;
        int moduleIdx = line.indexOf(47);
        int classNameIdx = moduleIdx > -1 && moduleIdx < dotIdx ? moduleIdx + 1 : startIdx + 1 + (startIdx >= 0 ? AT.length() : 0);
        return ParsedLine.createFromFileAndLine(new TextRange(classNameIdx, ExceptionWorker.handleSpaces(line, dotIdx, -1)), ExceptionWorker.trimRange(line, methodName), lParenIdx + 1, rParenIdx, line);
    }

    @NotNull
    private static TextRange trimRange(@NotNull String line, @NotNull TextRange range) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(9);
        }
        if (range == null) {
            ExceptionWorker.$$$reportNull$$$0(10);
        }
        int start = ExceptionWorker.handleSpaces(line, range.getStartOffset(), 1);
        int end = ExceptionWorker.handleSpaces(line, range.getEndOffset(), -1);
        if (start != range.getStartOffset() || end != range.getEndOffset()) {
            TextRange textRange = TextRange.create((int)start, (int)end);
            if (textRange == null) {
                ExceptionWorker.$$$reportNull$$$0(11);
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            ExceptionWorker.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    @Nullable
    private static ParsedLine parseYourKitLine(@NotNull String line) {
        int lineEnd;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(13);
        }
        if ((lineEnd = line.length() - 1) > 0 && line.charAt(lineEnd) == '\n') {
            --lineEnd;
        }
        if (lineEnd > 0 && Character.isDigit(line.charAt(lineEnd))) {
            TextRange methodName;
            int spaceIndex = line.lastIndexOf(32);
            int rParenIdx = line.lastIndexOf(41);
            if (rParenIdx > 0 && spaceIndex == rParenIdx + 1 && (methodName = ExceptionWorker.findMethodNameCandidateBefore(line, 0, rParenIdx)) != null) {
                return ParsedLine.createFromFileAndLine(new TextRange(0, methodName.getStartOffset() - 1), methodName, spaceIndex + 1, lineEnd + 1, line);
            }
        }
        return null;
    }

    @Nullable
    private static ParsedLine parseForcedLine(@NotNull String line) {
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(14);
        }
        String dash = "- ";
        if (!line.trim().startsWith(dash)) {
            return null;
        }
        String linePrefix = "line=";
        int lineNumberStart = line.indexOf(linePrefix);
        if (lineNumberStart < 0) {
            return null;
        }
        int lineNumberEnd = line.indexOf(32, lineNumberStart);
        if (lineNumberEnd < 0) {
            return null;
        }
        TextRange methodName = ExceptionWorker.findMethodNameCandidateBefore(line, 0, lineNumberStart);
        if (methodName == null) {
            return null;
        }
        int lineNumber = ExceptionWorker.getLineNumber(line.substring(lineNumberStart + linePrefix.length(), lineNumberEnd));
        if (lineNumber < 0) {
            return null;
        }
        return new ParsedLine(ExceptionWorker.trimRange(line, TextRange.create((int)(line.indexOf(dash) + dash.length()), (int)(methodName.getStartOffset() - 1))), methodName, TextRange.create((int)lineNumberStart, (int)lineNumberEnd), null, lineNumber);
    }

    private static TextRange findMethodNameCandidateBefore(@NotNull String line, int start, int end) {
        int lParenIdx;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(15);
        }
        if ((lParenIdx = line.lastIndexOf(40, end)) < 0) {
            return null;
        }
        int dotIdx = line.lastIndexOf(46, lParenIdx);
        if (dotIdx < 0 || dotIdx < start) {
            return null;
        }
        return TextRange.create((int)(dotIdx + 1), (int)lParenIdx);
    }

    private static int handleSpaces(@NotNull String line, int pos, int delta) {
        char c;
        if (line == null) {
            ExceptionWorker.$$$reportNull$$$0(16);
        }
        int len = line.length();
        while (pos >= 0 && pos < len && Character.isSpaceChar(c = line.charAt(pos))) {
            pos += delta;
        }
        return pos;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineString";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/ExceptionWorker";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/ExceptionWorker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "trimRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumber";
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAtPrefix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFirstRParenAfterDigit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseExceptionLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseNormalStackTraceLine";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "trimRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseYourKitLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseForcedLine";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMethodNameCandidateBefore";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleSpaces";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FunctionCallMatcher
    implements PsiElementFilter {
        private FunctionCallMatcher() {
        }

        public boolean isAccepted(@NotNull PsiElement element) {
            if (element == null) {
                FunctionCallMatcher.$$$reportNull$$$0(0);
            }
            if (!(element instanceof PsiIdentifier)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
            if (call == null) {
                return false;
            }
            PsiMethod target = call.resolveMethod();
            if (target == null) {
                return false;
            }
            return LambdaUtil.getFunctionalInterfaceMethod(target.getContainingClass()) == target;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/filters/ExceptionWorker$FunctionCallMatcher", "isAccepted"));
        }
    }

    private static class ExceptionColumnFinder
    implements ToIntFunction<PsiFile> {
        private final PsiElementFilter myElementMatcher;
        private final int myLineNumber;

        private ExceptionColumnFinder(@NotNull PsiElementFilter elementMatcher, int lineNumber) {
            if (elementMatcher == null) {
                ExceptionColumnFinder.$$$reportNull$$$0(0);
            }
            this.myElementMatcher = elementMatcher;
            this.myLineNumber = lineNumber;
        }

        @Override
        public int applyAsInt(PsiFile file) {
            if (DumbService.isDumb((Project)file.getProject())) {
                return 0;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
            if (document == null || document.getLineCount() <= this.myLineNumber) {
                return 0;
            }
            if (!PsiDocumentManager.getInstance((Project)file.getProject()).isCommitted(document)) {
                return 0;
            }
            int startOffset = document.getLineStartOffset(this.myLineNumber);
            int endOffset = document.getLineEndOffset(this.myLineNumber);
            PsiElement element = file.findElementAt(startOffset);
            ArrayList<PsiElement> candidates = new ArrayList<PsiElement>();
            while (element != null && element.getTextRange().getStartOffset() < endOffset) {
                if (this.myElementMatcher.isAccepted(element)) {
                    candidates.add(element);
                    if (candidates.size() > 1) {
                        return 0;
                    }
                }
                element = PsiTreeUtil.nextLeaf((PsiElement)element);
            }
            if (candidates.size() == 1) {
                return ((PsiElement)candidates.get(0)).getTextRange().getStartOffset() - startOffset;
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementMatcher", "com/intellij/execution/filters/ExceptionWorker$ExceptionColumnFinder", "<init>"));
        }
    }

    private static class StackFrameMatcher
    implements PsiElementFilter {
        private final String myMethodName;
        private final String myClassName;
        private final boolean myHasDollarInName;

        private StackFrameMatcher(@NotNull String line, @NotNull ParsedLine info) {
            if (line == null) {
                StackFrameMatcher.$$$reportNull$$$0(0);
            }
            if (info == null) {
                StackFrameMatcher.$$$reportNull$$$0(1);
            }
            this.myMethodName = info.methodNameRange.substring(line);
            this.myClassName = info.classFqnRange.substring(line);
            this.myHasDollarInName = StringUtil.getShortName((String)this.myClassName).contains("$");
        }

        public boolean isAccepted(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                StackFrameMatcher.$$$reportNull$$$0(2);
            }
            if (!(element instanceof PsiIdentifier)) {
                return false;
            }
            if (this.myMethodName.equals("<init>")) {
                if (this.myHasDollarInName || element.textMatches((CharSequence)StringUtil.getShortName((String)this.myClassName))) {
                    PsiElement parent2 = element.getParent();
                    while (parent2 instanceof PsiJavaCodeReferenceElement) {
                        parent2 = parent2.getParent();
                    }
                    if (parent2 instanceof PsiAnonymousClass) {
                        return this.isTargetClass(parent2) || this.isTargetClass(((PsiAnonymousClass)parent2).getSuperClass());
                    }
                    if (parent2 instanceof PsiNewExpression) {
                        PsiJavaCodeReferenceElement ref = ((PsiNewExpression)parent2).getClassOrAnonymousClassReference();
                        return ref != null && this.isTargetClass(ref.resolve());
                    }
                }
            } else if (element.textMatches((CharSequence)this.myMethodName) && (parent = element.getParent()) instanceof PsiReferenceExpression) {
                PsiElement target = ((PsiReferenceExpression)parent).resolve();
                return target instanceof PsiMethod && this.isTargetClass(((PsiMethod)target).getContainingClass());
            }
            return false;
        }

        private boolean isTargetClass(PsiElement maybeClass) {
            if (!(maybeClass instanceof PsiClass)) {
                return false;
            }
            PsiClass declaredClass = (PsiClass)maybeClass;
            String declaredName = declaredClass.getQualifiedName();
            if (this.myClassName.equals(declaredName)) {
                return true;
            }
            PsiClass calledClass = ClassUtil.findPsiClass(maybeClass.getManager(), this.myClassName, declaredClass, true);
            if (calledClass == null) {
                calledClass = ClassUtil.findPsiClass(maybeClass.getManager(), this.myClassName, null, true);
            }
            return calledClass == declaredClass || declaredName != null && InheritanceUtil.isInheritor(calledClass, false, declaredName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/filters/ExceptionWorker$StackFrameMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAccepted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ParsedLine {
        @NotNull
        public final TextRange classFqnRange;
        @NotNull
        public final TextRange methodNameRange;
        @NotNull
        public final TextRange fileLineRange;
        @Nullable
        public final String fileName;
        public final int lineNumber;

        ParsedLine(@NotNull TextRange classFqnRange, @NotNull TextRange methodNameRange, @NotNull TextRange fileLineRange, @Nullable String fileName, int lineNumber) {
            if (classFqnRange == null) {
                ParsedLine.$$$reportNull$$$0(0);
            }
            if (methodNameRange == null) {
                ParsedLine.$$$reportNull$$$0(1);
            }
            if (fileLineRange == null) {
                ParsedLine.$$$reportNull$$$0(2);
            }
            this.classFqnRange = classFqnRange;
            this.methodNameRange = methodNameRange;
            this.fileLineRange = fileLineRange;
            this.fileName = fileName;
            this.lineNumber = lineNumber;
        }

        @Nullable
        private static ParsedLine createFromFileAndLine(@NotNull TextRange classFqnRange, @NotNull TextRange methodNameRange, int fileLineStart, int fileLineEnd, @NotNull String line) {
            TextRange fileLineRange;
            String fileAndLine;
            int colonIndex;
            if (classFqnRange == null) {
                ParsedLine.$$$reportNull$$$0(3);
            }
            if (methodNameRange == null) {
                ParsedLine.$$$reportNull$$$0(4);
            }
            if (line == null) {
                ParsedLine.$$$reportNull$$$0(5);
            }
            if ((colonIndex = (fileAndLine = (fileLineRange = TextRange.create((int)fileLineStart, (int)fileLineEnd)).substring(line)).lastIndexOf(58)) < 0) {
                return null;
            }
            int lineNumber = ExceptionWorker.getLineNumber(fileAndLine.substring(colonIndex + 1));
            if (lineNumber < 0) {
                return null;
            }
            return new ParsedLine(classFqnRange, methodNameRange, fileLineRange, fileAndLine.substring(0, colonIndex).trim(), lineNumber);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFqnRange";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNameRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileLineRange";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/filters/ExceptionWorker$ParsedLine";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFromFileAndLine";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

