/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className) {
        if (className != null) {
            int i = className.lastIndexOf(46);
            return i == -1 ? "" : className.substring(0, i);
        }
        return null;
    }

    @NotNull
    public static String extractClassName(@NotNull String fqName) {
        int i;
        if (fqName == null) {
            ClassUtil.$$$reportNull$$$0(0);
        }
        String string = (i = fqName.lastIndexOf(46)) == -1 ? fqName : fqName.substring(i + 1);
        if (string == null) {
            ClassUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String createNewClassQualifiedName(String qualifiedName, String className) {
        if (className == null) {
            return null;
        }
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return className;
        }
        return qualifiedName + "." + ClassUtil.extractClassName(className);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (JavaDirectoryService.getInstance().isSourceRoot(containingDirectory)) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(@NotNull PsiClass aClass, @NotNull StringBuilder buf) {
        String qName;
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(2);
        }
        if (buf == null) {
            ClassUtil.$$$reportNull$$$0(3);
        }
        if ((qName = aClass.getQualifiedName()) != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass, parentClass));
                String name = aClass.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    private static int getNonQualifiedClassIdx(@NotNull PsiClass psiClass, @NotNull PsiClass containingClass) {
        if (psiClass == null) {
            ClassUtil.$$$reportNull$$$0(4);
        }
        if (containingClass == null) {
            ClassUtil.$$$reportNull$$$0(5);
        }
        TObjectIntHashMap indices = (TObjectIntHashMap)CachedValuesManager.getCachedValue((PsiElement)containingClass, () -> {
            TObjectIntHashMap map = new TObjectIntHashMap();
            int index = 0;
            for (PsiClass aClass : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)containingClass)).postOrderDfsTraversal().filter(PsiClass.class)) {
                if (aClass.getQualifiedName() != null) continue;
                map.put((Object)aClass, ++index);
            }
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{containingClass});
        });
        return indices.get((Object)psiClass);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, final @NotNull PsiClass containingClass, final boolean jvmCompatible) {
        String prefix;
        if (indexName == null) {
            ClassUtil.$$$reportNull$$$0(6);
        }
        if (containingClass == null) {
            ClassUtil.$$$reportNull$$$0(7);
        }
        final int idx = !(prefix = ClassUtil.getDigitPrefix(indexName)).isEmpty() ? Integer.parseInt(prefix) : -1;
        final String name = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result = new PsiClass[1];
        containingClass.accept(new JavaRecursiveElementVisitor(){
            private int myCurrentIdx;

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result[0] == null) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                if (!jvmCompatible) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual((String)name, (String)aClass.getName())) {
                            result[0] = aClass;
                        }
                    }
                    return;
                }
                if (aClass == containingClass) {
                    super.visitClass(aClass);
                    return;
                }
                if (Comparing.strEqual((String)name, (String)aClass.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result[0] = aClass;
                    }
                }
            }

            @Override
            public void visitTypeParameter(PsiTypeParameter classParameter) {
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/ClassUtil$1", "visitElement"));
            }
        });
        return result[0];
    }

    @NotNull
    private static String getDigitPrefix(@NotNull String indexName) {
        char c;
        int i;
        if (indexName == null) {
            ClassUtil.$$$reportNull$$$0(8);
        }
        for (i = 0; i < indexName.length() && Character.isDigit(c = indexName.charAt(i)); ++i) {
        }
        String string = i == 0 ? "" : indexName.substring(0, i);
        if (string == null) {
            ClassUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(10);
        }
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(11);
        }
        return ClassUtil.findPsiClass(manager, name, null, false);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent, boolean jvmCompatible) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(12);
        }
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(13);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
        return ClassUtil.findPsiClass(manager, name, parent, jvmCompatible, scope);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager manager, @NotNull String name, @Nullable PsiClass parent, boolean jvmCompatible, @NotNull GlobalSearchScope scope) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(14);
        }
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            ClassUtil.$$$reportNull$$$0(16);
        }
        if (parent != null) {
            return ClassUtil.findSubClass(name, parent, jvmCompatible);
        }
        PsiClass result = JavaPsiFacade.getInstance(manager.getProject()).findClass(name, scope);
        if (result != null) {
            return result;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            parent = JavaPsiFacade.getInstance(manager.getProject()).findClass(prefix, scope);
            if (parent == null || (result = ClassUtil.findSubClass(suffix = name.substring(p + 1), parent, jvmCompatible)) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static PsiClass findSubClass(@NotNull String name, @NotNull PsiClass parent, boolean jvmCompatible) {
        PsiClass result;
        if (name == null) {
            ClassUtil.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            ClassUtil.$$$reportNull$$$0(18);
        }
        PsiClass psiClass = result = ClassUtil.isIndexed(name) ? ClassUtil.findNonQualifiedClassByIndex(name, parent, jvmCompatible) : parent.findInnerClassByName(name, false);
        if (result != null) {
            return result;
        }
        int p = 0;
        while ((p = name.indexOf(36, p + 1)) > 0 && p < name.length() - 1) {
            String suffix;
            String prefix = name.substring(0, p);
            PsiClass subClass = ClassUtil.isIndexed(prefix) ? ClassUtil.findNonQualifiedClassByIndex(prefix, parent, jvmCompatible) : parent.findInnerClassByName(prefix, false);
            if (subClass == null || (result = ClassUtil.findSubClass(suffix = name.substring(p + 1), subClass, jvmCompatible)) == null) continue;
            return result;
        }
        return null;
    }

    private static boolean isIndexed(String name) {
        return Character.isDigit(name.charAt(0));
    }

    @Nullable
    public static String getJVMClassName(@NotNull PsiClass aClass) {
        PsiClass containingClass;
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(19);
        }
        if ((containingClass = aClass.getContainingClass()) != null) {
            String parentName = ClassUtil.getJVMClassName(containingClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    @Nullable
    public static PsiClass findPsiClassByJVMName(@NotNull PsiManager manager, @NotNull String jvmClassName) {
        if (manager == null) {
            ClassUtil.$$$reportNull$$$0(20);
        }
        if (jvmClassName == null) {
            ClassUtil.$$$reportNull$$$0(21);
        }
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }

    public static boolean isTopLevelClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(22);
        }
        if (aClass.getContainingClass() != null) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiElement parent = aClass.getParent();
        if (parent instanceof PsiDeclarationStatement && parent.getParent() instanceof PsiCodeBlock) {
            return false;
        }
        PsiFile parentFile = aClass.getContainingFile();
        return parentFile != null && parentFile.getLanguage() == JavaLanguage.INSTANCE;
    }

    public static String getAsmMethodSignature(PsiMethod method) {
        StringBuilder signature = new StringBuilder();
        signature.append("(");
        for (PsiParameter param : method.getParameterList().getParameters()) {
            signature.append(ClassUtil.getBinaryPresentation(param.getType()));
        }
        signature.append(")");
        signature.append(ClassUtil.getBinaryPresentation(Optional.ofNullable(method.getReturnType()).orElse(PsiType.VOID)));
        return signature.toString();
    }

    public static String getVMParametersMethodSignature(PsiMethod method) {
        return StringUtil.join((Object[])method.getParameterList().getParameters(), param -> {
            PsiType type = TypeConversionUtil.erasure(param.getType());
            return type != null ? type.accept(ClassUtil.createSignatureVisitor()) : "";
        }, (String)",");
    }

    private static PsiTypeVisitor<String> createSignatureVisitor() {
        return new PsiTypeVisitor<String>(){

            @Override
            public String visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                if (primitiveType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return primitiveType.getCanonicalText();
            }

            @Override
            public String visitClassType(@NotNull PsiClassType classType) {
                PsiClass aClass;
                if (classType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((aClass = classType.resolve()) == null) {
                    return "";
                }
                return ClassUtil.getJVMClassName(aClass);
            }

            @Override
            public String visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    2.$$$reportNull$$$0(2);
                }
                PsiType componentType = arrayType.getComponentType();
                String typePresentation = componentType.accept(this);
                if (arrayType.getDeepComponentType() instanceof PsiPrimitiveType) {
                    return typePresentation + "[]";
                }
                if (componentType instanceof PsiClassType) {
                    typePresentation = "L" + typePresentation + ";";
                }
                return "[" + typePresentation;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "primitiveType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/util/ClassUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPrimitiveType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static String getClassObjectPresentation(@NotNull PsiType psiType) {
        if (psiType == null) {
            ClassUtil.$$$reportNull$$$0(23);
        }
        return ClassUtil.toBinary(psiType, false);
    }

    @NotNull
    public static String getBinaryPresentation(@NotNull PsiType psiType) {
        if (psiType == null) {
            ClassUtil.$$$reportNull$$$0(24);
        }
        return ClassUtil.toBinary(psiType, true);
    }

    @NotNull
    private static String toBinary(@NotNull PsiType psiType, boolean slashes) {
        if (psiType == null) {
            ClassUtil.$$$reportNull$$$0(25);
        }
        String string = Optional.of(psiType).map(type -> TypeConversionUtil.erasure(type)).map(type -> type.accept(ClassUtil.createBinarySignatureVisitor(slashes))).orElseGet(() -> psiType.getPresentableText());
        if (string == null) {
            ClassUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static PsiTypeVisitor<String> createBinarySignatureVisitor(final boolean slashes) {
        return new PsiTypeVisitor<String>(){

            @Override
            public String visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                if (primitiveType == null) {
                    3.$$$reportNull$$$0(0);
                }
                return primitiveType.getKind().getBinaryName();
            }

            @Override
            public String visitClassType(@NotNull PsiClassType classType) {
                PsiClass aClass;
                if (classType == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((aClass = classType.resolve()) == null) {
                    return "";
                }
                String jvmClassName = ClassUtil.getJVMClassName(aClass);
                if (jvmClassName != null) {
                    jvmClassName = "L" + (slashes ? jvmClassName.replace(".", "/") : jvmClassName) + ";";
                }
                return jvmClassName;
            }

            @Override
            public String visitArrayType(@NotNull PsiArrayType arrayType) {
                if (arrayType == null) {
                    3.$$$reportNull$$$0(2);
                }
                return "[" + arrayType.getComponentType().accept(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "primitiveType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/util/ClassUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPrimitiveType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/ClassUtil";
                break;
            }
            case 2: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClassName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/ClassUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "extractClassName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDigitPrefix";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "toBinary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractClassName";
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatClassName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNonQualifiedClassIdx";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findNonQualifiedClassByIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDigitPrefix";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findPsiClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findSubClass";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getJVMClassName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findPsiClassByJVMName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelClass";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getClassObjectPresentation";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryPresentation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "toBinary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

