/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.iterators;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.psi.PsiElement;

public final class ArrayBackedNodeIterator
extends NodeIterator {
    private final PsiElement[] nodes;
    private int index;

    public ArrayBackedNodeIterator(PsiElement[] _nodes) {
        this.nodes = _nodes;
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.nodes.length;
    }

    @Override
    public void rewind(int number) {
        this.index -= number;
    }

    @Override
    public PsiElement current() {
        if (this.index < this.nodes.length) {
            return this.nodes[this.index];
        }
        return null;
    }

    @Override
    public void advance() {
        ++this.index;
    }

    @Override
    public void rewind() {
        --this.index;
    }

    @Override
    public void reset() {
        this.index = 0;
    }
}

