/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Interner;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.MutableSyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptorImpl;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRootProxyDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRuleProxyDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxScopeProxyDescriptor;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class TextMateSyntaxTable {
    private static final Logger LOG = Logger.getInstance(TextMateSyntaxTable.class);
    private final Map<CharSequence, SyntaxNodeDescriptor> rulesMap = new THashMap();
    private TObjectIntHashMap<String> ruleIds;

    public void compact() {
        this.ruleIds = null;
    }

    @NotNull
    public CharSequence loadSyntax(Plist plist, @NotNull Interner<CharSequence> interner) {
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(0);
        }
        CharSequence charSequence = this.loadRealNode(plist, null, interner).getScopeName();
        if (charSequence == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    @NotNull
    public SyntaxNodeDescriptor getSyntax(CharSequence scopeName) {
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.rulesMap.get(scopeName);
        if (syntaxNodeDescriptor == null) {
            LOG.debug("Can't find syntax node for scope: '" + scopeName + "'");
            SyntaxNodeDescriptor syntaxNodeDescriptor2 = SyntaxNodeDescriptor.EMPTY_NODE;
            if (syntaxNodeDescriptor2 == null) {
                TextMateSyntaxTable.$$$reportNull$$$0(2);
            }
            return syntaxNodeDescriptor2;
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor3 = syntaxNodeDescriptor;
        if (syntaxNodeDescriptor3 == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(3);
        }
        return syntaxNodeDescriptor3;
    }

    public void clear() {
        this.rulesMap.clear();
    }

    private SyntaxNodeDescriptor loadNestedSyntax(@NotNull Plist plist, @NotNull SyntaxNodeDescriptor parentNode, @NotNull Interner<CharSequence> interner) {
        if (plist == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(4);
        }
        if (parentNode == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(5);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(6);
        }
        return plist.contains("include") ? this.loadProxyNode(plist, parentNode, interner) : this.loadRealNode(plist, parentNode, interner);
    }

    @NotNull
    private SyntaxNodeDescriptor loadRealNode(@NotNull Plist plist, @Nullable SyntaxNodeDescriptor parentNode, @NotNull Interner<CharSequence> interner) {
        if (plist == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(7);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(8);
        }
        SyntaxNodeDescriptorImpl result = new SyntaxNodeDescriptorImpl(parentNode);
        for (Map.Entry<String, PListValue> entry : plist.entries()) {
            PListValue pListValue = entry.getValue();
            if (pListValue == null) continue;
            String key = entry.getKey();
            Constants.StringKey stringKey = Constants.StringKey.fromName(key);
            if (stringKey != null) {
                String stringValue = pListValue.getString();
                if (stringValue == null) continue;
                result.setStringAttribute(stringKey, (CharSequence)interner.intern((Object)stringValue));
                continue;
            }
            Constants.CaptureKey captureKey = Constants.CaptureKey.fromName(key);
            if (captureKey != null) {
                result.setCaptures(captureKey, TextMateSyntaxTable.loadCaptures(pListValue.getPlist(), interner));
                continue;
            }
            if ("repository".equalsIgnoreCase(key)) {
                this.loadRepository(result, pListValue, interner);
                continue;
            }
            if ("patterns".equalsIgnoreCase(key)) {
                this.loadPatterns(result, pListValue, interner);
                continue;
            }
            if (!"injections".equalsIgnoreCase(key)) continue;
            this.loadInjections(result, pListValue, interner);
        }
        if (plist.contains(Constants.StringKey.SCOPE_NAME.value)) {
            CharSequence scopeName = (CharSequence)interner.intern((Object)plist.getPlistValue(Constants.StringKey.SCOPE_NAME.value, "default").getString());
            result.setScopeName(scopeName);
            this.rulesMap.put(scopeName, result);
        }
        result.compact();
        SyntaxNodeDescriptorImpl syntaxNodeDescriptorImpl = result;
        if (syntaxNodeDescriptorImpl == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(9);
        }
        return syntaxNodeDescriptorImpl;
    }

    @Nullable
    private static TIntObjectHashMap<CharSequence> loadCaptures(@NotNull Plist captures, @NotNull Interner<CharSequence> interner) {
        if (captures == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(10);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(11);
        }
        TIntObjectHashMap result = new TIntObjectHashMap();
        for (Map.Entry<String, PListValue> capture : captures.entries()) {
            try {
                int index = Integer.parseInt(capture.getKey());
                Plist captureDict = capture.getValue().getPlist();
                String captureName = captureDict.getPlistValue("name", "").getString();
                result.put(index, interner.intern((Object)captureName));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (result.isEmpty()) {
            return null;
        }
        result.trimToSize();
        return result;
    }

    private SyntaxNodeDescriptor loadProxyNode(@NotNull Plist plist, @NotNull SyntaxNodeDescriptor result, @NotNull Interner<CharSequence> interner) {
        String include;
        if (plist == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(12);
        }
        if (result == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(13);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(14);
        }
        if (StringUtil.startsWithChar((CharSequence)(include = plist.getPlistValue("include", "").getString()), (char)'#')) {
            return new SyntaxRuleProxyDescriptor(this.getRuleId(include.substring(1)), result);
        }
        if ("$self".equalsIgnoreCase(include) || "$base".equalsIgnoreCase(include)) {
            return new SyntaxRootProxyDescriptor(result);
        }
        int i = include.indexOf(35);
        String scope = i >= 0 ? include.subSequence(0, i) : include;
        String ruleId = i >= 0 ? include.substring(i + 1) : "";
        return new SyntaxScopeProxyDescriptor((CharSequence)interner.intern((Object)scope), ruleId.isEmpty() ? -1 : this.getRuleId(ruleId), this, result);
    }

    private void loadPatterns(@NotNull MutableSyntaxNodeDescriptor result, @NotNull PListValue pListValue, @NotNull Interner<CharSequence> interner) {
        if (result == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(15);
        }
        if (pListValue == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(16);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(17);
        }
        for (PListValue value : pListValue.getArray()) {
            result.addChild(this.loadNestedSyntax(value.getPlist(), result, interner));
        }
    }

    private void loadRepository(@NotNull MutableSyntaxNodeDescriptor result, @NotNull PListValue pListValue, @NotNull Interner<CharSequence> interner) {
        if (result == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(18);
        }
        if (pListValue == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(19);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(20);
        }
        for (Map.Entry<String, PListValue> repoEntry : pListValue.getPlist().entries()) {
            PListValue repoEntryValue = repoEntry.getValue();
            if (repoEntryValue == null) continue;
            result.appendRepository(this.getRuleId(repoEntry.getKey()), this.loadNestedSyntax(repoEntryValue.getPlist(), result, interner));
        }
    }

    private int getRuleId(@NotNull String ruleName) {
        int id;
        if (ruleName == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(21);
        }
        if (this.ruleIds == null) {
            this.ruleIds = new TObjectIntHashMap();
        }
        if ((id = this.ruleIds.get((Object)ruleName)) > 0) {
            return id;
        }
        int newId = this.ruleIds.size() + 1;
        this.ruleIds.put((Object)ruleName, newId);
        return newId;
    }

    private void loadInjections(@NotNull MutableSyntaxNodeDescriptor result, @NotNull PListValue pListValue, @NotNull Interner<CharSequence> interner) {
        if (result == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(22);
        }
        if (pListValue == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(23);
        }
        if (interner == null) {
            TextMateSyntaxTable.$$$reportNull$$$0(24);
        }
        for (Map.Entry<String, PListValue> injectionEntry : pListValue.getPlist().entries()) {
            Plist injectionEntryValue = injectionEntry.getValue().getPlist();
            result.addInjection(new InjectionNodeDescriptor(injectionEntry.getKey(), this.loadRealNode(injectionEntryValue, result, interner)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captures";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pListValue";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSyntax";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntax";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRealNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadSyntax";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadNestedSyntax";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadRealNode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadCaptures";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadProxyNode";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadPatterns";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadRepository";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRuleId";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadInjections";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

