/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.google.common.base.Preconditions;
import com.intellij.openapi.util.TextRange;
import org.jcodings.specific.NonStrictUTF8Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;

public class RegexUtil {
    private RegexUtil() {
    }

    public static int charOffsetByByteOffset(byte[] stringBytes, int byteOffset) {
        if (byteOffset <= 0) {
            return 0;
        }
        Preconditions.checkPositionIndex((int)byteOffset, (int)stringBytes.length);
        return NonStrictUTF8Encoding.INSTANCE.strLength(stringBytes, 0, byteOffset);
    }

    public static int byteOffsetByCharOffset(@NotNull CharSequence charSequence, int charOffset) {
        if (charSequence == null) {
            RegexUtil.$$$reportNull$$$0(0);
        }
        if (charOffset <= 0) {
            return 0;
        }
        Preconditions.checkPositionIndex((int)charOffset, (int)charSequence.length());
        int result = 0;
        for (int i = 0; i < charOffset; ++i) {
            result += UTF8Encoding.INSTANCE.codeToMbcLength((int)charSequence.charAt(i));
        }
        return result;
    }

    @NotNull
    public static TextRange charRangeByByteRange(byte[] bytes, @NotNull TextRange byteRange) {
        if (byteRange == null) {
            RegexUtil.$$$reportNull$$$0(1);
        }
        int startOffset = RegexUtil.charOffsetByByteOffset(bytes, byteRange.getStartOffset());
        int endOffset = RegexUtil.charOffsetByByteOffset(bytes, byteRange.getEndOffset());
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            RegexUtil.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/regex/RegexUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/regex/RegexUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "charRangeByByteRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "byteOffsetByCharOffset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "charRangeByByteRange";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

