/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtilRt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Attachment {
    private static final Logger LOG = Logger.getInstance(Attachment.class);
    public static final Attachment[] EMPTY_ARRAY = new Attachment[0];
    private final String myPath;
    private final String myDisplayText;
    private final byte @Nullable [] myBytes;
    @Nullable
    private final File myTemporaryFile;
    private boolean myIncluded;

    public Attachment(@NotNull String name, @NotNull Throwable throwable) {
        if (name == null) {
            Attachment.$$$reportNull$$$0(0);
        }
        if (throwable == null) {
            Attachment.$$$reportNull$$$0(1);
        }
        this(name + ".trace", ExceptionUtil.getThrowableText(throwable));
        this.myIncluded = true;
    }

    public Attachment(@NotNull String path, @NotNull String content) {
        if (path == null) {
            Attachment.$$$reportNull$$$0(2);
        }
        if (content == null) {
            Attachment.$$$reportNull$$$0(3);
        }
        this(path, content, content.getBytes(StandardCharsets.UTF_8), null);
    }

    public Attachment(@NotNull String path, byte @NotNull [] bytes, @NotNull String displayText) {
        if (path == null) {
            Attachment.$$$reportNull$$$0(4);
        }
        if (displayText == null) {
            Attachment.$$$reportNull$$$0(5);
        }
        if (bytes == null) {
            Attachment.$$$reportNull$$$0(6);
        }
        this(path, displayText, bytes, null);
    }

    public Attachment(@NotNull String path, @NotNull File temporaryFile, @NotNull String displayText) {
        if (path == null) {
            Attachment.$$$reportNull$$$0(7);
        }
        if (temporaryFile == null) {
            Attachment.$$$reportNull$$$0(8);
        }
        if (displayText == null) {
            Attachment.$$$reportNull$$$0(9);
        }
        this(path, displayText, null, temporaryFile);
    }

    private Attachment(String path, String displayText, byte @Nullable [] bytes, @Nullable File temporaryFile) {
        assert (bytes != null || temporaryFile != null);
        this.myPath = path;
        this.myDisplayText = displayText;
        this.myBytes = bytes;
        this.myTemporaryFile = temporaryFile;
    }

    @NotNull
    public String getDisplayText() {
        String string = this.myDisplayText;
        if (string == null) {
            Attachment.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            Attachment.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = PathUtilRt.getFileName(this.myPath);
        if (string == null) {
            Attachment.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getEncodedBytes() {
        String string = Base64.getEncoder().encodeToString(this.getBytes());
        if (string == null) {
            Attachment.$$$reportNull$$$0(13);
        }
        return string;
    }

    public byte @NotNull [] getBytes() {
        if (this.myBytes != null) {
            if (this.myBytes == null) {
                Attachment.$$$reportNull$$$0(14);
            }
            return this.myBytes;
        }
        if (this.myTemporaryFile != null) {
            byte[] byArray;
            try {
                byArray = FileUtil.loadFileBytes(this.myTemporaryFile);
            }
            catch (IOException e) {
                LOG.error("Failed to read attachment content from temp. file " + this.myTemporaryFile, e);
            }
            if (byArray == null) {
                Attachment.$$$reportNull$$$0(15);
            }
            return byArray;
        }
        if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
            Attachment.$$$reportNull$$$0(16);
        }
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    @NotNull
    public InputStream openContentStream() {
        if (this.myBytes != null) {
            return new ByteArrayInputStream(this.myBytes);
        }
        if (this.myTemporaryFile != null) {
            try {
                return new FileInputStream(this.myTemporaryFile);
            }
            catch (FileNotFoundException e) {
                LOG.error("Failed to read attachment content from temp. file " + this.myTemporaryFile, e);
            }
        }
        return new ByteArrayInputStream(ArrayUtilRt.EMPTY_BYTE_ARRAY);
    }

    public boolean isIncluded() {
        return this.myIncluded;
    }

    public void setIncluded(boolean included) {
        this.myIncluded = included;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temporaryFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/Attachment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/Attachment";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncodedBytes";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

