/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.SafeJdomFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom.AttributeType;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;

final class SafeStAXStreamBuilder {
    static final SafeJdomFactory FACTORY = new SafeJdomFactory.BaseSafeJdomFactory();

    SafeStAXStreamBuilder() {
    }

    static Document buildDocument(@NotNull XMLStreamReader stream, boolean isIgnoreBoundaryWhitespace) throws JDOMException, XMLStreamException {
        int state;
        if (stream == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(0);
        }
        if (7 != (state = stream.getEventType())) {
            throw new JDOMException("JDOM requires that XMLStreamReaders are at their beginning when being processed.");
        }
        Document document = new Document();
        while (state != 8) {
            switch (state) {
                case 7: {
                    document.setBaseURI(stream.getLocation().getSystemId());
                    document.setProperty("ENCODING_SCHEME", (Object)stream.getCharacterEncodingScheme());
                    document.setProperty("STANDALONE", (Object)String.valueOf(stream.isStandalone()));
                    document.setProperty("ENCODING", (Object)stream.getEncoding());
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                case 1: {
                    document.setRootElement(SafeStAXStreamBuilder.processElementFragment(stream, isIgnoreBoundaryWhitespace, FACTORY));
                    break;
                }
                case 4: {
                    String badTxt = stream.getText();
                    if (Verifier.isAllXMLWhitespace((String)badTxt)) break;
                    throw new JDOMException("Unexpected XMLStream event at Document level: CHARACTERS (" + badTxt + ")");
                }
                default: {
                    throw new JDOMException("Unexpected XMLStream event at Document level:" + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new JDOMException("Unexpected end-of-XMLStreamReader");
        }
        return document;
    }

    static Element build(@NotNull XMLStreamReader stream, boolean isIgnoreBoundaryWhitespace, @NotNull SafeJdomFactory factory) throws JDOMException, XMLStreamException {
        int state;
        if (stream == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(2);
        }
        if (7 != (state = stream.getEventType())) {
            throw new JDOMException("JDOM requires that XMLStreamReaders are at their beginning when being processed");
        }
        Element rootElement = null;
        while (state != 8) {
            switch (state) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    break;
                }
                case 1: {
                    rootElement = SafeStAXStreamBuilder.processElementFragment(stream, isIgnoreBoundaryWhitespace, factory);
                    break;
                }
                default: {
                    throw new JDOMException("Unexpected XMLStream event " + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new JDOMException("Unexpected end-of-XMLStreamReader");
        }
        if (rootElement == null) {
            return new Element("empty");
        }
        return rootElement;
    }

    private static Element processElementFragment(@NotNull XMLStreamReader reader, boolean isIgnoreBoundaryWhitespace, @NotNull SafeJdomFactory factory) throws XMLStreamException, JDOMException {
        Element fragment;
        if (reader == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(3);
        }
        if (factory == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(4);
        }
        if (reader.getEventType() != 1) {
            throw new JDOMException("JDOM requires that the XMLStreamReader is at the START_ELEMENT state when retrieving an Element Fragment.");
        }
        Element current = fragment = SafeStAXStreamBuilder.processElement(reader, factory);
        int depth = 1;
        block8: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element tmp = SafeStAXStreamBuilder.processElement(reader, factory);
                    current.addContent(tmp);
                    current = tmp;
                    ++depth;
                    continue block8;
                }
                case 2: {
                    current = current.getParentElement();
                    --depth;
                    continue block8;
                }
                case 12: {
                    current.addContent((Content)factory.cdata(reader.getText()));
                    continue block8;
                }
                case 6: {
                    if (!isIgnoreBoundaryWhitespace) {
                        current.addContent((Content)factory.text(reader.getText(), current));
                    }
                }
                case 4: {
                    if (isIgnoreBoundaryWhitespace && reader.isWhiteSpace()) continue block8;
                    current.addContent((Content)factory.text(reader.getText(), current));
                    continue block8;
                }
                case 3: 
                case 5: 
                case 9: {
                    continue block8;
                }
            }
            throw new JDOMException("Unexpected XMLStream event " + reader.getEventType());
        }
        return fragment;
    }

    @NotNull
    private static Element processElement(@NotNull XMLStreamReader reader, @NotNull SafeJdomFactory factory) {
        int i;
        if (reader == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(5);
        }
        if (factory == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(6);
        }
        Element element = factory.element(reader.getLocalName(), Namespace.getNamespace((String)reader.getPrefix(), (String)reader.getNamespaceURI()));
        int len = reader.getAttributeCount();
        for (i = 0; i < len; ++i) {
            element.setAttribute(factory.attribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i), AttributeType.getAttributeType((String)reader.getAttributeType(i)), Namespace.getNamespace((String)reader.getAttributePrefix(i), (String)reader.getAttributeNamespace(i))));
        }
        len = reader.getNamespaceCount();
        for (i = 0; i < len; ++i) {
            element.addNamespaceDeclaration(Namespace.getNamespace((String)reader.getNamespacePrefix(i), (String)reader.getNamespaceURI(i)));
        }
        Element element2 = element;
        if (element2 == null) {
            SafeStAXStreamBuilder.$$$reportNull$$$0(7);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/SafeStAXStreamBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/SafeStAXStreamBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildDocument";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processElementFragment";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

