/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.LineHandlerHelper;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;

public class ResultBuilderNotifier
extends ProcessAdapter {
    @NotNull
    private final StringBuilder myStdoutLine;
    @NotNull
    private final StringBuilder myStderrLine;
    @NotNull
    private final LineCommandListener myResultBuilder;

    public ResultBuilderNotifier(@NotNull LineCommandListener resultBuilder) {
        if (resultBuilder == null) {
            ResultBuilderNotifier.$$$reportNull$$$0(0);
        }
        this.myStdoutLine = new StringBuilder();
        this.myStderrLine = new StringBuilder();
        this.myResultBuilder = resultBuilder;
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            ResultBuilderNotifier.$$$reportNull$$$0(1);
        }
        try {
            this.forceNewLine();
        }
        finally {
            this.myResultBuilder.processTerminated(event.getExitCode());
        }
    }

    private void forceNewLine() {
        if (this.myStdoutLine.length() != 0) {
            this.onTextAvailable("\n\r", ProcessOutputTypes.STDOUT);
        } else if (this.myStderrLine.length() != 0) {
            this.onTextAvailable("\n\r", ProcessOutputTypes.STDERR);
        }
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        if (event == null) {
            ResultBuilderNotifier.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            ResultBuilderNotifier.$$$reportNull$$$0(3);
        }
        this.onTextAvailable(event.getText(), outputType);
    }

    private void onTextAvailable(String text, Key outputType) {
        Iterator<String> lines = LineHandlerHelper.splitText((String)text).iterator();
        if (ProcessOutputTypes.STDOUT == outputType) {
            this.notifyLines(outputType, lines, this.myStdoutLine);
        } else if (ProcessOutputTypes.STDERR == outputType) {
            this.notifyLines(outputType, lines, this.myStderrLine);
        }
    }

    private void notifyLines(Key outputType, Iterator<String> lines, StringBuilder lineBuilder) {
        block5: {
            String line;
            if (!lines.hasNext()) {
                return;
            }
            if (lineBuilder.length() > 0) {
                lineBuilder.append(lines.next());
                if (lines.hasNext()) {
                    line = lineBuilder.toString();
                    this.notifyLine(line, outputType);
                    lineBuilder.setLength(0);
                }
            }
            while (true) {
                line = null;
                if (lines.hasNext()) {
                    line = lines.next();
                }
                if (!lines.hasNext()) break;
                this.notifyLine(line, outputType);
            }
            if (line == null || line.length() <= 0) break block5;
            lineBuilder.append(line);
        }
    }

    private void notifyLine(String line, Key outputType) {
        this.myResultBuilder.onLineAvailable(LineHandlerHelper.trimLineSeparator((String)line), outputType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultBuilder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/commandLine/ResultBuilderNotifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

