/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.RevisionRange;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.jetbrains.idea.svn.integrate.MergeClient;

public class CmdMergeClient
extends BaseSvnClient
implements MergeClient {
    @Override
    public void merge(@NotNull Target source, @NotNull File destination, boolean dryRun, boolean reintegrate, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            CmdMergeClient.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            CmdMergeClient.$$$reportNull$$$0(1);
        }
        this.assertUrl(source);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source);
        CmdMergeClient.fillParameters(parameters, destination, null, dryRun, false, false, reintegrate, diffOptions);
        this.run(destination, handler, parameters);
    }

    @Override
    public void merge(@NotNull Target source, @NotNull RevisionRange range, @NotNull File destination, @Nullable Depth depth, boolean dryRun, boolean recordOnly, boolean force, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source == null) {
            CmdMergeClient.$$$reportNull$$$0(2);
        }
        if (range == null) {
            CmdMergeClient.$$$reportNull$$$0(3);
        }
        if (destination == null) {
            CmdMergeClient.$$$reportNull$$$0(4);
        }
        this.assertUrl(source);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, range.getStartRevision(), range.getEndRevision());
        CommandUtil.put(parameters, source);
        CmdMergeClient.fillParameters(parameters, destination, depth, dryRun, recordOnly, force, false, diffOptions);
        this.run(destination, handler, parameters);
    }

    @Override
    public void merge(@NotNull Target source1, @NotNull Target source2, @NotNull File destination, @Nullable Depth depth, boolean useAncestry, boolean dryRun, boolean recordOnly, boolean force, @Nullable DiffOptions diffOptions, @Nullable ProgressTracker handler) throws VcsException {
        if (source1 == null) {
            CmdMergeClient.$$$reportNull$$$0(5);
        }
        if (source2 == null) {
            CmdMergeClient.$$$reportNull$$$0(6);
        }
        if (destination == null) {
            CmdMergeClient.$$$reportNull$$$0(7);
        }
        this.assertUrl(source1);
        this.assertUrl(source2);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, source1);
        CommandUtil.put(parameters, source2);
        CmdMergeClient.fillParameters(parameters, destination, depth, dryRun, recordOnly, force, false, diffOptions);
        CommandUtil.put(parameters, !useAncestry, "--ignore-ancestry");
        this.run(destination, handler, parameters);
    }

    private static void fillParameters(@NotNull List<String> parameters, @NotNull File destination, @Nullable Depth depth, boolean dryRun, boolean recordOnly, boolean force, boolean reintegrate, @Nullable DiffOptions diffOptions) {
        if (parameters == null) {
            CmdMergeClient.$$$reportNull$$$0(8);
        }
        if (destination == null) {
            CmdMergeClient.$$$reportNull$$$0(9);
        }
        CommandUtil.put(parameters, destination);
        CommandUtil.put(parameters, diffOptions);
        CommandUtil.put(parameters, dryRun, "--dry-run");
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, force, "--force");
        CommandUtil.put(parameters, recordOnly, "--record-only");
        parameters.add("--accept");
        parameters.add("postpone");
        CommandUtil.put(parameters, reintegrate, "--reintegrate");
    }

    private void run(File destination, ProgressTracker handler, List<String> parameters) throws VcsException {
        BaseUpdateCommandListener listener2 = new BaseUpdateCommandListener(CommandUtil.requireExistingParent(destination), handler);
        this.execute(this.myVcs, Target.on(destination), SvnCommandName.merge, parameters, (LineCommandListener)listener2);
        listener2.throwWrappedIfException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/integrate/CmdMergeClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "merge";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fillParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

