/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.IntersectingLocalChangesPanel;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.LocalChangesAction;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeContentsVariants;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.QuickMergeWayOptionsPanel;
import org.jetbrains.idea.svn.integrate.SelectMergeItemsResult;
import org.jetbrains.idea.svn.integrate.ToBeMergedDialog;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;

public class QuickMergeInteractionImpl
implements QuickMergeInteraction {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myTitle;

    public QuickMergeInteractionImpl(@NotNull MergeContext mergeContext) {
        if (mergeContext == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(0);
        }
        this.myMergeContext = mergeContext;
        this.myProject = mergeContext.getProject();
        this.myTitle = mergeContext.getTitle();
    }

    @Override
    @NotNull
    public QuickMergeContentsVariants selectMergeVariant() {
        QuickMergeWayOptionsPanel panel = new QuickMergeWayOptionsPanel();
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.title("Select Merge Variant").centerPanel((JComponent)panel.getMainPanel()).removeAllActions();
        panel.setWrapper(builder.getDialogWrapper());
        builder.show();
        QuickMergeContentsVariants quickMergeContentsVariants = panel.getVariant();
        if (quickMergeContentsVariants == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(1);
        }
        return quickMergeContentsVariants;
    }

    @Override
    public boolean shouldContinueSwitchedRootFound() {
        return this.prompt("There are some switched paths in the working copy. Do you want to continue?");
    }

    @Override
    public boolean shouldReintegrate(@NotNull Url targetUrl) {
        if (targetUrl == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(2);
        }
        return this.prompt("<html><body>You are going to reintegrate changes.<br><br>This will make branch '" + this.myMergeContext.getSourceUrl().toDecodedString() + "' <b>no longer usable for further work</b>.<br>It will not be able to correctly absorb new trunk (" + targetUrl.toDecodedString() + ") changes,<br>nor can this branch be properly reintegrated to trunk again.<br><br>Are you sure?</body></html>");
    }

    @Override
    @NotNull
    public SelectMergeItemsResult selectMergeItems(@NotNull List<SvnChangeList> lists, @NotNull MergeChecker mergeChecker, boolean allStatusesCalculated, boolean allListsLoaded) {
        if (lists == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(3);
        }
        if (mergeChecker == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(4);
        }
        ToBeMergedDialog dialog = new ToBeMergedDialog(this.myMergeContext, lists, this.myMergeContext.getTitle(), mergeChecker, allStatusesCalculated, allListsLoaded);
        dialog.show();
        QuickMergeContentsVariants resultCode = QuickMergeInteractionImpl.toMergeVariant(dialog.getExitCode());
        List<SvnChangeList> selectedLists = resultCode == QuickMergeContentsVariants.select ? dialog.getSelected() : ContainerUtil.emptyList();
        return new SelectMergeItemsResult(resultCode, selectedLists);
    }

    @Override
    @NotNull
    public LocalChangesAction selectLocalChangesAction(boolean mergeAll) {
        String message;
        LocalChangesAction[] possibleResults;
        if (!mergeAll) {
            possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.inspect, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            message = "There are local changes that will intersect with merge changes.\nDo you want to continue?";
        } else {
            possibleResults = new LocalChangesAction[]{LocalChangesAction.shelve, LocalChangesAction.continueMerge, LocalChangesAction.cancel};
            message = "There are local changes that can potentially intersect with merge changes.\nDo you want to continue?";
        }
        int result = Messages.showDialog((String)message, (String)this.myTitle, (String[])((String[])ContainerUtil.map2Array((Object[])possibleResults, String.class, (Function)Functions.TO_STRING())), (int)0, (Icon)Messages.getQuestionIcon());
        LocalChangesAction localChangesAction = result == -1 ? LocalChangesAction.cancel : possibleResults[result];
        if (localChangesAction == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(5);
        }
        return localChangesAction;
    }

    @Override
    public void showIntersectedLocalPaths(@NotNull List<FilePath> paths) {
        if (paths == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(6);
        }
        IntersectingLocalChangesPanel.showInVersionControlToolWindow(this.myProject, this.myTitle + ", local changes intersection", paths, "The following file(s) have local changes that will intersect with merge changes:");
    }

    @Override
    public void showErrors(@NotNull String message, @NotNull List<VcsException> exceptions) {
        if (message == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(7);
        }
        if (exceptions == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(8);
        }
        AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(exceptions, message);
    }

    @Override
    public void showErrors(@NotNull String message, boolean isError) {
        if (message == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(9);
        }
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)message, (MessageType)(isError ? MessageType.ERROR : MessageType.WARNING), (NamedRunnable[])new NamedRunnable[0]);
    }

    private boolean prompt(@NotNull String question) {
        if (question == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(10);
        }
        return Messages.showOkCancelDialog((Project)this.myProject, (String)question, (String)this.myTitle, (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    private static QuickMergeContentsVariants toMergeVariant(int exitCode) {
        switch (exitCode) {
            case 222: {
                QuickMergeContentsVariants quickMergeContentsVariants = QuickMergeContentsVariants.all;
                if (quickMergeContentsVariants == null) {
                    QuickMergeInteractionImpl.$$$reportNull$$$0(11);
                }
                return quickMergeContentsVariants;
            }
            case 0: {
                QuickMergeContentsVariants quickMergeContentsVariants = QuickMergeContentsVariants.select;
                if (quickMergeContentsVariants == null) {
                    QuickMergeInteractionImpl.$$$reportNull$$$0(12);
                }
                return quickMergeContentsVariants;
            }
        }
        QuickMergeContentsVariants quickMergeContentsVariants = QuickMergeContentsVariants.cancel;
        if (quickMergeContentsVariants == null) {
            QuickMergeInteractionImpl.$$$reportNull$$$0(13);
        }
        return quickMergeContentsVariants;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContext";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeChecker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "question";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/QuickMergeInteractionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMergeVariant";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "selectLocalChangesAction";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toMergeVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldReintegrate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectMergeItems";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showIntersectedLocalPaths";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showErrors";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prompt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

