/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.annotate.AnnotationTooltipBuilder;
import git4idea.changes.GitCommittedChangeList;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.log.GitCommitTooltipLinkHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitFileAnnotation
extends FileAnnotation {
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final GitVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myBaseRevision;
    @NotNull
    private final List<LineInfo> myLines;
    @Nullable
    private List<VcsFileRevision> myRevisions;
    @Nullable
    private TObjectIntHashMap<VcsRevisionNumber> myRevisionMap;
    @NotNull
    private final Map<VcsRevisionNumber, String> myCommitMessageMap;
    private final VcsLogApplicationSettings myLogSettings;
    private final LineAnnotationAspect DATE_ASPECT;
    private final LineAnnotationAspect REVISION_ASPECT;
    private final LineAnnotationAspect AUTHOR_ASPECT;
    private final VcsLogUiProperties.PropertiesChangeListener myLogSettingChangeListener;

    public GitFileAnnotation(@NotNull Project project, @NotNull VirtualFile file, @Nullable VcsRevisionNumber revision, @NotNull List<LineInfo> lines) {
        if (project == null) {
            GitFileAnnotation.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GitFileAnnotation.$$$reportNull$$$0(1);
        }
        if (lines == null) {
            GitFileAnnotation.$$$reportNull$$$0(2);
        }
        super(project);
        this.myCommitMessageMap = new HashMap<VcsRevisionNumber, String>();
        this.myLogSettings = (VcsLogApplicationSettings)ApplicationManager.getApplication().getService(VcsLogApplicationSettings.class);
        this.DATE_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.DATE, true){

            @Override
            public String doGetValue(LineInfo info) {
                Date date = GitFileAnnotation.this.getDate(info);
                return FileAnnotation.formatDate((Date)date);
            }
        };
        this.REVISION_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.REVISION, false){

            @Override
            protected String doGetValue(LineInfo lineInfo) {
                return lineInfo.getRevisionNumber().getShortRev();
            }
        };
        this.AUTHOR_ASPECT = new GitAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

            @Override
            protected String doGetValue(LineInfo lineInfo) {
                return lineInfo.getAuthor();
            }
        };
        this.myLogSettingChangeListener = this::onLogSettingChange;
        this.myProject = project;
        this.myFile = file;
        this.myFilePath = VcsUtil.getFilePath((VirtualFile)file);
        this.myVcs = GitVcs.getInstance(this.myProject);
        this.myBaseRevision = revision;
        this.myLines = lines;
        this.myLogSettings.addChangeListener(this.myLogSettingChangeListener);
    }

    public <T> void onLogSettingChange(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        if (property == null) {
            GitFileAnnotation.$$$reportNull$$$0(3);
        }
        if (property.equals((Object)CommonUiProperties.PREFER_COMMIT_DATE)) {
            this.reload(null);
        }
    }

    public GitFileAnnotation(@NotNull GitFileAnnotation annotation) {
        if (annotation == null) {
            GitFileAnnotation.$$$reportNull$$$0(4);
        }
        this(annotation.getProject(), annotation.getFile(), annotation.getCurrentRevision(), annotation.getLines());
    }

    public void dispose() {
        this.myLogSettings.removeChangeListener(this.myLogSettingChangeListener);
    }

    public LineAnnotationAspect @NotNull [] getAspects() {
        LineAnnotationAspect[] lineAnnotationAspectArray = new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
        if (lineAnnotationAspectArray == null) {
            GitFileAnnotation.$$$reportNull$$$0(5);
        }
        return lineAnnotationAspectArray;
    }

    @NotNull
    private Date getDate(LineInfo info) {
        Date date = Boolean.TRUE.equals(this.myLogSettings.get(CommonUiProperties.PREFER_COMMIT_DATE)) ? info.getCommitterDate() : info.getAuthorDate();
        if (date == null) {
            GitFileAnnotation.$$$reportNull$$$0(6);
        }
        return date;
    }

    @Nullable
    public String getAnnotatedContent() {
        try {
            ContentRevision revision = GitContentRevision.createRevision(this.myFilePath, this.myBaseRevision, this.myProject);
            return revision.getContent();
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }

    public void setRevisions(@NotNull List<VcsFileRevision> revisions) {
        if (revisions == null) {
            GitFileAnnotation.$$$reportNull$$$0(7);
        }
        this.myRevisions = revisions;
        this.myRevisionMap = new TObjectIntHashMap();
        for (int i2 = 0; i2 < this.myRevisions.size(); ++i2) {
            this.myRevisionMap.put((Object)this.myRevisions.get(i2).getRevisionNumber(), i2);
        }
    }

    public void setCommitMessage(@NotNull VcsRevisionNumber revisionNumber, @NotNull String message) {
        if (revisionNumber == null) {
            GitFileAnnotation.$$$reportNull$$$0(8);
        }
        if (message == null) {
            GitFileAnnotation.$$$reportNull$$$0(9);
        }
        this.myCommitMessageMap.put(revisionNumber, message);
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    @Nullable
    public LineInfo getLineInfo(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber);
    }

    @Nullable
    public String getToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, false);
    }

    @Nullable
    public String getHtmlToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, true);
    }

    @Nullable
    private String getToolTip(int lineNumber, boolean asHtml) {
        String commitMessage;
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        if (lineInfo == null) {
            return null;
        }
        AnnotationTooltipBuilder atb = new AnnotationTooltipBuilder(this.myProject, asHtml);
        GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
        atb.appendRevisionLine((VcsRevisionNumber)revisionNumber, it -> GitCommitTooltipLinkHandler.createLink(it.asString(), it));
        atb.appendLine("Author: " + lineInfo.getAuthor());
        atb.appendLine("Date: " + DateFormatUtil.formatDateTime((Date)this.getDate(lineInfo)));
        if (!this.myFilePath.equals(lineInfo.getFilePath())) {
            String path = FileUtil.getLocationRelativeToUserHome((String)lineInfo.getFilePath().getPresentableUrl());
            atb.appendLine("Path: " + path);
        }
        if ((commitMessage = this.getCommitMessage((VcsRevisionNumber)revisionNumber)) == null) {
            commitMessage = lineInfo.getSubject() + "\n...";
        }
        atb.appendCommitMessageBlock(commitMessage);
        return atb.toString();
    }

    @Nullable
    public String getCommitMessage(@NotNull VcsRevisionNumber revisionNumber) {
        if (revisionNumber == null) {
            GitFileAnnotation.$$$reportNull$$$0(10);
        }
        if (this.myRevisions != null && this.myRevisionMap != null && this.myRevisionMap.contains((Object)revisionNumber)) {
            VcsFileRevision fileRevision = this.myRevisions.get(this.myRevisionMap.get((Object)revisionNumber));
            return fileRevision.getCommitMessage();
        }
        return this.myCommitMessageMap.get(revisionNumber);
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getRevisionNumber() : null;
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? this.getDate(lineInfo) : null;
    }

    private boolean lineNumberCheck(int lineNumber) {
        return this.myLines.size() <= lineNumber || lineNumber < 0;
    }

    @NotNull
    public List<LineInfo> getLines() {
        List<LineInfo> list = this.myLines;
        if (list == null) {
            GitFileAnnotation.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            GitFileAnnotation.$$$reportNull$$$0(12);
        }
        return virtualFile;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    public VcsKey getVcsKey() {
        return GitVcs.getKey();
    }

    public boolean isBaseRevisionChanged(@NotNull VcsRevisionNumber number) {
        if (number == null) {
            GitFileAnnotation.$$$reportNull$$$0(13);
        }
        if (!this.myFile.isInLocalFileSystem()) {
            return false;
        }
        VcsRevisionNumber currentCurrentRevision = this.myVcs.getDiffProvider().getCurrentRevision(this.myFile);
        return this.myBaseRevision != null && !this.myBaseRevision.equals(currentCurrentRevision);
    }

    @Nullable
    public FileAnnotation.CurrentFileRevisionProvider getCurrentFileRevisionProvider() {
        return lineNumber -> {
            LineInfo lineInfo = this.getLineInfo(lineNumber);
            return lineInfo != null ? lineInfo.getFileRevision() : null;
        };
    }

    @Nullable
    public FileAnnotation.PreviousFileRevisionProvider getPreviousFileRevisionProvider() {
        return new FileAnnotation.PreviousFileRevisionProvider(){

            @Nullable
            public VcsFileRevision getPreviousRevision(int lineNumber) {
                int index;
                LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
                if (lineInfo == null) {
                    return null;
                }
                VcsFileRevision previousFileRevision = lineInfo.getPreviousFileRevision();
                if (previousFileRevision != null) {
                    return previousFileRevision;
                }
                GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
                if (GitFileAnnotation.this.myRevisions != null && GitFileAnnotation.this.myRevisionMap != null && GitFileAnnotation.this.myRevisionMap.contains((Object)revisionNumber) && (index = GitFileAnnotation.this.myRevisionMap.get((Object)revisionNumber)) + 1 < GitFileAnnotation.this.myRevisions.size()) {
                    return (VcsFileRevision)GitFileAnnotation.this.myRevisions.get(index + 1);
                }
                return null;
            }

            @Nullable
            public VcsFileRevision getLastRevision() {
                if (GitFileAnnotation.this.myBaseRevision instanceof GitRevisionNumber) {
                    return new GitFileRevision(GitFileAnnotation.this.myProject, GitFileAnnotation.this.myFilePath, (GitRevisionNumber)GitFileAnnotation.this.myBaseRevision);
                }
                return (VcsFileRevision)ContainerUtil.getFirstItem(GitFileAnnotation.this.getRevisions());
            }
        };
    }

    @Nullable
    public FileAnnotation.AuthorsMappingProvider getAuthorsMappingProvider() {
        HashMap<GitRevisionNumber, String> authorsMap = new HashMap<GitRevisionNumber, String>();
        for (int i2 = 0; i2 < this.getLineCount(); ++i2) {
            LineInfo lineInfo = this.getLineInfo(i2);
            if (lineInfo == null || authorsMap.containsKey(lineInfo.getRevisionNumber())) continue;
            authorsMap.put(lineInfo.getRevisionNumber(), lineInfo.getAuthor());
        }
        return () -> authorsMap;
    }

    @Nullable
    public FileAnnotation.RevisionsOrderProvider getRevisionsOrderProvider() {
        ContainerUtil.KeyOrderedMultiMap dates = new ContainerUtil.KeyOrderedMultiMap();
        for (int i2 = 0; i2 < this.getLineCount(); ++i2) {
            LineInfo lineInfo = this.getLineInfo(i2);
            if (lineInfo == null) continue;
            GitRevisionNumber number = lineInfo.getRevisionNumber();
            Date date = lineInfo.getCommitterDate();
            dates.putValue((Object)date, (Object)number);
        }
        ArrayList orderedRevisions = new ArrayList();
        NavigableSet orderedDates = dates.navigableKeySet();
        for (Date date : orderedDates.descendingSet()) {
            Collection revisionNumbers = dates.get((Object)date);
            orderedRevisions.add(new ArrayList(revisionNumbers));
        }
        return () -> orderedRevisions;
    }

    @NotNull
    public FileAnnotation.RevisionChangesProvider getRevisionsChangesProvider() {
        FileAnnotation.RevisionChangesProvider revisionChangesProvider = lineNumber -> {
            LineInfo lineInfo = this.getLineInfo(lineNumber);
            if (lineInfo == null) {
                return null;
            }
            GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(lineInfo.getFilePath());
            if (repository == null) {
                return null;
            }
            GitCommittedChangeList changeList = GitCommittedChangeListProvider.getCommittedChangeList(this.myProject, repository.getRoot(), lineInfo.getRevisionNumber());
            return Pair.create((Object)((Object)changeList), (Object)lineInfo.getFilePath());
        };
        if (revisionChangesProvider == null) {
            GitFileAnnotation.$$$reportNull$$$0(14);
        }
        return revisionChangesProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/annotate/GitFileAnnotation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisions";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/annotate/GitFileAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspects";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionsChangesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onLogSettingChange";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setRevisions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setCommitMessage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCommitMessage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isBaseRevisionChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineInfo {
        @NotNull
        private final CommitInfo myCommitInfo;
        private final int myLineNumber;
        private final int myOriginalLineNumber;

        LineInfo(@NotNull CommitInfo commitInfo, int lineNumber, int originalLineNumber) {
            if (commitInfo == null) {
                LineInfo.$$$reportNull$$$0(0);
            }
            this.myCommitInfo = commitInfo;
            this.myLineNumber = lineNumber;
            this.myOriginalLineNumber = originalLineNumber;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public int getOriginalLineNumber() {
            return this.myOriginalLineNumber;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            GitRevisionNumber gitRevisionNumber = this.myCommitInfo.getRevisionNumber();
            if (gitRevisionNumber == null) {
                LineInfo.$$$reportNull$$$0(1);
            }
            return gitRevisionNumber;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myCommitInfo.getFilePath();
            if (filePath == null) {
                LineInfo.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            VcsFileRevision vcsFileRevision = this.myCommitInfo.getFileRevision();
            if (vcsFileRevision == null) {
                LineInfo.$$$reportNull$$$0(3);
            }
            return vcsFileRevision;
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            return this.myCommitInfo.getPreviousFileRevision();
        }

        @NotNull
        public Date getCommitterDate() {
            Date date = this.myCommitInfo.getCommitterDate();
            if (date == null) {
                LineInfo.$$$reportNull$$$0(4);
            }
            return date;
        }

        @NotNull
        public Date getAuthorDate() {
            Date date = this.myCommitInfo.getAuthorDate();
            if (date == null) {
                LineInfo.$$$reportNull$$$0(5);
            }
            return date;
        }

        @NotNull
        public String getAuthor() {
            String string = this.myCommitInfo.getAuthor();
            if (string == null) {
                LineInfo.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getSubject() {
            String string = this.myCommitInfo.getSubject();
            if (string == null) {
                LineInfo.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commitInfo";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/annotate/GitFileAnnotation$LineInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/annotate/GitFileAnnotation$LineInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileRevision";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitterDate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthorDate";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CommitInfo {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitRevisionNumber myRevision;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        private final GitRevisionNumber myPreviousRevision;
        @Nullable
        private final FilePath myPreviousFilePath;
        @NotNull
        private final Date myCommitterDate;
        @NotNull
        private final Date myAuthorDate;
        @NotNull
        private final VcsUser myAuthor;
        @NotNull
        private final String mySubject;

        CommitInfo(@NotNull Project project, @NotNull GitRevisionNumber revision, @NotNull FilePath path, @NotNull Date committerDate, @NotNull Date authorDate, @NotNull VcsUser author, @NotNull String subject, @Nullable GitRevisionNumber previousRevision, @Nullable FilePath previousPath) {
            if (project == null) {
                CommitInfo.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                CommitInfo.$$$reportNull$$$0(1);
            }
            if (path == null) {
                CommitInfo.$$$reportNull$$$0(2);
            }
            if (committerDate == null) {
                CommitInfo.$$$reportNull$$$0(3);
            }
            if (authorDate == null) {
                CommitInfo.$$$reportNull$$$0(4);
            }
            if (author == null) {
                CommitInfo.$$$reportNull$$$0(5);
            }
            if (subject == null) {
                CommitInfo.$$$reportNull$$$0(6);
            }
            this.myProject = project;
            this.myRevision = revision;
            this.myFilePath = path;
            this.myPreviousRevision = previousRevision;
            this.myPreviousFilePath = previousPath;
            this.myCommitterDate = committerDate;
            this.myAuthorDate = authorDate;
            this.myAuthor = author;
            this.mySubject = subject;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            GitRevisionNumber gitRevisionNumber = this.myRevision;
            if (gitRevisionNumber == null) {
                CommitInfo.$$$reportNull$$$0(7);
            }
            return gitRevisionNumber;
        }

        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                CommitInfo.$$$reportNull$$$0(8);
            }
            return filePath;
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            return new GitFileRevision(this.myProject, this.myFilePath, this.myRevision);
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            if (this.myPreviousRevision == null || this.myPreviousFilePath == null) {
                return null;
            }
            return new GitFileRevision(this.myProject, this.myPreviousFilePath, this.myPreviousRevision);
        }

        @NotNull
        public Date getCommitterDate() {
            Date date = this.myCommitterDate;
            if (date == null) {
                CommitInfo.$$$reportNull$$$0(9);
            }
            return date;
        }

        @NotNull
        public Date getAuthorDate() {
            Date date = this.myAuthorDate;
            if (date == null) {
                CommitInfo.$$$reportNull$$$0(10);
            }
            return date;
        }

        @NotNull
        public String getAuthor() {
            String string = this.myAuthor.getName();
            if (string == null) {
                CommitInfo.$$$reportNull$$$0(11);
            }
            return string;
        }

        @NotNull
        public String getSubject() {
            String string = this.mySubject;
            if (string == null) {
                CommitInfo.$$$reportNull$$$0(12);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "committerDate";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "authorDate";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "author";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subject";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/annotate/GitFileAnnotation$CommitInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/annotate/GitFileAnnotation$CommitInfo";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRevisionNumber";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommitterDate";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthorDate";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthor";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private abstract class GitAnnotationAspect
    extends LineAnnotationAspectAdapter {
        GitAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        public String getValue(int lineNumber) {
            if (GitFileAnnotation.this.lineNumberCheck(lineNumber)) {
                return "";
            }
            return this.doGetValue((LineInfo)GitFileAnnotation.this.myLines.get(lineNumber));
        }

        protected abstract String doGetValue(LineInfo var1);

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < GitFileAnnotation.this.myLines.size()) {
                LineInfo info = (LineInfo)GitFileAnnotation.this.myLines.get(lineNum);
                AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails((Project)GitFileAnnotation.this.myProject, (VcsRevisionNumber)info.getRevisionNumber(), (FilePath)GitFileAnnotation.this.myFilePath, () -> GitFileAnnotation.this.getRevisionsChangesProvider().getChangesIn(lineNum));
            }
        }
    }
}

