/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.ignore.GitIgnoreChecker;
import git4idea.ignore.GitIgnoredFileContentProvider$WhenMappings;
import git4idea.ignore.GitIgnoredFileContentProviderKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J#\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0002J\u001e\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J6\u0010%\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010&\u001a\u00020'H\u0002J6\u0010(\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010)\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J6\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0+*\b\u0012\u0004\u0012\u00020\f0,2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lgit4idea/ignore/GitIgnoredFileContentProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "gitIgnoreChecker", "Lgit4idea/ignore/GitIgnoreChecker;", "buildIgnoreEntryContent", "", "ignoreEntryRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "ignoredFileDescriptor", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "buildIgnoreFileContent", "ignoreFileRoot", "ignoredFileProviders", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "(Lcom/intellij/openapi/vfs/VirtualFile;[Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;)Ljava/lang/String;", "buildIgnoreGroupDescription", "ignoredFileProvider", "buildUnignoreContent", "ignorePattern", "canCreateIgnoreFileInStateStoreDir", "", "getFileName", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "getUntrackedFiles", "", "Lcom/intellij/openapi/vcs/FilePath;", "ignoreFileVcsRoot", "prependCommentHashCharacterIfNeeded", "description", "shouldIgnoreByMask", "ignoredBean", "untrackedFiles", "shouldIgnoreFile", "vcsContextFactory", "Lcom/intellij/openapi/vcs/actions/VcsContextFactory;", "shouldIgnoreUnderDir", "shouldNotConsiderInternalIgnoreFile", "ignoreBeansToRelativePaths", "", "", "intellij.vcs.git"})
public class GitIgnoredFileContentProvider
implements IgnoredFileContentProvider {
    private final GitIgnoreChecker gitIgnoreChecker;
    private final Project project;

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsKey, (String)"GitVcs.getKey()");
        return vcsKey;
    }

    @NotNull
    public String getFileName() {
        return ".gitignore";
    }

    @NotNull
    public String buildIgnoreFileContent(@NotNull VirtualFile ignoreFileRoot, @NotNull IgnoredFileProvider[] ignoredFileProviders) {
        Intrinsics.checkParameterIsNotNull((Object)ignoreFileRoot, (String)"ignoreFileRoot");
        Intrinsics.checkParameterIsNotNull((Object)ignoredFileProviders, (String)"ignoredFileProviders");
        if (!GitUtil.isUnderGit(ignoreFileRoot)) {
            return "";
        }
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)this.project, (VirtualFile)ignoreFileRoot);
        if (virtualFile == null) {
            return "";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VcsUtil.getVcsRootFor(pr\u2026oreFileRoot) ?: return \"\"");
        VirtualFile ignoreFileVcsRoot = virtualFile;
        StringBuilder content = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        Set<FilePath> untrackedFiles = this.getUntrackedFiles(ignoreFileVcsRoot);
        if (untrackedFiles.isEmpty()) {
            return "";
        }
        for (IgnoredFileProvider provider : ignoredFileProviders) {
            String description;
            Set set = provider.getIgnoredFiles(this.project);
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"provider.getIgnoredFiles(project)");
            List<String> ignoredFiles = this.ignoreBeansToRelativePaths(set, ignoreFileVcsRoot, ignoreFileRoot, untrackedFiles);
            if (ignoredFiles.isEmpty()) continue;
            CharSequence charSequence = content;
            boolean bl = false;
            if (charSequence.length() > 0) {
                content.append(lineSeparator).append(lineSeparator);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)provider.getIgnoredGroupDescription(), (String)"provider.ignoredGroupDescription");
            CharSequence charSequence2 = description;
            boolean bl2 = false;
            if (!StringsKt.isBlank((CharSequence)charSequence2)) {
                content.append(this.buildIgnoreGroupDescription(provider));
                content.append(lineSeparator);
            }
            Iterable iterable = ignoredFiles;
            String string = lineSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator");
            content.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null));
        }
        String string = content.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content.toString()");
        return string;
    }

    private final Set<FilePath> getUntrackedFiles(VirtualFile ignoreFileVcsRoot) {
        try {
            GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRoot(ignoreFileVcsRoot);
            if (gitRepository == null) {
                return SetsKt.emptySet();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"GitRepositoryManager.get\u2026oot) ?: return emptySet()");
            GitRepository repo = gitRepository;
            Collection<FilePath> collection = repo.getUntrackedFilesHolder().retrieveUntrackedFilePaths();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"repo.untrackedFilesHolde\u2026rieveUntrackedFilePaths()");
            return CollectionsKt.toSet((Iterable)collection);
        }
        catch (VcsException e) {
            GitIgnoredFileContentProviderKt.access$getLOG$p().warn("Cannot get untracked files: ", (Throwable)e);
            return SetsKt.emptySet();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> ignoreBeansToRelativePaths(@NotNull Iterable<? extends IgnoredFileDescriptor> $this$ignoreBeansToRelativePaths, VirtualFile ignoreFileVcsRoot, VirtualFile ignoreFileRoot, Set<? extends FilePath> untrackedFiles) {
        void $this$mapTo$iv$iv;
        IgnoredFileDescriptor ignoredBean;
        Iterable $this$filterTo$iv$iv;
        VcsContextFactory vcsContextFactory = VcsContextFactory.SERVICE.getInstance();
        Iterable<? extends IgnoredFileDescriptor> $this$filter$iv = $this$ignoreBeansToRelativePaths;
        boolean $i$f$filter = false;
        Iterable<? extends IgnoredFileDescriptor> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            ignoredBean = (IgnoredFileDescriptor)element$iv$iv;
            boolean bl2 = false;
            switch (GitIgnoredFileContentProvider$WhenMappings.$EnumSwitchMapping$0[ignoredBean.getType().ordinal()]) {
                case 1: {
                    VcsContextFactory vcsContextFactory2 = vcsContextFactory;
                    Intrinsics.checkExpressionValueIsNotNull((Object)vcsContextFactory2, (String)"vcsContextFactory");
                    bl = this.shouldIgnoreUnderDir(ignoredBean, untrackedFiles, ignoreFileRoot, ignoreFileVcsRoot, vcsContextFactory2);
                    break;
                }
                case 2: {
                    VcsContextFactory vcsContextFactory3 = vcsContextFactory;
                    Intrinsics.checkExpressionValueIsNotNull((Object)vcsContextFactory3, (String)"vcsContextFactory");
                    bl = this.shouldIgnoreFile(ignoredBean, untrackedFiles, ignoreFileRoot, ignoreFileVcsRoot, vcsContextFactory3);
                    break;
                }
                case 3: {
                    bl = this.shouldIgnoreByMask(ignoredBean, untrackedFiles);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            ignoredBean = (IgnoredFileDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (GitIgnoredFileContentProvider$WhenMappings.$EnumSwitchMapping$1[ignoredBean.getType().ordinal()]) {
                case 1: {
                    string = ignoredBean.getMask();
                    if (string != null) break;
                    Intrinsics.throwNpe();
                    break;
                }
                case 2: {
                    string = this.buildIgnoreEntryContent(ignoreFileRoot, ignoredBean);
                    break;
                }
                case 3: {
                    string = this.buildIgnoreEntryContent(ignoreFileRoot, ignoredBean);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String string2 = string;
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldIgnoreUnderDir(IgnoredFileDescriptor ignoredBean, Set<? extends FilePath> untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile ignoreFileVcsRoot, VcsContextFactory vcsContextFactory) {
        FilePath it;
        String string;
        if (!FileUtil.exists((String)ignoredBean.getPath())) return false;
        Iterable $this$any$iv = untrackedFiles;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (FilePath)element$iv;
            boolean bl = false;
            string = ignoredBean.getPath();
            if (string != null) continue;
            Intrinsics.throwNpe();
        } while (!FileUtil.isAncestor((String)string, (String)it.getPath(), (boolean)true));
        boolean bl = true;
        if (!bl) return false;
        String string2 = ignoreFileRoot.getPath();
        String string3 = ignoredBean.getPath();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        if (!FileUtil.isAncestor((String)string2, (String)string3, (boolean)false)) return false;
        String string4 = ignoredBean.getPath();
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        if (!Comparing.equal((Object)ignoreFileVcsRoot, (Object)VcsUtil.getVcsRootFor((Project)this.project, (FilePath)vcsContextFactory.createFilePath(string4, true)))) return false;
        String string5 = ignoredBean.getPath();
        if (string5 == null) {
            Intrinsics.throwNpe();
        }
        if (!(this.gitIgnoreChecker.isIgnored(ignoreFileVcsRoot, new File(string5)) instanceof NotIgnored)) return false;
        if (!this.shouldNotConsiderInternalIgnoreFile(ignoredBean, ignoreFileRoot)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldIgnoreFile(IgnoredFileDescriptor ignoredBean, Set<? extends FilePath> untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile ignoreFileVcsRoot, VcsContextFactory vcsContextFactory) {
        FilePath it;
        if (!FileUtil.exists((String)ignoredBean.getPath())) return false;
        Iterable $this$any$iv = untrackedFiles;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (FilePath)element$iv;
            boolean bl = false;
        } while (!ignoredBean.matchesFile(it));
        boolean bl = true;
        if (!bl) return false;
        String string = ignoreFileRoot.getPath();
        String string2 = ignoredBean.getPath();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        if (!FileUtil.isAncestor((String)string, (String)string2, (boolean)false)) return false;
        String string3 = ignoredBean.getPath();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        if (!Comparing.equal((Object)ignoreFileVcsRoot, (Object)VcsUtil.getVcsRootFor((Project)this.project, (FilePath)vcsContextFactory.createFilePath(string3, false)))) return false;
        if (!this.shouldNotConsiderInternalIgnoreFile(ignoredBean, ignoreFileRoot)) return false;
        return true;
    }

    private final boolean shouldIgnoreByMask(IgnoredFileDescriptor ignoredBean, Set<? extends FilePath> untrackedFiles) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = untrackedFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FilePath it = (FilePath)element$iv;
                    boolean bl2 = false;
                    if (!ignoredBean.matchesFile(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean shouldNotConsiderInternalIgnoreFile(IgnoredFileDescriptor ignoredBean, VirtualFile ignoreFileRoot) {
        boolean insideDirectoryStore;
        String string = ignoredBean.getPath();
        boolean bl = insideDirectoryStore = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)".idea", (boolean)false, (int)2, null) : false;
        if (insideDirectoryStore) {
            Object object = ProjectKt.getStateStore((Project)this.project).getDirectoryStoreFile();
            if (object == null) {
                VirtualFile virtualFile = this.project.getProjectFile();
                object = virtualFile != null ? virtualFile.getParent() : null;
            }
            if (object == null) {
                return false;
            }
            VirtualFile directoryStoreOrProjectFileLocation = object;
            return FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)directoryStoreOrProjectFileLocation), (File)VfsUtilCore.virtualToIoFile((VirtualFile)ignoreFileRoot), (boolean)false);
        }
        return true;
    }

    @NotNull
    public String buildUnignoreContent(@NotNull String ignorePattern) {
        Intrinsics.checkParameterIsNotNull((Object)ignorePattern, (String)"ignorePattern");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        $this$apply.append(System.lineSeparator());
        $this$apply.append('!' + ignorePattern);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply {\n\u2026ePattern\")\n  }.toString()");
        return string;
    }

    @NotNull
    public String buildIgnoreGroupDescription(@NotNull IgnoredFileProvider ignoredFileProvider) {
        Intrinsics.checkParameterIsNotNull((Object)ignoredFileProvider, (String)"ignoredFileProvider");
        String string = ignoredFileProvider.getIgnoredGroupDescription();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ignoredFileProvider.ignoredGroupDescription");
        return this.prependCommentHashCharacterIfNeeded(string);
    }

    @NotNull
    public String buildIgnoreEntryContent(@NotNull VirtualFile ignoreEntryRoot, @NotNull IgnoredFileDescriptor ignoredFileDescriptor) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)ignoreEntryRoot, (String)"ignoreEntryRoot");
        Intrinsics.checkParameterIsNotNull((Object)ignoredFileDescriptor, (String)"ignoredFileDescriptor");
        StringBuilder stringBuilder = new StringBuilder().append('/');
        String string2 = ignoreEntryRoot.getPath();
        String string3 = ignoredFileDescriptor.getPath();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        if ((string = FileUtil.getRelativePath((String)string2, (String)string3, (char)'/')) == null) {
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    private final String prependCommentHashCharacterIfNeeded(String description) {
        return StringsKt.startsWith$default((String)description, (String)"#", (boolean)false, (int)2, null) ? description : "# " + description;
    }

    public boolean canCreateIgnoreFileInStateStoreDir() {
        return false;
    }

    public GitIgnoredFileContentProvider(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.gitIgnoreChecker = new GitIgnoreChecker(this.project);
    }
}

