/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.history.GitHistoryUtils;
import git4idea.merge.MergeChangeCollector;
import git4idea.push.GitPushNativeResult;
import git4idea.push.GitPushNativeResultParser;
import git4idea.push.GitPushParams;
import git4idea.push.GitPushParamsImpl;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.push.GitRejectedPushUpdateDialog;
import git4idea.push.GroupedPushResult;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import git4idea.update.HashRange;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushOperation {
    private static final Logger LOG = Logger.getInstance(GitPushOperation.class);
    private static final int MAX_PUSH_ATTEMPTS = 10;
    private final Project myProject;
    @NotNull
    private final GitPushSupport myPushSupport;
    private final Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> myPushSpecs;
    @Nullable
    private final GitPushTagMode myTagMode;
    private final ForceMode myForceMode;
    private final boolean mySkipHook;
    private final Git myGit;
    private final ProgressIndicator myProgressIndicator;
    private final GitVcsSettings mySettings;
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final Map<GitRepository, HashRange> myUpdatedRanges;

    public GitPushOperation(@NotNull Project project, @NotNull GitPushSupport pushSupport, @NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable GitPushTagMode tagMode, boolean force, boolean skipHook) {
        if (project == null) {
            GitPushOperation.$$$reportNull$$$0(0);
        }
        if (pushSupport == null) {
            GitPushOperation.$$$reportNull$$$0(1);
        }
        if (pushSpecs == null) {
            GitPushOperation.$$$reportNull$$$0(2);
        }
        this(project, pushSupport, pushSpecs, tagMode, GitPushOperation.getForceMode(force), skipHook);
    }

    @NotNull
    private static ForceMode getForceMode(boolean force) {
        if (force) {
            ForceMode forceMode = Registry.is((String)"git.use.push.force.with.lease") ? ForceMode.FORCE_WITH_LEASE : ForceMode.FORCE;
            if (forceMode == null) {
                GitPushOperation.$$$reportNull$$$0(3);
            }
            return forceMode;
        }
        ForceMode forceMode = ForceMode.NONE;
        if (forceMode == null) {
            GitPushOperation.$$$reportNull$$$0(4);
        }
        return forceMode;
    }

    public GitPushOperation(@NotNull Project project, @NotNull GitPushSupport pushSupport, @NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable GitPushTagMode tagMode, @NotNull ForceMode forceMode, boolean skipHook) {
        if (project == null) {
            GitPushOperation.$$$reportNull$$$0(5);
        }
        if (pushSupport == null) {
            GitPushOperation.$$$reportNull$$$0(6);
        }
        if (pushSpecs == null) {
            GitPushOperation.$$$reportNull$$$0(7);
        }
        if (forceMode == null) {
            GitPushOperation.$$$reportNull$$$0(8);
        }
        this.myUpdatedRanges = new LinkedHashMap<GitRepository, HashRange>();
        this.myProject = project;
        this.myPushSupport = pushSupport;
        this.myPushSpecs = pushSpecs;
        this.myTagMode = tagMode;
        this.myForceMode = forceMode;
        this.mySkipHook = skipHook;
        this.myGit = Git.getInstance();
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
        this.myRepositoryManager = GitRepositoryManager.getInstance(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GitPushResult execute() {
        PushUpdateSettings updateSettings = this.readPushUpdateSettings();
        Label beforePushLabel = null;
        Label afterPushLabel = null;
        Map<GitRepository, String> preUpdatePositions = this.updateRootInfoAndRememberPositions();
        Boolean rebaseOverMergeProblemDetected = null;
        HashMap<GitRepository, GitPushRepoResult> results = new HashMap<GitRepository, GitPushRepoResult>();
        HashMap<GitRepository, GitUpdateResult> updatedRoots = new HashMap<GitRepository, GitUpdateResult>();
        try {
            Collection<GitRepository> remainingRoots = this.myPushSpecs.keySet();
            for (int pushAttempt = 0; pushAttempt < 10 && !remainingRoots.isEmpty(); ++pushAttempt) {
                LOG.debug("Starting push attempt #" + pushAttempt);
                Map<GitRepository, GitPushRepoResult> resultMap = this.push(this.myRepositoryManager.sortByDependency(remainingRoots));
                results.putAll(resultMap);
                GroupedPushResult result2 = GroupedPushResult.group(resultMap);
                if (!result2.errors.isEmpty()) break;
                if (!result2.customRejected.isEmpty()) {
                    break;
                }
                if (!result2.rejected.isEmpty()) {
                    if (this.myForceMode.isForce() || GitPushOperation.pushingToNotTrackedBranch(result2.rejected)) break;
                    if (GitPushOperation.pushingNotCurrentBranch(result2.rejected)) {
                        break;
                    }
                    if (pushAttempt == 0 && !this.mySettings.autoUpdateIfPushRejected()) {
                        rebaseOverMergeProblemDetected = !this.findRootsWithMergeCommits(this.getRootsToUpdate(updateSettings, result2.rejected.keySet())).isEmpty();
                        updateSettings = this.showDialogAndGetExitCode(result2.rejected.keySet(), updateSettings, rebaseOverMergeProblemDetected);
                        if (updateSettings == null) {
                            break;
                        }
                        this.savePushUpdateSettings(updateSettings, rebaseOverMergeProblemDetected);
                    }
                    if (beforePushLabel == null) {
                        beforePushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "Before push");
                    }
                    Collection<GitRepository> rootsToUpdate = this.getRootsToUpdate(updateSettings, result2.rejected.keySet());
                    LOG.debug("roots to update: " + rootsToUpdate);
                    GitUpdateResult updateResult = this.update(rootsToUpdate, updateSettings.getUpdateMethod(), rebaseOverMergeProblemDetected == null);
                    for (GitRepository repository : rootsToUpdate) {
                        updatedRoots.put(repository, updateResult);
                    }
                    if (!updateResult.isSuccess() || updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) break;
                    if (updateResult == GitUpdateResult.INCOMPLETE) {
                        break;
                    }
                }
                remainingRoots = GitPushOperation.getRejectedAndNotPushed(results);
            }
        }
        finally {
            if (beforePushLabel != null) {
                afterPushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, "After push");
            }
            for (GitRepository repository : this.myPushSpecs.keySet()) {
                repository.update();
            }
        }
        return this.prepareCombinedResult(results, updatedRoots, preUpdatePositions, beforePushLabel, afterPushLabel);
    }

    @NotNull
    private Collection<GitRepository> getRootsToUpdate(@NotNull PushUpdateSettings updateSettings, @NotNull Set<GitRepository> rejectedRepositories) {
        if (updateSettings == null) {
            GitPushOperation.$$$reportNull$$$0(9);
        }
        if (rejectedRepositories == null) {
            GitPushOperation.$$$reportNull$$$0(10);
        }
        Collection<GitRepository> collection = updateSettings.shouldUpdateAllRoots() ? this.myRepositoryManager.getRepositories() : rejectedRepositories;
        if (collection == null) {
            GitPushOperation.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    private Collection<VirtualFile> findRootsWithMergeCommits(@NotNull Collection<? extends GitRepository> rootsToSearch) {
        if (rootsToSearch == null) {
            GitPushOperation.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.mapNotNull(rootsToSearch, repo -> {
            PushSpec pushSpec = this.myPushSpecs.get(repo);
            if (pushSpec == null) {
                GitPushSource source = this.myPushSupport.getSource((GitRepository)repo);
                GitPushTarget target = this.myPushSupport.getDefaultTarget((GitRepository)repo);
                if (target == null) {
                    return null;
                }
                pushSpec = new PushSpec((PushSource)source, (PushTarget)target);
            }
            String baseRef = ((GitPushTarget)pushSpec.getTarget()).getBranch().getFullName();
            String currentRef = ((GitPushSource)pushSpec.getSource()).getBranch().getFullName();
            return GitRebaseOverMergeProblem.hasProblem(this.myProject, repo.getRoot(), baseRef, currentRef) ? repo.getRoot() : null;
        });
        if (list == null) {
            GitPushOperation.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public GitPushOperation deriveForceWithoutLease(@NotNull List<GitRepository> newRepositories) {
        if (newRepositories == null) {
            GitPushOperation.$$$reportNull$$$0(14);
        }
        Map newPushSpec = ContainerUtil.filter(this.myPushSpecs, repo -> newRepositories.contains(repo));
        return new GitPushOperation(this.myProject, this.myPushSupport, (Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>>)newPushSpec, this.myTagMode, ForceMode.FORCE, this.mySkipHook);
    }

    private static boolean pushingToNotTrackedBranch(@NotNull Map<GitRepository, GitPushRepoResult> rejected) {
        if (rejected == null) {
            GitPushOperation.$$$reportNull$$$0(15);
        }
        boolean pushingToNotTrackedBranch = ContainerUtil.exists(rejected.entrySet(), entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
            return trackInfo == null || !trackInfo.getRemoteBranch().getFullName().equals(((GitPushRepoResult)entry.getValue()).getTargetBranch());
        });
        LOG.debug("Pushing to not tracked branch condition is [" + pushingToNotTrackedBranch + "]");
        return pushingToNotTrackedBranch;
    }

    private static boolean pushingNotCurrentBranch(@NotNull Map<GitRepository, GitPushRepoResult> rejected) {
        if (rejected == null) {
            GitPushOperation.$$$reportNull$$$0(16);
        }
        boolean pushingNotCurrentBranch = ContainerUtil.exists(rejected.entrySet(), entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            String currentBranch = Objects.requireNonNull(repository.getCurrentBranch()).getFullName();
            return !StringUtil.equals((CharSequence)currentBranch, (CharSequence)((GitPushRepoResult)entry.getValue()).getSourceBranch());
        });
        LOG.debug("Pushing non current branch condition is [" + pushingNotCurrentBranch + "]");
        return pushingNotCurrentBranch;
    }

    @NotNull
    private static List<GitRepository> getRejectedAndNotPushed(@NotNull Map<GitRepository, GitPushRepoResult> results) {
        if (results == null) {
            GitPushOperation.$$$reportNull$$$0(17);
        }
        List list = ContainerUtil.filter(results.keySet(), repository -> ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.REJECTED_NO_FF || ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.NOT_PUSHED);
        if (list == null) {
            GitPushOperation.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private Map<GitRepository, String> updateRootInfoAndRememberPositions() {
        Set<GitRepository> repositories = this.myPushSpecs.keySet();
        repositories.forEach(Repository::update);
        Map map2 = StreamEx.of(repositories).toMap(Repository::getCurrentRevision);
        if (map2 == null) {
            GitPushOperation.$$$reportNull$$$0(19);
        }
        return map2;
    }

    @NotNull
    private GitPushResult prepareCombinedResult(@NotNull Map<GitRepository, GitPushRepoResult> allRoots, @NotNull Map<GitRepository, GitUpdateResult> updatedRoots, @NotNull Map<GitRepository, String> preUpdatePositions, @Nullable Label beforeUpdateLabel, @Nullable Label afterUpdateLabel) {
        if (allRoots == null) {
            GitPushOperation.$$$reportNull$$$0(20);
        }
        if (updatedRoots == null) {
            GitPushOperation.$$$reportNull$$$0(21);
        }
        if (preUpdatePositions == null) {
            GitPushOperation.$$$reportNull$$$0(22);
        }
        HashMap<GitRepository, GitPushRepoResult> results = new HashMap<GitRepository, GitPushRepoResult>();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : allRoots.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult simpleResult = entry.getValue();
            GitUpdateResult updateResult = updatedRoots.get(repository);
            if (updateResult == null) {
                results.put(repository, simpleResult);
                continue;
            }
            this.collectUpdatedFiles(updatedFiles, repository, preUpdatePositions.get(repository));
            results.put(repository, GitPushRepoResult.addUpdateResult(simpleResult, updateResult));
        }
        return new GitPushResult(results, updatedFiles, beforeUpdateLabel, afterUpdateLabel, this.myUpdatedRanges);
    }

    @NotNull
    private Map<GitRepository, GitPushRepoResult> push(@NotNull List<? extends GitRepository> repositories) {
        PushSpec<GitPushSource, GitPushTarget> spec;
        if (repositories == null) {
            GitPushOperation.$$$reportNull$$$0(23);
        }
        LinkedHashMap<GitRepository, GitPushRepoResult> results = new LinkedHashMap<GitRepository, GitPushRepoResult>();
        for (GitRepository gitRepository : repositories) {
            GitPushRepoResult repoResult;
            spec = this.myPushSpecs.get(gitRepository);
            ResultWithOutput resultWithOutput = this.doPush(gitRepository, spec);
            LOG.debug("Pushed to " + DvcsUtil.getShortRepositoryName((Repository)gitRepository) + ": " + resultWithOutput);
            GitLocalBranch source = ((GitPushSource)spec.getSource()).getBranch();
            GitPushTarget target = (GitPushTarget)spec.getTarget();
            if (resultWithOutput.isError()) {
                repoResult = GitPushRepoResult.error(source, target.getBranch(), resultWithOutput.getErrorAsString());
            } else {
                List nativeResults = resultWithOutput.parsedResults;
                GitPushNativeResult branchResult = GitPushOperation.getBranchResult(nativeResults);
                if (branchResult == null) {
                    LOG.error("No result for branch among: [" + nativeResults + "]\nFull result: " + resultWithOutput);
                    continue;
                }
                List tagResults = ContainerUtil.filter((Collection)nativeResults, result2 -> !result2.equals(branchResult) && (result2.getType() == GitPushNativeResult.Type.NEW_REF || result2.getType() == GitPushNativeResult.Type.FORCED_UPDATE));
                int commits2 = this.collectNumberOfPushedCommits(gitRepository.getRoot(), branchResult);
                repoResult = GitPushRepoResult.convertFromNative(branchResult, tagResults, commits2, source, target.getBranch());
            }
            LOG.debug("Converted result: " + repoResult);
            results.put(gitRepository, repoResult);
        }
        for (GitRepository gitRepository : repositories) {
            if (results.containsKey(gitRepository)) continue;
            spec = this.myPushSpecs.get(gitRepository);
            results.put(gitRepository, GitPushRepoResult.notPushed(((GitPushSource)spec.getSource()).getBranch(), ((GitPushTarget)spec.getTarget()).getBranch()));
        }
        LinkedHashMap<GitRepository, GitPushRepoResult> linkedHashMap = results;
        if (linkedHashMap == null) {
            GitPushOperation.$$$reportNull$$$0(24);
        }
        return linkedHashMap;
    }

    @Nullable
    private static GitPushNativeResult getBranchResult(@NotNull List<? extends GitPushNativeResult> results) {
        if (results == null) {
            GitPushOperation.$$$reportNull$$$0(25);
        }
        return (GitPushNativeResult)ContainerUtil.find(results, result2 -> result2.getSourceRef().startsWith("refs/heads/"));
    }

    private int collectNumberOfPushedCommits(@NotNull VirtualFile root, @NotNull GitPushNativeResult result2) {
        if (root == null) {
            GitPushOperation.$$$reportNull$$$0(26);
        }
        if (result2 == null) {
            GitPushOperation.$$$reportNull$$$0(27);
        }
        if (result2.getType() != GitPushNativeResult.Type.SUCCESS) {
            return -1;
        }
        String range = result2.getRange();
        if (range == null) {
            LOG.error("Range of pushed commits not reported in " + result2);
            return -1;
        }
        try {
            return GitHistoryUtils.history(this.myProject, root, range).size();
        }
        catch (VcsException e) {
            LOG.error("Couldn't collect commits from range " + range);
            return -1;
        }
    }

    private void collectUpdatedFiles(@NotNull UpdatedFiles updatedFiles, @NotNull GitRepository repository, @NotNull String preUpdatePosition) {
        if (updatedFiles == null) {
            GitPushOperation.$$$reportNull$$$0(28);
        }
        if (repository == null) {
            GitPushOperation.$$$reportNull$$$0(29);
        }
        if (preUpdatePosition == null) {
            GitPushOperation.$$$reportNull$$$0(30);
        }
        try {
            new MergeChangeCollector(this.myProject, repository.getRoot(), new GitRevisionNumber(preUpdatePosition)).collect(updatedFiles);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private ResultWithOutput doPush(@NotNull GitRepository repository, @NotNull PushSpec<GitPushSource, GitPushTarget> pushSpec) {
        GitPushParamsImpl params;
        GitCommandResult res;
        if (repository == null) {
            GitPushOperation.$$$reportNull$$$0(31);
        }
        if (pushSpec == null) {
            GitPushOperation.$$$reportNull$$$0(32);
        }
        GitPushTarget target = (GitPushTarget)pushSpec.getTarget();
        GitLocalBranch sourceBranch = ((GitPushSource)pushSpec.getSource()).getBranch();
        GitRemoteBranch targetBranch = target.getBranch();
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(this.myProgressIndicator);
        boolean setUpstream = target.isNewBranchCreated() && !GitPushOperation.branchTrackingInfoIsSet(repository, sourceBranch);
        String tagMode = this.myTagMode == null ? null : this.myTagMode.getArgument();
        String spec = sourceBranch.getFullName() + ":" + targetBranch.getNameForRemoteOperations();
        GitRemote remote = targetBranch.getRemote();
        List<GitPushParams.ForceWithLease> forceWithLease = Collections.emptyList();
        if (this.myForceMode == ForceMode.FORCE_WITH_LEASE) {
            Hash hash = repository.getBranches().getHash(targetBranch);
            String expectedHash = hash != null ? hash.asString() : "";
            forceWithLease = Collections.singletonList(new GitPushParamsImpl.ForceWithLeaseReference(targetBranch.getNameForRemoteOperations(), expectedHash));
        }
        if ((res = this.myGit.push(repository, params = new GitPushParamsImpl(remote, spec, this.myForceMode.isForce(), setUpstream, this.mySkipHook, tagMode, forceWithLease), progressListener)).success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository, remote);
        }
        return new ResultWithOutput(res);
    }

    private static boolean branchTrackingInfoIsSet(@NotNull GitRepository repository, @NotNull GitLocalBranch source) {
        if (repository == null) {
            GitPushOperation.$$$reportNull$$$0(33);
        }
        if (source == null) {
            GitPushOperation.$$$reportNull$$$0(34);
        }
        return ContainerUtil.exists(repository.getBranchTrackInfos(), info -> info.getLocalBranch().equals(source));
    }

    private void savePushUpdateSettings(@NotNull PushUpdateSettings settings, boolean rebaseOverMergeDetected) {
        if (settings == null) {
            GitPushOperation.$$$reportNull$$$0(35);
        }
        UpdateMethod updateMethod = settings.getUpdateMethod();
        this.mySettings.setUpdateAllRootsIfPushRejected(settings.shouldUpdateAllRoots());
        if (!rebaseOverMergeDetected && this.mySettings.getUpdateMethod() != updateMethod && this.mySettings.getUpdateMethod() != UpdateMethod.BRANCH_DEFAULT) {
            this.mySettings.setUpdateMethod(updateMethod);
        }
    }

    @NotNull
    private PushUpdateSettings readPushUpdateSettings() {
        boolean updateAllRoots = this.mySettings.shouldUpdateAllRootsIfPushRejected();
        UpdateMethod updateMethod = this.mySettings.getUpdateMethod();
        if (updateMethod == UpdateMethod.BRANCH_DEFAULT) {
            updateMethod = GitUpdater.resolveUpdateMethod(this.myPushSpecs.keySet().iterator().next());
        }
        return new PushUpdateSettings(updateAllRoots, updateMethod);
    }

    @Nullable
    private PushUpdateSettings showDialogAndGetExitCode(@NotNull Set<? extends GitRepository> repositories, @NotNull PushUpdateSettings initialSettings, boolean rebaseOverMergeProblemDetected) {
        if (repositories == null) {
            GitPushOperation.$$$reportNull$$$0(36);
        }
        if (initialSettings == null) {
            GitPushOperation.$$$reportNull$$$0(37);
        }
        Ref updateSettings = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitRejectedPushUpdateDialog dialog = new GitRejectedPushUpdateDialog(this.myProject, repositories, initialSettings, rebaseOverMergeProblemDetected);
            DialogManager.show(dialog);
            int exitCode = dialog.getExitCode();
            if (exitCode != 1) {
                this.mySettings.setAutoUpdateIfPushRejected(dialog.shouldAutoUpdateInFuture());
                updateSettings.set((Object)new PushUpdateSettings(dialog.shouldUpdateAll(), GitPushOperation.convertUpdateMethodFromDialogExitCode(exitCode)));
            }
        });
        return (PushUpdateSettings)updateSettings.get();
    }

    @NotNull
    private static UpdateMethod convertUpdateMethodFromDialogExitCode(int exitCode) {
        switch (exitCode) {
            case 2: {
                UpdateMethod updateMethod = UpdateMethod.MERGE;
                if (updateMethod == null) {
                    GitPushOperation.$$$reportNull$$$0(38);
                }
                return updateMethod;
            }
            case 3: {
                UpdateMethod updateMethod = UpdateMethod.REBASE;
                if (updateMethod == null) {
                    GitPushOperation.$$$reportNull$$$0(39);
                }
                return updateMethod;
            }
        }
        throw new IllegalStateException("Unexpected exit code: " + exitCode);
    }

    @NotNull
    protected GitUpdateResult update(@NotNull Collection<? extends GitRepository> rootsToUpdate, @NotNull UpdateMethod updateMethod, boolean checkForRebaseOverMergeProblem) {
        if (rootsToUpdate == null) {
            GitPushOperation.$$$reportNull$$$0(40);
        }
        if (updateMethod == null) {
            GitPushOperation.$$$reportNull$$$0(41);
        }
        GitUpdateProcess updateProcess = new GitUpdateProcess(this.myProject, this.myProgressIndicator, new HashSet<GitRepository>(rootsToUpdate), UpdatedFiles.create(), checkForRebaseOverMergeProblem, false);
        GitUpdateResult updateResult = updateProcess.update(updateMethod);
        Map<GitRepository, HashRange> ranges = updateProcess.getUpdatedRanges();
        if (ranges != null) {
            this.joinUpdatedRanges(ranges);
        }
        for (GitRepository gitRepository : rootsToUpdate) {
            gitRepository.getRoot().refresh(true, true);
            gitRepository.update();
        }
        GitUpdateResult gitUpdateResult = updateResult;
        if (gitUpdateResult == null) {
            GitPushOperation.$$$reportNull$$$0(42);
        }
        return gitUpdateResult;
    }

    private void joinUpdatedRanges(@NotNull Map<GitRepository, HashRange> newRanges) {
        if (newRanges == null) {
            GitPushOperation.$$$reportNull$$$0(43);
        }
        for (GitRepository repository : newRanges.keySet()) {
            HashRange newRange = newRanges.get(repository);
            HashRange current = this.myUpdatedRanges.get(repository);
            HashRange joinedRange = current == null ? newRange : new HashRange(current.getStart(), newRange.getEnd());
            this.myUpdatedRanges.put(repository, joinedRange);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 24: 
            case 38: 
            case 39: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 24: 
            case 38: 
            case 39: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSupport";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSpecs";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 24: 
            case 38: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushOperation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forceMode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rejectedRepositories";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSearch";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRepositories";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rejected";
                break;
            }
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedRoots";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preUpdatePositions";
                break;
            }
            case 23: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preUpdatePosition";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSpec";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToUpdate";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateMethod";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushOperation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getForceMode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsToUpdate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootsWithMergeCommits";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRejectedAndNotPushed";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "updateRootInfoAndRememberPositions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "convertUpdateMethodFromDialogExitCode";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 24: 
            case 38: 
            case 39: 
            case 42: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRootsToUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findRootsWithMergeCommits";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deriveForceWithoutLease";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "pushingToNotTrackedBranch";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "pushingNotCurrentBranch";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRejectedAndNotPushed";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepareCombinedResult";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBranchResult";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectNumberOfPushedCommits";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectUpdatedFiles";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doPush";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "branchTrackingInfoIsSet";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "savePushUpdateSettings";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndGetExitCode";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "joinUpdatedRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 13: 
            case 18: 
            case 19: 
            case 24: 
            case 38: 
            case 39: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum ForceMode {
        NONE,
        FORCE,
        FORCE_WITH_LEASE;


        public boolean isForce() {
            return this != NONE;
        }
    }

    private static class ResultWithOutput {
        @NotNull
        private final List<GitPushNativeResult> parsedResults;
        @NotNull
        private final GitCommandResult resultOutput;

        ResultWithOutput(@NotNull GitCommandResult resultOutput) {
            if (resultOutput == null) {
                ResultWithOutput.$$$reportNull$$$0(0);
            }
            this.resultOutput = resultOutput;
            this.parsedResults = GitPushNativeResultParser.parse(resultOutput.getOutput());
        }

        boolean isError() {
            return this.parsedResults.isEmpty();
        }

        @NotNull
        String getErrorAsString() {
            String string = this.resultOutput.getErrorOutputAsJoinedString();
            if (string == null) {
                ResultWithOutput.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return "Parsed results: " + this.parsedResults + "\nCommand output:" + this.resultOutput;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultOutput";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushOperation$ResultWithOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushOperation$ResultWithOutput";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorAsString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

