/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitConflictsHolder
implements Disposable {
    public static final Topic<ConflictsListener> CONFLICTS_CHANGE = Topic.create((String)"GitConflictsHolder change", ConflictsListener.class);
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final List<GitConflict> myConflicts;
    private final Object LOCK;

    public GitConflictsHolder(@NotNull GitRepository repository) {
        if (repository == null) {
            GitConflictsHolder.$$$reportNull$$$0(0);
        }
        this.myConflicts = new ArrayList<GitConflict>();
        this.LOCK = new Object();
        this.myRepository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<GitConflict> getConflicts() {
        Object object = this.LOCK;
        // MONITORENTER : object
        ArrayList<GitConflict> arrayList = new ArrayList<GitConflict>(this.myConflicts);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        GitConflictsHolder.$$$reportNull$$$0(1);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myConflicts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GitConflict findConflict(@NotNull FilePath path) {
        if (path == null) {
            GitConflictsHolder.$$$reportNull$$$0(2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            return (GitConflict)ContainerUtil.find(this.myConflicts, it -> it.getFilePath().equals(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(@NotNull VcsDirtyScope scope, @NotNull Collection<? extends GitConflict> conflicts) {
        if (scope == null) {
            GitConflictsHolder.$$$reportNull$$$0(3);
        }
        if (conflicts == null) {
            GitConflictsHolder.$$$reportNull$$$0(4);
        }
        Object object = this.LOCK;
        synchronized (object) {
            HashMap<FilePath, GitConflict> map2 = new HashMap<FilePath, GitConflict>();
            for (GitConflict gitConflict : this.myConflicts) {
                if (scope.belongsTo(gitConflict.getFilePath())) continue;
                map2.put(gitConflict.getFilePath(), gitConflict);
            }
            for (GitConflict gitConflict : conflicts) {
                map2.put(gitConflict.getFilePath(), gitConflict);
            }
            this.myConflicts.clear();
            this.myConflicts.addAll(map2.values());
        }
        ((ConflictsListener)BackgroundTaskUtil.syncPublisher((Project)this.myRepository.getProject(), CONFLICTS_CHANGE)).conflictsChanged(this.myRepository);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitConflictsHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitConflictsHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findConflict";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ConflictsListener {
        public void conflictsChanged(@NotNull GitRepository var1);
    }
}

