/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.sun.jdi.InternalException;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

abstract class ConnectorImpl
implements Connector {
    final Map<String, Connector.Argument> defaultArguments = new LinkedHashMap<String, Connector.Argument>();
    static String trueString = null;
    static String falseString;
    private ResourceBundle messages = null;

    ConnectorImpl() {
    }

    @Override
    public Map<String, Connector.Argument> defaultArguments() {
        LinkedHashMap<String, Connector.Argument> defaults = new LinkedHashMap<String, Connector.Argument>();
        Collection<Connector.Argument> values = this.defaultArguments.values();
        for (Connector.Argument value : values) {
            ArgumentImpl argument = (ArgumentImpl)value;
            defaults.put(argument.name(), (Connector.Argument)argument.clone());
        }
        return defaults;
    }

    void addStringArgument(String name, String label, String description, String defaultValue, boolean mustSpecify) {
        this.defaultArguments.put(name, new StringArgumentImpl(name, label, description, defaultValue, mustSpecify));
    }

    void addBooleanArgument(String name, String label, String description, boolean defaultValue, boolean mustSpecify) {
        this.defaultArguments.put(name, new BooleanArgumentImpl(name, label, description, defaultValue, mustSpecify));
    }

    void addIntegerArgument(String name, String label, String description, String defaultValue, boolean mustSpecify, int min, int max) {
        this.defaultArguments.put(name, new IntegerArgumentImpl(name, label, description, defaultValue, mustSpecify, min, max));
    }

    void addSelectedArgument(String name, String label, String description, String defaultValue, boolean mustSpecify, List<String> list) {
        this.defaultArguments.put(name, new SelectedArgumentImpl(name, label, description, defaultValue, mustSpecify, list));
    }

    ArgumentImpl argument(String name, Map<String, ? extends Connector.Argument> arguments) throws IllegalConnectorArgumentsException {
        ArgumentImpl argument = (ArgumentImpl)arguments.get(name);
        if (argument == null) {
            throw new IllegalConnectorArgumentsException("Argument missing", name);
        }
        String value = argument.value();
        if (value == null || value.length() == 0) {
            if (argument.mustSpecify()) {
                throw new IllegalConnectorArgumentsException("Argument unspecified", name);
            }
        } else if (!argument.isValid(value)) {
            throw new IllegalConnectorArgumentsException("Argument invalid", name);
        }
        return argument;
    }

    String getString(String key) {
        if (this.messages == null) {
            this.messages = ResourceBundle.getBundle("com.jetbrains.jdi.resources.jdi");
        }
        return this.messages.getString(key);
    }

    public String toString() {
        String string = this.name() + " (defaults: ";
        Iterator<Connector.Argument> iter = this.defaultArguments().values().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            ArgumentImpl argument = (ArgumentImpl)iter.next();
            if (!first) {
                string = string + ", ";
            }
            string = string + argument.toString();
            first = false;
        }
        string = string + ")";
        return string;
    }

    class SelectedArgumentImpl
    extends ArgumentImpl
    implements Connector.SelectedArgument {
        private static final long serialVersionUID = -5689584530908382517L;
        private final List<String> choices;

        SelectedArgumentImpl(String name, String label, String description, String value, boolean mustSpecify, List<String> choices) {
            super(name, label, description, value, mustSpecify);
            this.choices = Collections.unmodifiableList(new ArrayList<String>(choices));
        }

        @Override
        public List<String> choices() {
            return this.choices;
        }

        @Override
        public boolean isValid(String value) {
            return this.choices.contains(value);
        }
    }

    class StringArgumentImpl
    extends ArgumentImpl
    implements Connector.StringArgument {
        private static final long serialVersionUID = 7500484902692107464L;

        StringArgumentImpl(String name, String label, String description, String value, boolean mustSpecify) {
            super(name, label, description, value, mustSpecify);
        }

        @Override
        public boolean isValid(String value) {
            return true;
        }
    }

    class IntegerArgumentImpl
    extends ArgumentImpl
    implements Connector.IntegerArgument {
        private static final long serialVersionUID = 763286081923797770L;
        private final int min;
        private final int max;

        IntegerArgumentImpl(String name, String label, String description, String value, boolean mustSpecify, int min, int max) {
            super(name, label, description, value, mustSpecify);
            this.min = min;
            this.max = max;
        }

        @Override
        public void setValue(int value) {
            this.setValue(this.stringValueOf(value));
        }

        @Override
        public boolean isValid(String value) {
            if (value == null) {
                return false;
            }
            try {
                return this.isValid(Integer.decode(value));
            }
            catch (NumberFormatException exc) {
                return false;
            }
        }

        @Override
        public boolean isValid(int value) {
            return this.min <= value && value <= this.max;
        }

        @Override
        public String stringValueOf(int value) {
            return "" + value;
        }

        @Override
        public int intValue() {
            if (this.value() == null) {
                return 0;
            }
            try {
                return Integer.decode(this.value());
            }
            catch (NumberFormatException exc) {
                return 0;
            }
        }

        @Override
        public int max() {
            return this.max;
        }

        @Override
        public int min() {
            return this.min;
        }
    }

    class BooleanArgumentImpl
    extends ArgumentImpl
    implements Connector.BooleanArgument {
        private static final long serialVersionUID = 1624542968639361316L;

        BooleanArgumentImpl(String name, String label, String description, boolean value, boolean mustSpecify) {
            super(name, label, description, null, mustSpecify);
            if (trueString == null) {
                trueString = ConnectorImpl.this.getString("true");
                falseString = ConnectorImpl.this.getString("false");
            }
            this.setValue(value);
        }

        @Override
        public void setValue(boolean value) {
            this.setValue(this.stringValueOf(value));
        }

        @Override
        public boolean isValid(String value) {
            return value.equals(trueString) || value.equals(falseString);
        }

        @Override
        public String stringValueOf(boolean value) {
            return value ? trueString : falseString;
        }

        @Override
        public boolean booleanValue() {
            return this.value().equals(trueString);
        }
    }

    abstract class ArgumentImpl
    implements Connector.Argument,
    Cloneable {
        private final String name;
        private final String label;
        private final String description;
        private String value;
        private final boolean mustSpecify;

        ArgumentImpl(String name, String label, String description, String value, boolean mustSpecify) {
            this.name = name;
            this.label = label;
            this.description = description;
            this.value = value;
            this.mustSpecify = mustSpecify;
        }

        @Override
        public abstract boolean isValid(String var1);

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String label() {
            return this.label;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            if (value == null) {
                throw new NullPointerException("Can't set null value");
            }
            this.value = value;
        }

        @Override
        public boolean mustSpecify() {
            return this.mustSpecify;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof Connector.Argument) {
                Connector.Argument other = (Connector.Argument)obj;
                return this.name().equals(other.name()) && this.description().equals(other.description()) && this.mustSpecify() == other.mustSpecify() && this.value().equals(other.value());
            }
            return false;
        }

        public int hashCode() {
            return this.description().hashCode();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalException();
            }
        }

        public String toString() {
            return this.name() + "=" + this.value();
        }
    }
}

