/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.Mirror;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.VirtualMachine;
import java.util.Collection;

abstract class MirrorImpl
implements Mirror {
    protected VirtualMachineImpl vm;

    MirrorImpl(VirtualMachine aVm) {
        this.vm = (VirtualMachineImpl)aVm;
    }

    @Override
    public VirtualMachine virtualMachine() {
        return this.vm;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Mirror) {
            Mirror other = (Mirror)obj;
            return this.vm.equals(other.virtualMachine());
        }
        return false;
    }

    public int hashCode() {
        return this.vm.hashCode();
    }

    void validateMirror(Mirror mirror) {
        if (!this.vm.equals(mirror.virtualMachine())) {
            throw new VMMismatchException(mirror.toString());
        }
    }

    void validateMirrorOrNull(Mirror mirror) {
        if (mirror != null && !this.vm.equals(mirror.virtualMachine())) {
            throw new VMMismatchException(mirror.toString());
        }
    }

    void validateMirrors(Collection<? extends Mirror> mirrors) {
        for (Mirror mirror : mirrors) {
            this.validateMirror(mirror);
        }
    }

    void validateMirrorsOrNulls(Collection<? extends Mirror> mirrors) {
        for (Mirror mirror : mirrors) {
            this.validateMirrorOrNull(mirror);
        }
    }
}

