/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.jdi.FieldImpl;
import com.jetbrains.jdi.InterfaceTypeImpl;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.ObsoleteMethodImpl;
import com.jetbrains.jdi.SDE;
import com.jetbrains.jdi.TypeImpl;
import com.jetbrains.jdi.ValueImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class ReferenceTypeImpl
extends TypeImpl
implements ReferenceType {
    protected final long ref;
    private String signature = null;
    private String genericSignature = null;
    private boolean genericSignatureGotten;
    private String baseSourceName = null;
    private String baseSourceDir = null;
    private String baseSourcePath = null;
    protected int modifiers = -1;
    private SoftReference<List<Field>> fieldsRef = null;
    private SoftReference<List<Method>> methodsRef = null;
    private SoftReference<SDE> sdeRef = null;
    private boolean isClassLoaderCached = false;
    private ClassLoaderReference classLoader = null;
    private ClassObjectReference classObject = null;
    private int status = 0;
    private boolean isPrepared = false;
    private boolean versionNumberGotten = false;
    private int majorVersion;
    private int minorVersion;
    private boolean constantPoolInfoGotten = false;
    private int constanPoolCount;
    private SoftReference<byte[]> constantPoolBytesRef = null;
    private static final String ABSENT_BASE_SOURCE_NAME = "**ABSENT_BASE_SOURCE_NAME**";
    static final SDE NO_SDE_INFO_MARK = new SDE();
    private static final int INITIALIZED_OR_FAILED = 12;

    protected ReferenceTypeImpl(VirtualMachine aVm, long aRef) {
        super(aVm);
        this.ref = aRef;
        this.genericSignatureGotten = false;
    }

    public void noticeRedefineClass() {
        this.baseSourceName = null;
        this.baseSourcePath = null;
        this.modifiers = -1;
        this.fieldsRef = null;
        this.methodsRef = null;
        this.sdeRef = null;
        this.versionNumberGotten = false;
        this.constantPoolInfoGotten = false;
    }

    Method getMethodMirror(long ref) {
        if (ref == 0L) {
            return new ObsoleteMethodImpl(this.vm, this);
        }
        for (Method value : this.methods()) {
            MethodImpl method = (MethodImpl)value;
            if (method.ref() != ref) continue;
            return method;
        }
        throw new IllegalArgumentException("Invalid method id: " + ref);
    }

    Field getFieldMirror(long ref) {
        for (Field value : this.fields()) {
            FieldImpl field = (FieldImpl)value;
            if (field.ref() != ref) continue;
            return field;
        }
        throw new IllegalArgumentException("Invalid field id: " + ref);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ReferenceTypeImpl) {
            ReferenceTypeImpl other = (ReferenceTypeImpl)obj;
            return this.ref() == other.ref() && this.vm.equals(other.virtualMachine());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)this.ref();
    }

    @Override
    public int compareTo(ReferenceType object) {
        ReferenceTypeImpl other = (ReferenceTypeImpl)object;
        int comp = this.name().compareTo(other.name());
        if (comp == 0) {
            long rf2;
            long rf1 = this.ref();
            comp = rf1 == (rf2 = other.ref()) ? this.vm.sequenceNumber - ((VirtualMachineImpl)other.virtualMachine()).sequenceNumber : (rf1 < rf2 ? -1 : 1);
        }
        return comp;
    }

    @Override
    public String signature() {
        if (this.signature == null) {
            if (this.vm.canGet1_5LanguageFeatures()) {
                this.genericSignature();
            } else {
                try {
                    this.setSignature(JDWP.ReferenceType.Signature.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).signature);
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
            }
        }
        return this.signature;
    }

    @Override
    public String genericSignature() {
        if (this.vm.canGet1_5LanguageFeatures() && !this.genericSignatureGotten) {
            JDWP.ReferenceType.SignatureWithGeneric result;
            try {
                result = JDWP.ReferenceType.SignatureWithGeneric.process(this.vm, this);
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
            this.setSignature(result.signature);
            this.setGenericSignature(result.genericSignature);
        }
        return this.genericSignature;
    }

    @Override
    public ClassLoaderReference classLoader() {
        if (!this.isClassLoaderCached) {
            try {
                this.classLoader = JDWP.ReferenceType.ClassLoader.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).classLoader;
                this.isClassLoaderCached = true;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.classLoader;
    }

    @Override
    public boolean isPublic() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 1) > 0;
    }

    @Override
    public boolean isProtected() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 4) > 0;
    }

    @Override
    public boolean isPrivate() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 2) > 0;
    }

    @Override
    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    @Override
    public boolean isAbstract() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 0x400) > 0;
    }

    @Override
    public boolean isFinal() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 0x10) > 0;
    }

    @Override
    public boolean isStatic() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return (this.modifiers & 8) > 0;
    }

    @Override
    public boolean isPrepared() {
        if (this.status == 0) {
            this.updateStatus();
        }
        return this.isPrepared;
    }

    @Override
    public boolean isVerified() {
        if ((this.status & 1) == 0) {
            this.updateStatus();
        }
        return (this.status & 1) != 0;
    }

    @Override
    public boolean isInitialized() {
        if ((this.status & 0xC) == 0) {
            this.updateStatus();
        }
        return (this.status & 4) != 0;
    }

    @Override
    public boolean failedToInitialize() {
        if ((this.status & 0xC) == 0) {
            this.updateStatus();
        }
        return (this.status & 8) != 0;
    }

    @Override
    public List<Field> fields() {
        List<Field> fields;
        List<Field> list = fields = this.fieldsRef == null ? null : this.fieldsRef.get();
        if (fields == null) {
            if (this.vm.canGet1_5LanguageFeatures()) {
                JDWP.ReferenceType.FieldsWithGeneric.FieldInfo[] jdwpFields;
                try {
                    jdwpFields = JDWP.ReferenceType.FieldsWithGeneric.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).declared;
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
                fields = new ArrayList<Field>(jdwpFields.length);
                for (JDWP.ReferenceType.FieldsWithGeneric.FieldInfo fi : jdwpFields) {
                    FieldImpl field = new FieldImpl(this.vm, this, fi.fieldID, fi.name, fi.signature, fi.genericSignature, fi.modBits);
                    fields.add(field);
                }
            } else {
                JDWP.ReferenceType.Fields.FieldInfo[] jdwpFields;
                try {
                    jdwpFields = JDWP.ReferenceType.Fields.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).declared;
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
                fields = new ArrayList<Field>(jdwpFields.length);
                for (JDWP.ReferenceType.Fields.FieldInfo fi : jdwpFields) {
                    FieldImpl field = new FieldImpl(this.vm, this, fi.fieldID, fi.name, fi.signature, null, fi.modBits);
                    fields.add(field);
                }
            }
            fields = Collections.unmodifiableList(fields);
            this.fieldsRef = new SoftReference<List<Field>>(fields);
        }
        return fields;
    }

    abstract List<? extends ReferenceType> inheritedTypes();

    void addVisibleFields(List<Field> visibleList, Map<String, Field> visibleTable, List<String> ambiguousNames) {
        for (Field field : this.visibleFields()) {
            String name = field.name();
            if (ambiguousNames.contains(name)) continue;
            Field duplicate = visibleTable.get(name);
            if (duplicate == null) {
                visibleList.add(field);
                visibleTable.put(name, field);
                continue;
            }
            if (field.equals(duplicate)) continue;
            ambiguousNames.add(name);
            visibleTable.remove(name);
            visibleList.remove(duplicate);
        }
    }

    @Override
    public List<Field> visibleFields() {
        ArrayList<Field> visibleList = new ArrayList<Field>();
        HashMap<String, Field> visibleTable = new HashMap<String, Field>();
        ArrayList<String> ambiguousNames = new ArrayList<String>();
        List<? extends ReferenceType> types = this.inheritedTypes();
        for (ReferenceType referenceType : types) {
            ReferenceTypeImpl type = (ReferenceTypeImpl)referenceType;
            type.addVisibleFields(visibleList, visibleTable, ambiguousNames);
        }
        ArrayList<Field> retList = new ArrayList<Field>(this.fields());
        for (Field field : retList) {
            Field hidden = (Field)visibleTable.get(field.name());
            if (hidden == null) continue;
            visibleList.remove(hidden);
        }
        retList.addAll(visibleList);
        return retList;
    }

    void addAllFields(List<Field> fieldList, Set<ReferenceType> typeSet) {
        if (!typeSet.contains(this)) {
            typeSet.add(this);
            fieldList.addAll(this.fields());
            List<? extends ReferenceType> types = this.inheritedTypes();
            for (ReferenceType referenceType : types) {
                ReferenceTypeImpl type = (ReferenceTypeImpl)referenceType;
                type.addAllFields(fieldList, typeSet);
            }
        }
    }

    @Override
    public List<Field> allFields() {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashSet<ReferenceType> typeSet = new HashSet<ReferenceType>();
        this.addAllFields(fieldList, typeSet);
        return fieldList;
    }

    @Override
    public Field fieldByName(String fieldName) {
        List<Field> searchList = this.visibleFields();
        for (Field f : searchList) {
            if (!f.name().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    @Override
    public List<Method> methods() {
        List<Method> methods;
        List<Method> list = methods = this.methodsRef == null ? null : this.methodsRef.get();
        if (methods == null) {
            if (!this.vm.canGet1_5LanguageFeatures()) {
                methods = this.methods1_4();
            } else {
                JDWP.ReferenceType.MethodsWithGeneric.MethodInfo[] declared;
                try {
                    declared = JDWP.ReferenceType.MethodsWithGeneric.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).declared;
                }
                catch (JDWPException exc) {
                    throw exc.toJDIException();
                }
                methods = new ArrayList<Method>(declared.length);
                for (JDWP.ReferenceType.MethodsWithGeneric.MethodInfo mi : declared) {
                    MethodImpl method = MethodImpl.createMethodImpl(this.vm, this, mi.methodID, mi.name, mi.signature, mi.genericSignature, mi.modBits);
                    methods.add(method);
                }
            }
            methods = Collections.unmodifiableList(methods);
            this.methodsRef = new SoftReference<List<Method>>(methods);
        }
        return methods;
    }

    private List<Method> methods1_4() {
        JDWP.ReferenceType.Methods.MethodInfo[] declared;
        try {
            declared = JDWP.ReferenceType.Methods.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).declared;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        ArrayList<Method> methods = new ArrayList<Method>(declared.length);
        for (JDWP.ReferenceType.Methods.MethodInfo mi : declared) {
            MethodImpl method = MethodImpl.createMethodImpl(this.vm, this, mi.methodID, mi.name, mi.signature, null, mi.modBits);
            methods.add(method);
        }
        return methods;
    }

    void addToMethodMap(Map<String, Method> methodMap, List<Method> methodList) {
        for (Method method : methodList) {
            methodMap.put(method.name().concat(method.signature()), method);
        }
    }

    abstract void addVisibleMethods(Map<String, Method> var1, Set<InterfaceType> var2);

    @Override
    public List<Method> visibleMethods() {
        HashMap<String, Method> map = new HashMap<String, Method>();
        this.addVisibleMethods(map, new HashSet<InterfaceType>());
        List<Method> list = this.allMethods();
        list.retainAll(new HashSet(map.values()));
        return list;
    }

    @Override
    public abstract List<Method> allMethods();

    @Override
    public List<Method> methodsByName(String name) {
        List<Method> methods = this.visibleMethods();
        ArrayList<Method> retList = new ArrayList<Method>(methods.size());
        for (Method candidate : methods) {
            if (!candidate.name().equals(name)) continue;
            retList.add(candidate);
        }
        retList.trimToSize();
        return retList;
    }

    @Override
    public List<Method> methodsByName(String name, String signature) {
        List<Method> methods = this.visibleMethods();
        ArrayList<Method> retList = new ArrayList<Method>(methods.size());
        for (Method candidate : methods) {
            if (!candidate.name().equals(name) || !candidate.signature().equals(signature)) continue;
            retList.add(candidate);
        }
        retList.trimToSize();
        return retList;
    }

    List<InterfaceType> getInterfaces() {
        InterfaceTypeImpl[] intfs;
        try {
            intfs = JDWP.ReferenceType.Interfaces.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).interfaces;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return Arrays.asList(intfs);
    }

    @Override
    public List<ReferenceType> nestedTypes() {
        ArrayList<ReferenceType> nested = new ArrayList<ReferenceType>();
        String outername = this.name();
        int outerlen = outername.length();
        this.vm.forEachClass(refType -> {
            char c;
            String name = refType.name();
            int len = name.length();
            if (len > outerlen && name.startsWith(outername) && ((c = name.charAt(outerlen)) == '$' || c == '#')) {
                nested.add((ReferenceType)refType);
            }
        });
        return nested;
    }

    @Override
    public Value getValue(Field sig) {
        ArrayList<Field> list = new ArrayList<Field>(1);
        list.add(sig);
        Map<Field, Value> map = this.getValues(list);
        return map.get(sig);
    }

    void validateFieldAccess(Field field) {
        ReferenceTypeImpl declType = (ReferenceTypeImpl)field.declaringType();
        if (!declType.isAssignableFrom(this)) {
            throw new IllegalArgumentException("Invalid field");
        }
    }

    void validateFieldSet(Field field) {
        this.validateFieldAccess(field);
        if (field.isFinal()) {
            throw new IllegalArgumentException("Cannot set value of final field");
        }
    }

    @Override
    public Map<Field, Value> getValues(List<? extends Field> theFields) {
        ValueImpl[] values;
        this.validateMirrors(theFields);
        int size = theFields.size();
        JDWP.ReferenceType.GetValues.Field[] queryFields = new JDWP.ReferenceType.GetValues.Field[size];
        for (int i = 0; i < size; ++i) {
            FieldImpl field = (FieldImpl)theFields.get(i);
            this.validateFieldAccess(field);
            if (!field.isStatic()) {
                throw new IllegalArgumentException("Attempt to use non-static field with ReferenceType");
            }
            queryFields[i] = new JDWP.ReferenceType.GetValues.Field(field.ref());
        }
        HashMap<Field, Value> map = new HashMap<Field, Value>(size);
        try {
            values = JDWP.ReferenceType.GetValues.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this, (JDWP.ReferenceType.GetValues.Field[])queryFields).values;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        if (size != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        for (int i = 0; i < size; ++i) {
            FieldImpl field = (FieldImpl)theFields.get(i);
            map.put(field, values[i]);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassObjectReference classObject() {
        if (this.classObject == null) {
            ReferenceTypeImpl referenceTypeImpl = this;
            synchronized (referenceTypeImpl) {
                if (this.classObject == null) {
                    try {
                        this.classObject = JDWP.ReferenceType.ClassObject.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).classObject;
                    }
                    catch (JDWPException exc) {
                        throw exc.toJDIException();
                    }
                }
            }
        }
        return this.classObject;
    }

    SDE.Stratum stratum(String stratumID) {
        SDE sde = this.sourceDebugExtensionInfo();
        if (!sde.isValid()) {
            sde = NO_SDE_INFO_MARK;
        }
        return sde.stratum(stratumID);
    }

    @Override
    public String sourceName() throws AbsentInformationException {
        return this.sourceNames(this.vm.getDefaultStratum()).get(0);
    }

    @Override
    public List<String> sourceNames(String stratumID) throws AbsentInformationException {
        SDE.Stratum stratum = this.stratum(stratumID);
        if (stratum.isJava()) {
            ArrayList<String> result = new ArrayList<String>(1);
            result.add(this.baseSourceName());
            return result;
        }
        return stratum.sourceNames(this);
    }

    @Override
    public List<String> sourcePaths(String stratumID) throws AbsentInformationException {
        SDE.Stratum stratum = this.stratum(stratumID);
        if (stratum.isJava()) {
            ArrayList<String> result = new ArrayList<String>(1);
            result.add(this.baseSourceDir() + this.baseSourceName());
            return result;
        }
        return stratum.sourcePaths(this);
    }

    String baseSourceName() throws AbsentInformationException {
        String bsn = this.baseSourceName;
        if (bsn == null) {
            try {
                bsn = JDWP.ReferenceType.SourceFile.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).sourceFile;
            }
            catch (JDWPException exc) {
                if (exc.errorCode() == 101) {
                    bsn = ABSENT_BASE_SOURCE_NAME;
                }
                throw exc.toJDIException();
            }
            this.baseSourceName = bsn;
        }
        if (bsn == ABSENT_BASE_SOURCE_NAME) {
            throw new AbsentInformationException();
        }
        return bsn;
    }

    String baseSourcePath() throws AbsentInformationException {
        String bsp = this.baseSourcePath;
        if (bsp == null) {
            this.baseSourcePath = bsp = this.baseSourceDir() + this.baseSourceName();
        }
        return bsp;
    }

    String baseSourceDir() {
        if (this.baseSourceDir == null) {
            int nextIndex;
            String typeName = this.name();
            StringBuilder sb = new StringBuilder(typeName.length() + 10);
            int index = 0;
            while ((nextIndex = typeName.indexOf(46, index)) > 0) {
                sb.append(typeName, index, nextIndex);
                sb.append(File.separatorChar);
                index = nextIndex + 1;
            }
            this.baseSourceDir = sb.toString();
        }
        return this.baseSourceDir;
    }

    @Override
    public String sourceDebugExtension() throws AbsentInformationException {
        if (!this.vm.canGetSourceDebugExtension()) {
            throw new UnsupportedOperationException();
        }
        SDE sde = this.sourceDebugExtensionInfo();
        if (sde == NO_SDE_INFO_MARK) {
            throw new AbsentInformationException();
        }
        return sde.sourceDebugExtension;
    }

    private SDE sourceDebugExtensionInfo() {
        SDE sde;
        if (!this.vm.canGetSourceDebugExtension()) {
            return NO_SDE_INFO_MARK;
        }
        SDE sDE = sde = this.sdeRef == null ? null : this.sdeRef.get();
        if (sde == null) {
            String extension;
            block4: {
                extension = null;
                try {
                    extension = JDWP.ReferenceType.SourceDebugExtension.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).extension;
                }
                catch (JDWPException exc) {
                    if (exc.errorCode() == 101) break block4;
                    this.sdeRef = new SoftReference<SDE>(NO_SDE_INFO_MARK);
                    throw exc.toJDIException();
                }
            }
            sde = extension == null ? NO_SDE_INFO_MARK : new SDE(extension);
            this.sdeRef = new SoftReference<SDE>(sde);
        }
        return sde;
    }

    @Override
    public List<String> availableStrata() {
        SDE sde = this.sourceDebugExtensionInfo();
        if (sde.isValid()) {
            return sde.availableStrata();
        }
        ArrayList<String> strata = new ArrayList<String>();
        strata.add("Java");
        return strata;
    }

    @Override
    public String defaultStratum() {
        SDE sdei = this.sourceDebugExtensionInfo();
        if (sdei.isValid()) {
            return sdei.defaultStratumId;
        }
        return "Java";
    }

    @Override
    public int modifiers() {
        if (this.modifiers == -1) {
            this.getModifiers();
        }
        return this.modifiers;
    }

    @Override
    public List<Location> allLineLocations() throws AbsentInformationException {
        return this.allLineLocations(this.vm.getDefaultStratum(), null);
    }

    @Override
    public List<Location> allLineLocations(String stratumID, String sourceName) throws AbsentInformationException {
        boolean someAbsent = false;
        SDE.Stratum stratum = this.stratum(stratumID);
        ArrayList<Location> list = new ArrayList<Location>();
        for (Method value : this.methods()) {
            MethodImpl method = (MethodImpl)value;
            try {
                list.addAll(method.allLineLocations(stratum, sourceName));
            }
            catch (AbsentInformationException exc) {
                someAbsent = true;
            }
        }
        if (someAbsent && list.size() == 0) {
            throw new AbsentInformationException();
        }
        return list;
    }

    @Override
    public List<Location> locationsOfLine(int lineNumber) throws AbsentInformationException {
        return this.locationsOfLine(this.vm.getDefaultStratum(), null, lineNumber);
    }

    @Override
    public List<Location> locationsOfLine(String stratumID, String sourceName, int lineNumber) throws AbsentInformationException {
        boolean someAbsent = false;
        boolean somePresent = false;
        List<Method> methods = this.methods();
        SDE.Stratum stratum = this.stratum(stratumID);
        ArrayList<Location> list = new ArrayList<Location>();
        for (Method value : methods) {
            MethodImpl method = (MethodImpl)value;
            if (method.isAbstract() || method.isNative()) continue;
            try {
                list.addAll(method.locationsOfLine(stratum, sourceName, lineNumber));
                somePresent = true;
            }
            catch (AbsentInformationException exc) {
                someAbsent = true;
            }
        }
        if (someAbsent && !somePresent) {
            throw new AbsentInformationException();
        }
        return list;
    }

    @Override
    public List<ObjectReference> instances(long maxInstances) {
        if (!this.vm.canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting instances");
        }
        if (maxInstances < 0L) {
            throw new IllegalArgumentException("maxInstances is less than zero: " + maxInstances);
        }
        int intMax = maxInstances > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxInstances;
        try {
            return Arrays.asList(JDWP.ReferenceType.Instances.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this, (int)intMax).instances);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    private void getClassFileVersion() {
        if (!this.vm.canGetClassFileVersion()) {
            throw new UnsupportedOperationException();
        }
        if (!this.versionNumberGotten) {
            JDWP.ReferenceType.ClassFileVersion classFileVersion;
            try {
                classFileVersion = JDWP.ReferenceType.ClassFileVersion.process(this.vm, this);
            }
            catch (JDWPException exc) {
                if (exc.errorCode() == 101) {
                    this.majorVersion = 0;
                    this.minorVersion = 0;
                    this.versionNumberGotten = true;
                    return;
                }
                throw exc.toJDIException();
            }
            this.majorVersion = classFileVersion.majorVersion;
            this.minorVersion = classFileVersion.minorVersion;
            this.versionNumberGotten = true;
        }
    }

    @Override
    public int majorVersion() {
        this.getClassFileVersion();
        return this.majorVersion;
    }

    @Override
    public int minorVersion() {
        this.getClassFileVersion();
        return this.minorVersion;
    }

    private byte[] getConstantPoolInfo() {
        JDWP.ReferenceType.ConstantPool jdwpCPool;
        byte[] cpbytes;
        if (!this.vm.canGetConstantPool()) {
            throw new UnsupportedOperationException();
        }
        if (this.constantPoolInfoGotten) {
            if (this.constantPoolBytesRef == null) {
                return null;
            }
            cpbytes = this.constantPoolBytesRef.get();
            if (cpbytes != null) {
                return cpbytes;
            }
        }
        try {
            jdwpCPool = JDWP.ReferenceType.ConstantPool.process(this.vm, this);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 101) {
                this.constanPoolCount = 0;
                this.constantPoolBytesRef = null;
                this.constantPoolInfoGotten = true;
                return null;
            }
            throw exc.toJDIException();
        }
        this.constanPoolCount = jdwpCPool.count;
        cpbytes = jdwpCPool.bytes;
        this.constantPoolBytesRef = new SoftReference<byte[]>(cpbytes);
        this.constantPoolInfoGotten = true;
        return cpbytes;
    }

    @Override
    public int constantPoolCount() {
        this.getConstantPoolInfo();
        return this.constanPoolCount;
    }

    @Override
    public byte[] constantPool() {
        byte[] cpbytes = this.getConstantPoolInfo();
        if (cpbytes != null) {
            return (byte[])cpbytes.clone();
        }
        return null;
    }

    void getModifiers() {
        if (this.modifiers != -1) {
            return;
        }
        try {
            this.modifiers = JDWP.ReferenceType.Modifiers.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).modBits;
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    void decodeStatus(int status) {
        this.status = status;
        if ((status & 2) != 0) {
            this.isPrepared = true;
        }
    }

    void updateStatus() {
        try {
            this.decodeStatus(JDWP.ReferenceType.Status.process((VirtualMachineImpl)this.vm, (ReferenceTypeImpl)this).status);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    void markPrepared() {
        this.isPrepared = true;
    }

    long ref() {
        return this.ref;
    }

    int indexOf(Method method) {
        return this.methods().indexOf(method);
    }

    int indexOf(Field field) {
        return this.fields().indexOf(field);
    }

    abstract boolean isAssignableTo(ReferenceType var1);

    boolean isAssignableFrom(ReferenceType type) {
        return ((ReferenceTypeImpl)type).isAssignableTo(this);
    }

    boolean isAssignableFrom(ObjectReference object) {
        return object == null || this.isAssignableFrom(object.referenceType());
    }

    void setStatus(int status) {
        this.decodeStatus(status);
    }

    void setSignature(String signature) {
        if (!Objects.equals(this.signature, signature)) {
            this.vm.cacheTypeBySignature(this, signature);
        }
        this.signature = signature;
    }

    void setGenericSignature(String signature) {
        this.genericSignature = signature != null && signature.length() == 0 ? null : signature;
        this.genericSignatureGotten = true;
    }

    private static boolean isOneDimensionalPrimitiveArray(String signature) {
        char c;
        int i = signature.lastIndexOf(91);
        boolean isPA = i < 0 || signature.startsWith("[[") ? false : (c = signature.charAt(i + 1)) != 'L';
        return isPA;
    }

    Type findType(String signature) throws ClassNotLoadedException {
        ClassLoaderReferenceImpl loader;
        char sig;
        Type type = signature.length() == 1 ? ((sig = signature.charAt(0)) == 'V' ? this.vm.theVoidType() : this.vm.primitiveTypeMirror((byte)sig)) : ((loader = (ClassLoaderReferenceImpl)this.classLoader()) == null || ReferenceTypeImpl.isOneDimensionalPrimitiveArray(signature) ? this.vm.findBootType(signature) : loader.findType(signature));
        return type;
    }

    String loaderString() {
        if (this.classLoader() != null) {
            return "loaded by " + this.classLoader().toString();
        }
        return "no class loader";
    }
}

