/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.ArrayList;
import java.util.List;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;
import org.jline.utils.WCWidth;

public abstract class AttributedCharSequence
implements CharSequence {
    private static final int[] COLORS_256 = new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0xC0C0C0, 0x808080, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF, 0, 95, 135, 175, 215, 255, 24320, 24415, 24455, 24495, 24535, 24575, 34560, 34655, 34695, 34735, 34775, 34815, 44800, 44895, 44935, 44975, 45015, 45055, 55040, 55135, 55175, 55215, 55255, 55295, 65280, 65375, 65415, 65455, 65495, 65535, 0x5F0000, 0x5F005F, 6226055, 6226095, 6226135, 0x5F00FF, 0x5F5F00, 0x5F5F5F, 6250375, 0x5F5FAF, 6250455, 0x5F5FFF, 6260480, 6260575, 6260615, 6260655, 6260695, 6260735, 6270720, 0x5FAF5F, 6270855, 0x5FAFAF, 6270935, 0x5FAFFF, 6280960, 6281055, 6281095, 6281135, 6281175, 6281215, 0x5FFF00, 0x5FFF5F, 6291335, 0x5FFFAF, 6291415, 0x5FFFFF, 0x870000, 8847455, 0x870087, 8847535, 8847575, 8847615, 8871680, 8871775, 8871815, 8871855, 8871895, 8871935, 0x878700, 8882015, 0x878787, 8882095, 0x8787D7, 0x8787FF, 8892160, 8892255, 8892295, 8892335, 8892375, 8892415, 8902400, 8902495, 0x87D787, 8902575, 0x87D7D7, 8902655, 8912640, 8912735, 0x87FF87, 8912815, 8912855, 0x87FFFF, 0xAF0000, 11468895, 11468935, 0xAF00AF, 11469015, 0xAF00FF, 11493120, 0xAF5F5F, 11493255, 0xAF5FAF, 11493335, 0xAF5FFF, 11503360, 11503455, 11503495, 11503535, 11503575, 11503615, 0xAFAF00, 0xAFAF5F, 11513735, 0xAFAFAF, 11513815, 0xAFAFFF, 11523840, 11523935, 11523975, 11524015, 11524055, 11524095, 0xAFFF00, 0xAFFF5F, 11534215, 0xAFFFAF, 11534295, 0xAFFFFF, 0xD70000, 14090335, 14090375, 14090415, 0xD700D7, 14090495, 14114560, 14114655, 14114695, 14114735, 14114775, 14114815, 14124800, 14124895, 0xD78787, 14124975, 0xD787D7, 14125055, 14135040, 14135135, 14135175, 14135215, 14135255, 14135295, 0xD7D700, 14145375, 0xD7D787, 14145455, 0xD7D7D7, 0xD7D7FF, 14155520, 14155615, 14155655, 14155695, 0xD7FFD7, 0xD7FFFF, 0xFF0000, 0xFF005F, 16711815, 0xFF00AF, 16711895, 0xFF00FF, 0xFF5F00, 0xFF5F5F, 16736135, 0xFF5FAF, 16736215, 0xFF5FFF, 16746240, 16746335, 0xFF8787, 16746415, 16746455, 0xFF87FF, 0xFFAF00, 0xFFAF5F, 16756615, 0xFFAFAF, 16756695, 0xFFAFFF, 16766720, 16766815, 16766855, 16766895, 0xFFD7D7, 0xFFD7FF, 0xFFFF00, 0xFFFF5F, 0xFFFF87, 0xFFFFAF, 0xFFFFD7, 0xFFFFFF, 526344, 0x121212, 0x1C1C1C, 0x262626, 0x303030, 0x3A3A3A, 0x444444, 0x4E4E4E, 0x585858, 0x626262, 0x6C6C6C, 0x767676, 0x808080, 0x8A8A8A, 0x949494, 0x9E9E9E, 0xA8A8A8, 0xB2B2B2, 0xBCBCBC, 0xC6C6C6, 0xD0D0D0, 0xDADADA, 0xE4E4E4, 0xEEEEEE};

    public String toAnsi(Terminal terminal) {
        Integer max_colors;
        if (terminal != null && "dumb".equals(terminal.getType())) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        int style = 0;
        int foreground = -1;
        int background = -1;
        int colors = 8;
        if (terminal != null && (max_colors = terminal.getNumericCapability(InfoCmp.Capability.max_colors)) != null) {
            colors = max_colors;
        }
        for (int i = 0; i < this.length(); ++i) {
            char c = this.charAt(i);
            int s = this.styleCodeAt(i) & 0xFFFFFBFF;
            if (style != s) {
                int bg;
                int d = (style ^ s) & 0x7FF;
                int fg = (s & 0x100) != 0 ? (s & 0xFF0000) >>> 16 : -1;
                int n = bg = (s & 0x200) != 0 ? (s & 0xFF000000) >>> 24 : -1;
                if (s == 0) {
                    sb.append("\u001b[0m");
                    background = -1;
                    foreground = -1;
                } else {
                    int rounded;
                    sb.append("\u001b[");
                    boolean first2 = true;
                    if ((d & 3) != 0) {
                        if ((d & 1) != 0 && (s & 1) == 0 || (d & 2) != 0 && (s & 2) == 0) {
                            first2 = AttributedCharSequence.attr(sb, "22", first2);
                        }
                        if ((d & 1) != 0 && (s & 1) != 0) {
                            first2 = AttributedCharSequence.attr(sb, "1", first2);
                        }
                        if ((d & 2) != 0 && (s & 2) != 0) {
                            first2 = AttributedCharSequence.attr(sb, "2", first2);
                        }
                    }
                    if ((d & 4) != 0) {
                        first2 = AttributedCharSequence.attr(sb, (s & 4) != 0 ? "3" : "23", first2);
                    }
                    if ((d & 8) != 0) {
                        first2 = AttributedCharSequence.attr(sb, (s & 8) != 0 ? "4" : "24", first2);
                    }
                    if ((d & 0x10) != 0) {
                        first2 = AttributedCharSequence.attr(sb, (s & 0x10) != 0 ? "5" : "25", first2);
                    }
                    if ((d & 0x20) != 0) {
                        first2 = AttributedCharSequence.attr(sb, (s & 0x20) != 0 ? "7" : "27", first2);
                    }
                    if ((d & 0x40) != 0) {
                        first2 = AttributedCharSequence.attr(sb, (s & 0x40) != 0 ? "8" : "28", first2);
                    }
                    if ((d & 0x80) != 0) {
                        first2 = AttributedCharSequence.attr(sb, (s & 0x80) != 0 ? "9" : "29", first2);
                    }
                    if (foreground != fg) {
                        first2 = fg >= 0 ? ((rounded = AttributedCharSequence.roundColor(fg, colors)) < 8 ? AttributedCharSequence.attr(sb, "3" + Integer.toString(rounded), first2) : (rounded < 16 ? AttributedCharSequence.attr(sb, "9" + Integer.toString(rounded - 8), first2) : AttributedCharSequence.attr(sb, "38;5;" + Integer.toString(rounded), first2))) : AttributedCharSequence.attr(sb, "39", first2);
                        foreground = fg;
                    }
                    if (background != bg) {
                        first2 = bg >= 0 ? ((rounded = AttributedCharSequence.roundColor(bg, colors)) < 8 ? AttributedCharSequence.attr(sb, "4" + Integer.toString(rounded), first2) : (rounded < 16 ? AttributedCharSequence.attr(sb, "10" + Integer.toString(rounded - 8), first2) : AttributedCharSequence.attr(sb, "48;5;" + Integer.toString(rounded), first2))) : AttributedCharSequence.attr(sb, "49", first2);
                        background = bg;
                    }
                    sb.append("m");
                }
                style = s;
            }
            sb.append(c);
        }
        if (style != 0) {
            sb.append("\u001b[0m");
        }
        return sb.toString();
    }

    public static int roundColor(int col, int max) {
        if (col >= max) {
            int c = COLORS_256[col];
            int r = c >> 16 & 0xFF;
            int g = c >> 8 & 0xFF;
            int b = c >> 0 & 0xFF;
            col = AttributedCharSequence.roundColor(r, g, b, COLORS_256, max);
        }
        return col;
    }

    private static int roundColor(int r, int g, int b, int[] colors, int max) {
        int best_distance = Integer.MAX_VALUE;
        int best_index = Integer.MAX_VALUE;
        for (int idx = 0; idx < max; ++idx) {
            int color = colors[idx];
            int test_r = color >> 16 & 0xFF;
            int test_g = color >> 8 & 0xFF;
            int test_b = color >> 0 & 0xFF;
            int distance = 2 * AttributedCharSequence.sqr(r - test_r) + 4 * AttributedCharSequence.sqr(g - test_g) + 3 * AttributedCharSequence.sqr(b - test_b);
            if (distance > best_distance) continue;
            best_index = idx;
            best_distance = distance;
        }
        return best_index;
    }

    static int sqr(int d) {
        return d * d;
    }

    private static boolean attr(StringBuilder sb, String s, boolean first2) {
        if (!first2) {
            sb.append(";");
        }
        sb.append(s);
        return false;
    }

    public abstract AttributedStyle styleAt(int var1);

    int styleCodeAt(int index2) {
        return this.styleAt(index2).getStyle();
    }

    public boolean isHidden(int index2) {
        return (this.styleCodeAt(index2) & 0x400) != 0;
    }

    @Override
    public abstract AttributedString subSequence(int var1, int var2);

    public AttributedString substring(int start, int end) {
        return this.subSequence(start, end);
    }

    protected abstract char[] buffer();

    protected abstract int offset();

    @Override
    public char charAt(int index2) {
        return this.buffer()[this.offset() + index2];
    }

    public int codePointAt(int index2) {
        return Character.codePointAt(this.buffer(), index2 + this.offset());
    }

    public int columnLength() {
        int cp;
        int cols = 0;
        int len = this.length();
        for (int cur = 0; cur < len; cur += Character.charCount(cp)) {
            cp = this.codePointAt(cur);
            if (this.isHidden(cur)) continue;
            cols += WCWidth.wcwidth(cp);
        }
        return cols;
    }

    public AttributedString columnSubSequence(int start, int stop) {
        int cp;
        int begin = 0;
        int col = 0;
        while (begin < this.length()) {
            int w;
            int cp2 = this.codePointAt(begin);
            int n = w = this.isHidden(begin) ? 0 : WCWidth.wcwidth(cp2);
            if (col + w > start) break;
            ++begin;
            col += w;
        }
        int end = begin;
        while (end < this.length() && (cp = this.codePointAt(end)) != 10) {
            int w;
            int n = w = this.isHidden(end) ? 0 : WCWidth.wcwidth(cp);
            if (col + w > stop) break;
            ++end;
            col += w;
        }
        return this.subSequence(begin, end);
    }

    public List<AttributedString> columnSplitLength(int columns) {
        return this.columnSplitLength(columns, false, true);
    }

    public List<AttributedString> columnSplitLength(int columns, boolean includeNewlines, boolean delayLineWrap) {
        int cur;
        ArrayList<AttributedString> strings2 = new ArrayList<AttributedString>();
        int beg = cur = 0;
        int col = 0;
        while (cur < this.length()) {
            int w;
            int cp = this.codePointAt(cur);
            int n = w = this.isHidden(cur) ? 0 : WCWidth.wcwidth(cp);
            if (cp == 10) {
                strings2.add(this.subSequence(beg, includeNewlines ? cur + 1 : cur));
                beg = cur + 1;
                col = 0;
            } else if ((col += w) > columns) {
                strings2.add(this.subSequence(beg, cur));
                beg = cur;
                col = w;
            }
            cur += Character.charCount(cp);
        }
        strings2.add(this.subSequence(beg, cur));
        return strings2;
    }

    @Override
    public String toString() {
        return new String(this.buffer(), this.offset(), this.length());
    }

    public AttributedString toAttributedString() {
        return this.substring(0, this.length());
    }
}

