/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.google.common.primitives.Ints;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.mq.HgQDeleteCommand;
import org.zmlx.hg4idea.command.mq.HgQRenameCommand;
import org.zmlx.hg4idea.mq.HgMqAdditionalPatchReader;
import org.zmlx.hg4idea.mq.MqPatchDetails;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.MultiReorderedModel;
import org.zmlx.hg4idea.ui.TableRowsTransferHandler;
import org.zmlx.hg4idea.util.HgUtil;

public class HgMqUnAppliedPatchesPanel
extends JPanel
implements DataProvider,
HgUpdater {
    public static final DataKey<HgMqUnAppliedPatchesPanel> MQ_PATCHES = DataKey.create((String)"Mq.Patches");
    private static final String POPUP_ACTION_GROUP = "Mq.Patches.ContextMenu";
    private static final String TOOLBAR_ACTION_GROUP = "Mq.Patches.Toolbar";
    private static final Logger LOG = Logger.getInstance(HgMqUnAppliedPatchesPanel.class);
    private static final String START_EDITING = "startEditing";
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgRepository myRepository;
    @NotNull
    private final MyPatchTable myPatchTable;
    @Nullable
    private final VirtualFile myMqPatchDir;
    private volatile boolean myNeedToUpdateFileContent;
    @Nullable
    private final File mySeriesFile;

    public HgMqUnAppliedPatchesPanel(@NotNull HgRepository repository) {
        if (repository == null) {
            HgMqUnAppliedPatchesPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myRepository = repository;
        this.myProject = this.myRepository.getProject();
        this.myMqPatchDir = this.myRepository.getHgDir().findChild("patches");
        this.mySeriesFile = this.myMqPatchDir != null ? new File(this.myMqPatchDir.getPath(), "series") : null;
        this.myPatchTable = new MyPatchTable(new MyPatchModel(this.myRepository.getUnappliedPatchNames()));
        this.myPatchTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                HgMqUnAppliedPatchesPanel.this.updatePatchSeriesInBackground(null);
                super.focusLost(e);
            }
        });
        this.myPatchTable.setShowColumns(true);
        this.myPatchTable.setFillsViewportHeight(true);
        this.myPatchTable.getEmptyText().setText("Nothing to show");
        this.myPatchTable.getInputMap().put(KeyStroke.getKeyStroke(113, 0), START_EDITING);
        this.myPatchTable.setDragEnabled(true);
        new TableSpeedSearch((JTable)((Object)this.myPatchTable));
        this.myPatchTable.setDropMode(DropMode.INSERT_ROWS);
        this.myPatchTable.setTransferHandler(new TableRowsTransferHandler((JTable)((Object)this.myPatchTable)));
        this.add((Component)this.createToolbar(), "West");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myPatchTable));
        this.add((Component)scrollPane, "Center");
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(HgVcs.STATUS_TOPIC, (Object)this);
    }

    private JComponent createToolbar() {
        MqRefreshAction mqRefreshAction = new MqRefreshAction();
        EmptyAction.setupAction((AnAction)mqRefreshAction, (String)"hg4idea.QRefresh", (JComponent)this);
        MqDeleteAction mqDeleteAction = new MqDeleteAction();
        EmptyAction.setupAction((AnAction)mqDeleteAction, (String)"hg4idea.QDelete", (JComponent)this);
        PopupHandler.installPopupHandler((JComponent)((Object)this.myPatchTable), (String)POPUP_ACTION_GROUP, (String)"ProjectViewPopup");
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)mqRefreshAction);
        toolbarGroup.add(actionManager.getAction("Hg.MQ.Unapplied"));
        toolbarGroup.add((AnAction)mqDeleteAction);
        ActionToolbar toolbar = actionManager.createActionToolbar(TOOLBAR_ACTION_GROUP, (ActionGroup)toolbarGroup, false);
        toolbar.setTargetComponent((JComponent)this);
        return toolbar.getComponent();
    }

    public void updatePatchSeriesInBackground(final @Nullable Runnable runAfterUpdate) {
        final String newContent = this.myNeedToUpdateFileContent ? this.getContentFromModel() : null;
        this.myNeedToUpdateFileContent = false;
        new Task.Backgroundable(this.myProject, "Updating patch series for " + this.myRepository.getPresentableUrl()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (newContent != null) {
                    HgMqUnAppliedPatchesPanel.this.writeSeriesFile(newContent);
                }
                if (runAfterUpdate != null) {
                    runAfterUpdate.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/ui/HgMqUnAppliedPatchesPanel$2", "run"));
            }
        }.queue();
    }

    private void writeSeriesFile(@NotNull String newContent) {
        if (newContent == null) {
            HgMqUnAppliedPatchesPanel.$$$reportNull$$$0(1);
        }
        if (this.mySeriesFile == null || !this.mySeriesFile.exists()) {
            return;
        }
        try {
            FileUtil.writeToFile((File)this.mySeriesFile, (String)newContent);
        }
        catch (IOException e1) {
            LOG.error("Could not modify mq series file", (Throwable)e1);
        }
        this.myRepository.update();
    }

    @NotNull
    private String getContentFromModel() {
        StringBuilder content = new StringBuilder();
        String separator = "\n";
        StringUtil.join(HgUtil.getNamesWithoutHashes(this.myRepository.getMQAppliedPatches()), (String)separator, (StringBuilder)content);
        content.append(separator);
        for (int i = 0; i < this.myPatchTable.getRowCount(); ++i) {
            content.append(this.getPatchName(i)).append(separator);
        }
        String string = content.toString();
        if (string == null) {
            HgMqUnAppliedPatchesPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    private String getPatchName(int i) {
        return this.myPatchTable.getModel().getPatchName(i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HgMqUnAppliedPatchesPanel)) {
            return false;
        }
        HgMqUnAppliedPatchesPanel panel = (HgMqUnAppliedPatchesPanel)o;
        return this.myRepository.equals(panel.myRepository);
    }

    public int hashCode() {
        return this.myRepository.hashCode();
    }

    @Nullable
    private VirtualFile getSelectedPatchFile() {
        if (this.myMqPatchDir == null || this.myPatchTable.getSelectedRowCount() != 1) {
            return null;
        }
        String patchName = this.getPatchName(this.myPatchTable.getSelectedRow());
        return VfsUtil.findFileByIoFile((File)new File(this.myMqPatchDir.getPath(), patchName), (boolean)true);
    }

    @NotNull
    public List<String> getSelectedPatchNames() {
        return this.getPatchNames(this.myPatchTable.getSelectedRows());
    }

    @NotNull
    private List<String> getPatchNames(int[] rows) {
        List list = ContainerUtil.map((Collection)Ints.asList((int[])rows), integer -> this.getPatchName((int)integer));
        if (list == null) {
            HgMqUnAppliedPatchesPanel.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public HgRepository getRepository() {
        HgRepository hgRepository = this.myRepository;
        if (hgRepository == null) {
            HgMqUnAppliedPatchesPanel.$$$reportNull$$$0(4);
        }
        return hgRepository;
    }

    public int getSelectedRowsCount() {
        return this.myPatchTable.getSelectedRowCount();
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        VirtualFile patchVFile;
        if (dataId == null) {
            HgMqUnAppliedPatchesPanel.$$$reportNull$$$0(5);
        }
        if (MQ_PATCHES.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId) && (patchVFile = this.getSelectedPatchFile()) != null) {
            return patchVFile;
        }
        return null;
    }

    @Override
    public void update(Project project, @Nullable VirtualFile root) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project != null && !project.isDisposed()) {
                this.refreshAll();
            }
        });
    }

    private void refreshAll() {
        this.updateModel();
    }

    private void updateModel() {
        MyPatchModel model = this.myPatchTable.getModel();
        model.updatePatches(this.myRepository.getUnappliedPatchNames());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/ui/HgMqUnAppliedPatchesPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/ui/HgMqUnAppliedPatchesPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFromModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSeriesFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyPatchTable
    extends JBTable {
        MyPatchTable(MyPatchModel model) {
            super((TableModel)model);
        }

        public MyPatchModel getModel() {
            return (MyPatchModel)this.dataModel;
        }

        public void editingStopped(ChangeEvent e) {
            int editingRow = this.getEditingRow();
            String oldName = this.getModel().getPatchName(editingRow);
            super.editingStopped(e);
            HgMqUnAppliedPatchesPanel.this.updatePatchSeriesInBackground(() -> HgQRenameCommand.performPatchRename(HgMqUnAppliedPatchesPanel.this.myRepository, oldName, this.getModel().getPatchName(editingRow)));
        }
    }

    private class MyPatchModel
    extends AbstractTableModel
    implements MultiReorderedModel {
        private final MqPatchDetails.MqPatchEnum @NotNull [] myColumnNames;
        @NotNull
        private final Map<String, MqPatchDetails> myPatchesWithDetails;
        @NotNull
        private final List<String> myPatches;

        MyPatchModel(List<String> names) {
            if (names == null) {
                MyPatchModel.$$$reportNull$$$0(0);
            }
            this.myColumnNames = MqPatchDetails.MqPatchEnum.values();
            this.myPatchesWithDetails = new HashMap<String, MqPatchDetails>();
            this.myPatches = new ArrayList<String>(names);
            this.readMqPatchesDetails();
        }

        private void readMqPatchesDetails() {
            for (String name : this.myPatches) {
                File patchFile = HgMqUnAppliedPatchesPanel.this.myMqPatchDir != null ? new File(HgMqUnAppliedPatchesPanel.this.myMqPatchDir.getPath(), name) : null;
                this.myPatchesWithDetails.put(name, HgMqAdditionalPatchReader.readMqPatchInfo(HgMqUnAppliedPatchesPanel.this.myRepository.getRoot(), patchFile));
            }
        }

        @Override
        public int getColumnCount() {
            return this.myColumnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.myColumnNames[col].toString();
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            return this.myPatches.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String name = this.getPatchName(rowIndex);
            if (columnIndex == 0) {
                return name;
            }
            MqPatchDetails patchDetails = this.myPatchesWithDetails.get(name);
            String mapDetail = patchDetails != null ? patchDetails.getPresentationDataFor(this.myColumnNames[columnIndex]) : "";
            return mapDetail != null ? mapDetail : "";
        }

        @NotNull
        private String getPatchName(int rowIndex) {
            String string = this.myPatches.get(rowIndex);
            if (string == null) {
                MyPatchModel.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String newPatchName = (String)aValue;
            this.myPatchesWithDetails.put(newPatchName, this.myPatchesWithDetails.remove(this.myPatches.get(rowIndex)));
            this.myPatches.set(rowIndex, newPatchName);
        }

        public void updatePatches(List<String> newNames) {
            this.myPatches.clear();
            this.myPatches.addAll(newNames);
            this.myPatchesWithDetails.clear();
            this.readMqPatchesDetails();
            this.fireTableDataChanged();
        }

        @Override
        public boolean canMoveRows() {
            return true;
        }

        @Override
        public int[] moveRows(int[] rowsIndexes, int destination) {
            List names = HgMqUnAppliedPatchesPanel.this.getPatchNames(rowsIndexes);
            this.myPatches.removeAll(names);
            int[] selection = new int[rowsIndexes.length];
            for (int i = 0; i < rowsIndexes.length; ++i) {
                selection[i] = destination;
                this.myPatches.add(destination++, (String)names.get(i));
            }
            HgMqUnAppliedPatchesPanel.this.myNeedToUpdateFileContent = true;
            this.fireTableDataChanged();
            return selection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/ui/HgMqUnAppliedPatchesPanel$MyPatchModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/ui/HgMqUnAppliedPatchesPanel$MyPatchModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatchName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MqRefreshAction
    extends DumbAwareAction {
        private MqRefreshAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MqRefreshAction.$$$reportNull$$$0(0);
            }
            HgMqUnAppliedPatchesPanel.this.refreshAll();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/zmlx/hg4idea/ui/HgMqUnAppliedPatchesPanel$MqRefreshAction", "actionPerformed"));
        }
    }

    private class MqDeleteAction
    extends DumbAwareAction {
        private MqDeleteAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<String> names;
            if (e == null) {
                MqDeleteAction.$$$reportNull$$$0(0);
            }
            if ((names = HgMqUnAppliedPatchesPanel.this.getSelectedPatchNames()).isEmpty()) {
                return;
            }
            if (Messages.showOkCancelDialog((Project)HgMqUnAppliedPatchesPanel.this.myRepository.getProject(), (String)String.format("You are going to delete selected %s. Would you like to continue?", StringUtil.pluralize((String)"patch", (int)names.size())), (String)"Delete Confirmation", (Icon)Messages.getWarningIcon()) == 0) {
                Runnable deleteTask = () -> {
                    ProgressManager.getInstance().getProgressIndicator().setText("Deleting patches...");
                    new HgQDeleteCommand(HgMqUnAppliedPatchesPanel.this.myRepository).executeInCurrentThread(names);
                };
                HgMqUnAppliedPatchesPanel.this.updatePatchSeriesInBackground(deleteTask);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MqDeleteAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(HgMqUnAppliedPatchesPanel.this.getSelectedRowsCount() != 0 && !HgMqUnAppliedPatchesPanel.this.myPatchTable.isEditing());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "org/zmlx/hg4idea/ui/HgMqUnAppliedPatchesPanel$MqDeleteAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

