/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HgReferenceValidator
implements InputValidatorEx {
    protected String myErrorText;
    private static final HgReferenceValidator INSTANCE = new HgReferenceValidator();
    private static final Pattern DIGITS_ILLEGAL = Pattern.compile("[0-9]*");
    private static final Pattern ILLEGAL = Pattern.compile("[:]");

    public static HgReferenceValidator getInstance() {
        return INSTANCE;
    }

    protected HgReferenceValidator() {
    }

    public boolean checkInput(String inputString) {
        if (StringUtil.isEmptyOrSpaces((String)inputString)) {
            return false;
        }
        if (this.containsIllegalSymbols(inputString)) {
            return false;
        }
        return !this.isReservedWord(inputString) && !this.onlyDigits(inputString) && !this.hasConflictsWithAnotherNames(inputString);
    }

    protected boolean containsIllegalSymbols(@Nullable String inputString) {
        if (inputString != null && ILLEGAL.matcher(inputString).find()) {
            this.myErrorText = "Name could not contain colons";
            return true;
        }
        return false;
    }

    private boolean onlyDigits(@Nullable String inputString) {
        if (inputString != null && DIGITS_ILLEGAL.matcher(inputString).matches()) {
            this.myErrorText = "Invalid name for hg reference";
            return true;
        }
        return false;
    }

    public boolean canClose(@Nullable String name) {
        return this.checkInput(name);
    }

    private boolean isReservedWord(@Nullable String name) {
        this.myErrorText = "tip".equals(name) ? String.format("The name '%s' is reserved.", name) : null;
        return this.myErrorText != null;
    }

    protected boolean hasConflictsWithAnotherNames(@Nullable String name) {
        return false;
    }

    @Nullable
    public String getErrorText(@Nullable String inputString) {
        return this.myErrorText;
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String branchName) {
        if (branchName == null) {
            HgReferenceValidator.$$$reportNull$$$0(0);
        }
        if (this.onlyDigits(branchName)) {
            String string = branchName + "_";
            if (string == null) {
                HgReferenceValidator.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = branchName.replaceAll(ILLEGAL.pattern(), "_").replaceAll("\"", "");
        if (string == null) {
            HgReferenceValidator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/util/HgReferenceValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/util/HgReferenceValidator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpBranchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpBranchName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

