/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.google.common.collect.Maps;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.project.ProjectKt;
import com.intellij.spellchecker.BaseSuggestionProvider;
import com.intellij.spellchecker.BundledDictionaryProvider;
import com.intellij.spellchecker.FileLoader;
import com.intellij.spellchecker.StreamLoader;
import com.intellij.spellchecker.dictionary.CustomDictionaryProvider;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.ProjectDictionary;
import com.intellij.spellchecker.dictionary.RuntimeDictionaryProvider;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.engine.SpellCheckerFactory;
import com.intellij.spellchecker.engine.SuggestionProvider;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import com.intellij.spellchecker.state.CachedDictionaryState;
import com.intellij.spellchecker.state.DictionaryStateListener;
import com.intellij.spellchecker.state.ProjectDictionaryState;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import com.intellij.spellchecker.util.Strings;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellCheckerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SpellCheckerManager.class);
    private static final int MAX_METRICS = 1;
    public static final String PROJECT = "project";
    public static final String APP = "application";
    private final Project project;
    private SpellCheckerEngine spellChecker;
    private ProjectDictionary myProjectDictionary;
    private EditableDictionary myAppDictionary;
    private final SuggestionProvider suggestionProvider = new BaseSuggestionProvider(this);
    private final SpellCheckerSettings settings;
    private final VirtualFileListener myCustomDictFileListener;
    private final String myProjectDictinaryPath;
    private final String myAppDictionaryPath;
    public static final String PROJECT_DICTIONARY_PATH = "dictionaries" + File.separator + System.getProperty("user.name").replace('.', '_') + ".xml";
    public static final String CACHED_DICTIONARY_FILE = "cachedDictionary.xml";
    private final EventDispatcher<DictionaryStateListener> myUserDictionaryListenerEventDispatcher = EventDispatcher.create(DictionaryStateListener.class);

    public static SpellCheckerManager getInstance(Project project) {
        return (SpellCheckerManager)ServiceManager.getService((Project)project, SpellCheckerManager.class);
    }

    public SpellCheckerManager(Project project) {
        this.project = project;
        this.settings = SpellCheckerSettings.getInstance(project);
        this.fullConfigurationReload();
        Disposer.register((Disposable)project, (Disposable)this);
        VirtualFile projectStoreDir = project.getBaseDir() != null ? ProjectKt.getProjectStoreDirectory((VirtualFile)project.getBaseDir()) : null;
        this.myProjectDictinaryPath = projectStoreDir != null ? projectStoreDir.getPath() + File.separator + PROJECT_DICTIONARY_PATH : "";
        this.myAppDictionaryPath = PathManager.getOptionsPath() + File.separator + CACHED_DICTIONARY_FILE;
        this.myCustomDictFileListener = new CustomDictFileListener(this.settings);
        LocalFileSystem.getInstance().addVirtualFileListener(this.myCustomDictFileListener);
        BundledDictionaryProvider.EP_NAME.addExtensionPointListener(this::fillEngineDictionary, (Disposable)this);
        RuntimeDictionaryProvider.EP_NAME.addExtensionPointListener(this::fillEngineDictionary, (Disposable)this);
        CustomDictionaryProvider.EP_NAME.addExtensionPointListener(this::fillEngineDictionary, (Disposable)this);
    }

    public SpellCheckerEngine getSpellChecker() {
        return this.spellChecker;
    }

    public void fullConfigurationReload() {
        this.spellChecker = SpellCheckerFactory.create(this.project);
        this.fillEngineDictionary();
    }

    public void updateBundledDictionaries(List<String> removedDictionaries) {
        boolean dictionaryIsLoad;
        boolean dictionaryShouldBeLoad;
        for (Iterator<String> provider : BundledDictionaryProvider.EP_NAME.getExtensionList()) {
            for (String string : provider.getBundledDictionaries()) {
                dictionaryShouldBeLoad = this.settings == null || !this.settings.getBundledDisabledDictionariesPaths().contains(string);
                dictionaryIsLoad = this.spellChecker.isDictionaryLoad(string);
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    this.spellChecker.removeDictionary(string);
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                this.loadBundledDictionary((BundledDictionaryProvider)((Object)provider), string);
            }
        }
        for (Iterator<String> provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            for (Dictionary dictionary : provider.getDictionaries()) {
                dictionaryShouldBeLoad = this.settings == null || !this.settings.getRuntimeDisabledDictionariesNames().contains(dictionary.getName());
                dictionaryIsLoad = this.spellChecker.isDictionaryLoad(dictionary.getName());
                if (dictionaryIsLoad && !dictionaryShouldBeLoad) {
                    this.spellChecker.removeDictionary(dictionary.getName());
                    continue;
                }
                if (dictionaryIsLoad || !dictionaryShouldBeLoad) continue;
                this.loadRuntimeDictionary(dictionary);
            }
        }
        if (this.settings != null && this.settings.getCustomDictionariesPaths() != null) {
            Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
            for (String dictionary : this.settings.getCustomDictionariesPaths()) {
                boolean dictionaryShouldBeLoad2 = !disabledDictionaries.contains(dictionary);
                boolean dictionaryIsLoad2 = this.spellChecker.isDictionaryLoad(dictionary);
                if (dictionaryIsLoad2 && !dictionaryShouldBeLoad2) {
                    this.spellChecker.removeDictionary(dictionary);
                    continue;
                }
                if (dictionaryIsLoad2 || !dictionaryShouldBeLoad2) continue;
                this.loadDictionary(dictionary);
            }
        }
        if (!ContainerUtil.isEmpty(removedDictionaries)) {
            for (String name : removedDictionaries) {
                this.spellChecker.removeDictionary(name);
            }
        }
        SpellCheckerManager.restartInspections();
    }

    public Project getProject() {
        return this.project;
    }

    @NotNull
    public Set<String> getUserDictionaryWords() {
        Set set = ContainerUtil.union(this.myProjectDictionary.getEditableWords(), this.myAppDictionary.getEditableWords());
        if (set == null) {
            SpellCheckerManager.$$$reportNull$$$0(0);
        }
        return set;
    }

    private void fillEngineDictionary() {
        this.spellChecker.reset();
        this.loadBundledDictionaries();
        this.loadRuntimeDictionaries();
        this.loadCustomDictionaries();
        this.initUserDictionaries();
    }

    private void loadBundledDictionaries() {
        for (BundledDictionaryProvider provider : BundledDictionaryProvider.EP_NAME.getExtensionList()) {
            for (String dictionary : provider.getBundledDictionaries()) {
                if (this.settings != null && this.settings.getBundledDisabledDictionariesPaths().contains(dictionary)) continue;
                this.loadBundledDictionary(provider, dictionary);
            }
        }
    }

    private void loadRuntimeDictionaries() {
        for (RuntimeDictionaryProvider provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            for (Dictionary dictionary : provider.getDictionaries()) {
                if (this.settings != null && this.settings.getRuntimeDisabledDictionariesNames().contains(dictionary.getName())) continue;
                this.loadRuntimeDictionary(dictionary);
            }
        }
    }

    private void loadCustomDictionaries() {
        if (this.settings != null && this.settings.getCustomDictionariesPaths() != null) {
            Set<String> disabledDictionaries = this.settings.getDisabledDictionariesPaths();
            for (String dictionary : this.settings.getCustomDictionariesPaths()) {
                if (disabledDictionaries.contains(dictionary)) continue;
                this.loadDictionary(dictionary);
            }
        }
    }

    private void initUserDictionaries() {
        CachedDictionaryState cachedDictionaryState = CachedDictionaryState.getInstance();
        cachedDictionaryState.addCachedDictListener(dict -> SpellCheckerManager.restartInspections());
        if (cachedDictionaryState.getDictionary() == null) {
            cachedDictionaryState.setDictionary(new UserDictionary("cached"));
        }
        this.myAppDictionary = cachedDictionaryState.getDictionary();
        this.spellChecker.addModifiableDictionary(this.myAppDictionary);
        ProjectDictionaryState dictionaryState = (ProjectDictionaryState)ServiceManager.getService((Project)this.project, ProjectDictionaryState.class);
        dictionaryState.addProjectDictListener(dict -> SpellCheckerManager.restartInspections());
        this.myProjectDictionary = dictionaryState.getProjectDictionary();
        this.myProjectDictionary.setActiveName(System.getProperty("user.name"));
        this.spellChecker.addModifiableDictionary(this.myProjectDictionary);
    }

    private void loadDictionary(@NotNull String path) {
        CustomDictionaryProvider dictionaryProvider;
        if (path == null) {
            SpellCheckerManager.$$$reportNull$$$0(1);
        }
        if ((dictionaryProvider = SpellCheckerManager.findApplicable(path)) != null) {
            Dictionary dictionary = dictionaryProvider.get(path);
            if (dictionary != null) {
                this.spellChecker.addDictionary(dictionary);
            }
        } else {
            this.spellChecker.loadDictionary(new FileLoader(path));
        }
    }

    private void loadBundledDictionary(@NotNull BundledDictionaryProvider provider, @NotNull String dictionary) {
        Class<?> loaderClass;
        InputStream stream;
        if (provider == null) {
            SpellCheckerManager.$$$reportNull$$$0(2);
        }
        if (dictionary == null) {
            SpellCheckerManager.$$$reportNull$$$0(3);
        }
        if ((stream = (loaderClass = provider.getClass()).getResourceAsStream(dictionary)) != null) {
            this.spellChecker.loadDictionary(new StreamLoader(stream, dictionary));
        } else {
            LOG.warn("Couldn't load dictionary '" + dictionary + "' with loader '" + loaderClass + "'");
        }
    }

    private void loadRuntimeDictionary(@NotNull Dictionary dictionary) {
        if (dictionary == null) {
            SpellCheckerManager.$$$reportNull$$$0(4);
        }
        this.spellChecker.addDictionary(dictionary);
    }

    public boolean hasProblem(@NotNull String word) {
        if (word == null) {
            SpellCheckerManager.$$$reportNull$$$0(5);
        }
        return !this.spellChecker.isCorrect(word);
    }

    public void acceptWordAsCorrect(@NotNull String word, Project project) {
        if (word == null) {
            SpellCheckerManager.$$$reportNull$$$0(6);
        }
        this.acceptWordAsCorrect(word, null, project, DictionaryLevel.PROJECT);
    }

    public void acceptWordAsCorrect(@NotNull String word, @Nullable VirtualFile file, @NotNull Project project, @NotNull DictionaryLevel dictionaryLevel) {
        EditableDictionary dictionary;
        if (word == null) {
            SpellCheckerManager.$$$reportNull$$$0(7);
        }
        if (project == null) {
            SpellCheckerManager.$$$reportNull$$$0(8);
        }
        if (dictionaryLevel == null) {
            SpellCheckerManager.$$$reportNull$$$0(9);
        }
        if (DictionaryLevel.NOT_SPECIFIED == dictionaryLevel) {
            return;
        }
        final String transformed = this.spellChecker.getTransformation().transform(word);
        EditableDictionary editableDictionary = dictionary = DictionaryLevel.PROJECT == dictionaryLevel ? this.myProjectDictionary : this.myAppDictionary;
        if (transformed != null) {
            if (file != null) {
                WriteCommandAction.writeCommandAction((Project)project).run(() -> UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{file}){

                    public void undo() {
                        SpellCheckerManager.this.removeWordFromDictionary(dictionary, transformed);
                    }

                    public void redo() {
                        SpellCheckerManager.this.addWordToDictionary(dictionary, transformed);
                    }
                }));
            }
            this.addWordToDictionary(dictionary, transformed);
        }
    }

    private void addWordToDictionary(@NotNull EditableDictionary dictionary, @NotNull String word) {
        if (dictionary == null) {
            SpellCheckerManager.$$$reportNull$$$0(10);
        }
        if (word == null) {
            SpellCheckerManager.$$$reportNull$$$0(11);
        }
        dictionary.addToDictionary(word);
        this.fireDictionaryChanged(dictionary);
    }

    private void removeWordFromDictionary(@NotNull EditableDictionary dictionary, String transformed) {
        if (dictionary == null) {
            SpellCheckerManager.$$$reportNull$$$0(12);
        }
        dictionary.removeFromDictionary(transformed);
        this.fireDictionaryChanged(dictionary);
    }

    private void fireDictionaryChanged(@NotNull EditableDictionary dictionary) {
        if (dictionary == null) {
            SpellCheckerManager.$$$reportNull$$$0(13);
        }
        ((DictionaryStateListener)this.myUserDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(dictionary);
        SpellCheckerManager.restartInspections();
        SaveAndSyncHandler.getInstance().scheduleProjectSave(this.project);
    }

    public void updateUserDictionary(@NotNull Collection<String> words) {
        if (words == null) {
            SpellCheckerManager.$$$reportNull$$$0(14);
        }
        Collection addedToProjectWords = ContainerUtil.subtract(words, this.getUserDictionaryWords());
        addedToProjectWords.forEach(this.myProjectDictionary::addToDictionary);
        Collection deletedFromProjectWords = ContainerUtil.subtract(this.myProjectDictionary.getEditableWords(), words);
        deletedFromProjectWords.forEach(this.myProjectDictionary::removeFromDictionary);
        if (addedToProjectWords.size() + deletedFromProjectWords.size() > 0) {
            ((DictionaryStateListener)this.myUserDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(this.myProjectDictionary);
        }
        Collection deletedFromApplicationWords = ContainerUtil.subtract(this.myAppDictionary.getEditableWords(), words);
        deletedFromApplicationWords.forEach(this.myAppDictionary::removeFromDictionary);
        if (deletedFromApplicationWords.size() > 0) {
            ((DictionaryStateListener)this.myUserDictionaryListenerEventDispatcher.getMulticaster()).dictChanged(this.myAppDictionary);
        }
        SpellCheckerManager.restartInspections();
    }

    @NotNull
    public static List<String> getBundledDictionaries() {
        ArrayList<String> dictionaries = new ArrayList<String>();
        for (BundledDictionaryProvider provider : BundledDictionaryProvider.EP_NAME.getExtensionList()) {
            ContainerUtil.addAll(dictionaries, (Object[])provider.getBundledDictionaries());
        }
        ArrayList<String> arrayList = dictionaries;
        if (arrayList == null) {
            SpellCheckerManager.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static List<Dictionary> getRuntimeDictionaries() {
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>();
        for (RuntimeDictionaryProvider provider : RuntimeDictionaryProvider.EP_NAME.getExtensionList()) {
            ContainerUtil.addAll(dictionaries, (Object[])provider.getDictionaries());
        }
        ArrayList<Dictionary> arrayList = dictionaries;
        if (arrayList == null) {
            SpellCheckerManager.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getSuggestions(@NotNull String text) {
        if (text == null) {
            SpellCheckerManager.$$$reportNull$$$0(17);
        }
        List<String> list = this.suggestionProvider.getSuggestions(text);
        if (list == null) {
            SpellCheckerManager.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    protected List<String> getRawSuggestions(@NotNull String word) {
        ArrayList<String> suggestions;
        if (word == null) {
            SpellCheckerManager.$$$reportNull$$$0(19);
        }
        if (!this.spellChecker.isCorrect(word) && !(suggestions = this.spellChecker.getSuggestions(word, this.settings.getCorrectionsLimit(), 1)).isEmpty()) {
            if (Strings.isCapitalized(word)) {
                Strings.capitalize(suggestions);
            } else if (Strings.isUpperCase(word)) {
                Strings.upperCase(suggestions);
            }
            LinkedHashSet<String> unique = new LinkedHashSet<String>(suggestions);
            ArrayList<String> arrayList = unique.size() < suggestions.size() ? new ArrayList<String>(unique) : suggestions;
            if (arrayList == null) {
                SpellCheckerManager.$$$reportNull$$$0(20);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            SpellCheckerManager.$$$reportNull$$$0(21);
        }
        return list;
    }

    public static void restartInspections() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Project[] projects;
            for (Project project1 : projects = ProjectManager.getInstance().getOpenProjects()) {
                if (!project1.isInitialized() || !project1.isOpen() || project1.isDefault()) continue;
                DaemonCodeAnalyzer.getInstance((Project)project1).restart();
            }
        });
    }

    @Nullable
    private static CustomDictionaryProvider findApplicable(@NotNull String path) {
        if (path == null) {
            SpellCheckerManager.$$$reportNull$$$0(22);
        }
        return CustomDictionaryProvider.EP_NAME.getExtensionList().stream().filter(dictionaryProvider -> dictionaryProvider.isApplicable(path)).findAny().orElse(null);
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myCustomDictFileListener);
    }

    @NotNull
    public String getProjectDictionaryPath() {
        String string = this.myProjectDictinaryPath;
        if (string == null) {
            SpellCheckerManager.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String getAppDictionaryPath() {
        String string = this.myAppDictionaryPath;
        if (string == null) {
            SpellCheckerManager.$$$reportNull$$$0(24);
        }
        return string;
    }

    public void openDictionaryInEditor(@NotNull String dictPath) {
        VirtualFile file;
        if (dictPath == null) {
            SpellCheckerManager.$$$reportNull$$$0(25);
        }
        VirtualFile virtualFile = file = StringUtil.isEmpty((String)dictPath) ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(dictPath);
        if (file == null) {
            String title = SpellCheckerBundle.message("dictionary.not.found.title", new Object[0]);
            String message = SpellCheckerBundle.message("dictionary.not.found", dictPath);
            Messages.showMessageDialog((Project)this.project, (String)message, (String)title, (Icon)Messages.getWarningIcon());
            return;
        }
        FileEditorManager fileManager = FileEditorManager.getInstance((Project)this.project);
        if (fileManager != null) {
            fileManager.openFile(file, true);
        }
    }

    public void addUserDictionaryChangedListener(DictionaryStateListener listener, Disposable parentDisposable) {
        this.myUserDictionaryListenerEventDispatcher.addListener((EventListener)listener);
        Disposer.register((Disposable)parentDisposable, () -> this.myUserDictionaryListenerEventDispatcher.removeListener((EventListener)listener));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/SpellCheckerManager";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionary";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROJECT;
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionaryLevel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDictionaryWords";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/SpellCheckerManager";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledDictionaries";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeDictionaries";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawSuggestions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDictionaryPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppDictionaryPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadDictionary";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadBundledDictionary";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadRuntimeDictionary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasProblem";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptWordAsCorrect";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addWordToDictionary";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeWordFromDictionary";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fireDictionaryChanged";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateUserDictionary";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRawSuggestions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findApplicable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "openDictionaryInEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CustomDictFileListener
    implements VirtualFileListener {
        private final SpellCheckerSettings mySettings;

        CustomDictFileListener(SpellCheckerSettings settings) {
            if (settings == null) {
                CustomDictFileListener.$$$reportNull$$$0(0);
            }
            this.mySettings = settings;
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                CustomDictFileListener.$$$reportNull$$$0(1);
            }
            this.removeCustomDictionaries(event.getFile().getPath());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                CustomDictFileListener.$$$reportNull$$$0(2);
            }
            this.loadCustomDictionaries(event.getFile());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            String oldPath;
            if (event == null) {
                CustomDictFileListener.$$$reportNull$$$0(3);
            }
            if (!this.affectCustomDicts(oldPath = event.getOldParent().getPath() + File.separator + event.getFileName())) {
                this.loadCustomDictionaries(event.getFile());
            } else {
                String newPath = event.getNewParent().getPath() + File.separator + event.getFileName();
                if (!this.affectCustomDicts(newPath)) {
                    this.removeCustomDictionaries(oldPath);
                }
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                CustomDictFileListener.$$$reportNull$$$0(4);
            }
            String path = FileUtilRt.toSystemDependentName((String)event.getFile().getPath());
            if (!SpellCheckerManager.this.spellChecker.isDictionaryLoad(path) || this.mySettings.getDisabledDictionariesPaths().contains(path)) {
                return;
            }
            SpellCheckerManager.this.spellChecker.removeDictionary(path);
            SpellCheckerManager.this.loadDictionary(path);
            SpellCheckerManager.restartInspections();
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file;
            if (event == null) {
                CustomDictFileListener.$$$reportNull$$$0(5);
            }
            if ((file = event.getFile()).isDirectory()) {
                return;
            }
            if ("name".equals(event.getPropertyName())) {
                String oldName = (String)event.getOldValue();
                if (!this.isDic(oldName)) {
                    this.loadCustomDictionaries(file);
                } else {
                    String newName = (String)event.getNewValue();
                    if (!this.isDic(newName)) {
                        this.removeCustomDictionaries(file.getParent().getPath() + File.separator + oldName);
                    }
                }
            }
        }

        private void removeCustomDictionaries(@NotNull String path) {
            if (path == null) {
                CustomDictFileListener.$$$reportNull$$$0(6);
            }
            String systemDependentPath = FileUtilRt.toSystemDependentName((String)path);
            if (this.affectCustomDicts(path)) {
                SpellCheckerManager.this.spellChecker.removeDictionariesRecursively(systemDependentPath);
                this.mySettings.getCustomDictionariesPaths().removeIf(dict -> FileUtil.isAncestor((String)systemDependentPath, (String)dict, (boolean)false));
                this.mySettings.getDisabledDictionariesPaths().removeIf(dict -> FileUtil.isAncestor((String)systemDependentPath, (String)dict, (boolean)false));
                SpellCheckerManager.restartInspections();
            }
        }

        private void loadCustomDictionaries(@NotNull VirtualFile file) {
            String path;
            if (file == null) {
                CustomDictFileListener.$$$reportNull$$$0(7);
            }
            if (!this.affectCustomDicts(path = FileUtilRt.toSystemDependentName((String)file.getPath()))) {
                return;
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    boolean isDirectory = file.isDirectory();
                    String path = file.getPath();
                    if (!isDirectory && CustomDictFileListener.this.mySettings.getCustomDictionariesPaths().contains(path)) {
                        SpellCheckerManager.this.loadDictionary(path);
                        SpellCheckerManager.restartInspections();
                    }
                    return isDirectory;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spellchecker/SpellCheckerManager$CustomDictFileListener$1", "visitFile"));
                }
            });
        }

        private boolean isDic(String path) {
            return FileUtilRt.extensionEquals((String)path, (String)"dic");
        }

        private boolean affectCustomDicts(@NotNull String path) {
            if (path == null) {
                CustomDictFileListener.$$$reportNull$$$0(8);
            }
            return this.mySettings.getCustomDictionariesPaths().stream().anyMatch(dicPath -> FileUtil.isAncestor((String)path, (String)dicPath, (boolean)false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/spellchecker/SpellCheckerManager$CustomDictFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeCustomDictionaries";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadCustomDictionaries";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "affectCustomDicts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum DictionaryLevel {
        APP("application-level"),
        PROJECT("project-level"),
        NOT_SPECIFIED("not specified");

        private final String myName;
        private static final Map<String, DictionaryLevel> DICTIONARY_LEVELS;

        private DictionaryLevel(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }

        @NotNull
        public static DictionaryLevel getLevelByName(@NotNull String name) {
            if (name == null) {
                DictionaryLevel.$$$reportNull$$$0(0);
            }
            DictionaryLevel dictionaryLevel = DICTIONARY_LEVELS.getOrDefault(name, NOT_SPECIFIED);
            if (dictionaryLevel == null) {
                DictionaryLevel.$$$reportNull$$$0(1);
            }
            return dictionaryLevel;
        }

        static {
            DICTIONARY_LEVELS = Maps.uniqueIndex(EnumSet.allOf(DictionaryLevel.class), DictionaryLevel::getName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spellchecker/SpellCheckerManager$DictionaryLevel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spellchecker/SpellCheckerManager$DictionaryLevel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLevelByName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLevelByName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

