/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importWizard;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.importWizard.EclipseImportBuilder;
import org.jetbrains.idea.eclipse.importWizard.EclipseProjectWizardContext;
import org.jetbrains.idea.eclipse.importWizard.Options;

public class EclipseWorkspaceRootStep
extends ProjectImportWizardStep {
    private static final String _ECLIPSE_PROJECT_DIR = "eclipse.project.dir";
    private JPanel myPanel;
    private JCheckBox myLinkCheckBox;
    private JRadioButton rbModulesColocated;
    private JRadioButton rbModulesDedicated;
    private JTextField myTestSourcesMask;
    private TextFieldWithBrowseButton myDirComponent;
    private TextFieldWithBrowseButton myWorkspaceRootComponent;
    private ProjectFormatPanel myProjectFormatPanel;
    private JPanel myFormatPanel;
    private EclipseImportBuilder.Parameters myParameters;

    public EclipseWorkspaceRootStep(final WizardContext context) {
        super(context);
        this.$$$setupUI$$$();
        this.myWorkspaceRootComponent.addBrowseFolderListener(EclipseBundle.message("eclipse.import.title.select.workspace", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myDirComponent.addBrowseFolderListener(EclipseBundle.message("eclipse.import.title.module.dir", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean dedicated = EclipseWorkspaceRootStep.this.rbModulesDedicated.isSelected();
                EclipseWorkspaceRootStep.this.myDirComponent.setEnabled(dedicated);
                if (dedicated && EclipseWorkspaceRootStep.this.myDirComponent.getText().length() == 0) {
                    String remoteStorage = Options.getProjectStorageDir(context.getProject());
                    EclipseWorkspaceRootStep.this.myDirComponent.setText(remoteStorage != null ? remoteStorage : FileUtil.toSystemDependentName((String)EclipseWorkspaceRootStep.this.myWorkspaceRootComponent.getText()));
                }
            }
        };
        this.rbModulesColocated.addActionListener(listener);
        this.rbModulesDedicated.addActionListener(listener);
        if (context.isCreatingNewProject()) {
            this.myProjectFormatPanel = new ProjectFormatPanel();
            this.myFormatPanel.add((Component)this.myProjectFormatPanel.getPanel(), "West");
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public boolean validate() throws ConfigurationException {
        return super.validate() && this.getContext().setRootDirectory(this.myWorkspaceRootComponent.getText());
    }

    public String getName() {
        return "Eclipse Projects Root";
    }

    public void updateDataModel() {
        String projectFilesDir = this.myDirComponent.isEnabled() ? this.myDirComponent.getText() : null;
        this.suggestProjectNameAndPath(projectFilesDir, this.myWorkspaceRootComponent.getText());
        this.getParameters().converterOptions.commonModulesDirectory = projectFilesDir;
        this.getParameters().converterOptions.testPattern = EclipseWorkspaceRootStep.wildcardToRegexp(this.myTestSourcesMask.getText());
        this.getParameters().linkConverted = this.myLinkCheckBox.isSelected();
        this.getParameters().projectsToConvert = null;
        if (this.getWizardContext().isCreatingNewProject()) {
            this.myProjectFormatPanel.updateData(this.getWizardContext());
        }
        PropertiesComponent.getInstance().setValue(_ECLIPSE_PROJECT_DIR, this.myWorkspaceRootComponent.getText());
        Options.saveProjectStorageDir(this.getParameters().converterOptions.commonModulesDirectory);
    }

    public void updateStep() {
        String path = this.getBuilder().getFileToImport();
        if (path == null) {
            path = this.getWizardContext().isProjectFileDirectorySet() || !PropertiesComponent.getInstance().isValueSet(_ECLIPSE_PROJECT_DIR) ? this.getWizardContext().getProjectFileDirectory() : PropertiesComponent.getInstance().getValue(_ECLIPSE_PROJECT_DIR);
        }
        this.myWorkspaceRootComponent.setText(path.replace('/', File.separatorChar));
        this.myWorkspaceRootComponent.getTextField().selectAll();
        String storageDir = Options.getProjectStorageDir(this.getWizardContext().getProject());
        boolean colocated = StringUtil.isEmptyOrSpaces((String)this.getParameters().converterOptions.commonModulesDirectory) && StringUtil.isEmptyOrSpaces((String)storageDir);
        this.rbModulesColocated.setSelected(colocated);
        this.rbModulesDedicated.setSelected(!colocated);
        this.myDirComponent.setEnabled(!colocated);
        if (StringUtil.isEmptyOrSpaces((String)this.getParameters().converterOptions.commonModulesDirectory)) {
            this.myDirComponent.setText(storageDir);
        } else {
            this.myDirComponent.setText(this.getParameters().converterOptions.commonModulesDirectory);
        }
        this.myTestSourcesMask.setText(EclipseWorkspaceRootStep.regexpToWildcard(this.getParameters().converterOptions.testPattern));
        this.myLinkCheckBox.setSelected(this.getParameters().linkConverted);
    }

    private static String wildcardToRegexp(String string) {
        return string == null ? null : string.replaceAll("\\.", "\\.").replaceAll("\\*", ".*").replaceAll("\\?", ".").replaceAll(",\\s*", "|");
    }

    private static String regexpToWildcard(String string) {
        return string == null ? null : string.replaceAll("\\.\\*", "*").replaceAll("\\.", "?").replaceAll("\\\\\\?", ".").replaceAll("\\|", ", ");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myWorkspaceRootComponent.getTextField();
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.import.eclipse.page1";
    }

    public EclipseProjectWizardContext getContext() {
        return (EclipseProjectWizardContext)this.getBuilder();
    }

    public EclipseImportBuilder.Parameters getParameters() {
        if (this.myParameters == null) {
            this.myParameters = ((EclipseImportBuilder)this.getBuilder()).getParameters();
        }
        return this.myParameters;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        this.myLinkCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Link created IntelliJ IDEA modules to Eclipse project files");
        jCheckBox.setMnemonic('L');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"IntelliJ IDEA project and module files location", (int)0, (int)0, null, null));
        this.rbModulesColocated = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Create module files near .classpath files");
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.rbModulesDedicated = jRadioButton = new JRadioButton();
        jRadioButton.setText("Keep project and module files in");
        jPanel3.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDirComponent = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myFormatPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myWorkspaceRootComponent = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/EclipseBundle", EclipseWorkspaceRootStep.class).getString("eclipse.import.label.select.workspace"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(4, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Detect test sources (comma-separated path masks, '*' and '?' wildcards allowed):");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(7);
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestSourcesMask = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

