/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer;

import com.intellij.openapi.options.SchemeImportException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.importer.EclipseXmlProfileElements;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EclipseXmlProfileReader
extends DefaultHandler
implements EclipseXmlProfileElements {
    private final OptionHandler myOptionHandler;

    protected EclipseXmlProfileReader(OptionHandler optionHandler) {
        this.myOptionHandler = optionHandler;
    }

    protected void readSettings(InputStream input) throws SchemeImportException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        try {
            SAXParser parser = spf.newSAXParser();
            parser.parse(input, (DefaultHandler)this);
        }
        catch (Exception e) {
            if (e.getCause() instanceof NonEclipseXmlFileException) {
                throw new SchemeImportException("The input file is not a valid Eclipse XML profile.");
            }
            throw new SchemeImportException((Throwable)e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("profile".equals(qName)) {
            this.myOptionHandler.handleName(attributes.getValue("name"));
        } else if ("setting".equals(qName)) {
            String key = attributes.getValue("id");
            String value = attributes.getValue("value");
            if (key != null && value != null) {
                try {
                    this.myOptionHandler.handleOption(key, value);
                }
                catch (SchemeImportException e) {
                    throw new SAXException((Exception)((Object)e));
                }
            }
        } else if (!"profiles".equals(qName)) {
            throw new SAXException(new NonEclipseXmlFileException("Unknown XML element: " + qName));
        }
    }

    static interface OptionHandler {
        public void handleOption(@NotNull String var1, @NotNull String var2) throws SchemeImportException;

        public void handleName(String var1);
    }

    private static class NonEclipseXmlFileException
    extends Exception {
        NonEclipseXmlFileException(String message) {
            super(message);
        }
    }
}

