/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ConfigurationUtil;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestsPattern
extends TestPackage {
    public TestsPattern(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    protected TestClassFilter getClassFilter(JUnitConfiguration.Data data) throws CantRunException {
        return TestClassFilter.create(this.getSourceScope(), ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule(), data.getPatternPresentation());
    }

    @Override
    @NotNull
    protected String getPackageName(JUnitConfiguration.Data data) {
        return "";
    }

    @Override
    protected boolean filterOutputByDirectoryForJunit5(Set<Location<?>> classNames) {
        return super.filterOutputByDirectoryForJunit5(classNames) && classNames.isEmpty();
    }

    @Override
    protected boolean requiresSmartMode() {
        return true;
    }

    @Override
    protected void searchTests5(Module module, TestClassFilter classFilter, Set<Location<?>> classes) {
        this.searchTests(module, classFilter, classes, true);
    }

    @Override
    protected void searchTests(Module module, TestClassFilter classFilter, Set<Location<?>> classes) {
        this.searchTests(module, classFilter, classes, false);
    }

    private void searchTests(Module module, TestClassFilter classFilter, Set<Location<?>> classes, boolean junit5) {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        Project project = this.getConfiguration().getProject();
        for (String className : data.getPatterns()) {
            PsiClass psiClass = (PsiClass)ReadAction.compute(() -> this.getTestClass(project, className));
            if (psiClass != null) {
                if (!((Boolean)ReadAction.compute(() -> JUnitUtil.isTestClass((PsiClass)psiClass))).booleanValue()) continue;
                if (className.contains(",")) {
                    String methodName = StringUtil.getShortName((String)className, (char)',');
                    PsiMethod[] methods = psiClass.findMethodsByName(methodName, true);
                    if (methods.length > 0) {
                        classes.add((Location<?>)MethodLocation.elementInClass((PsiMethod)methods[0], (PsiClass)psiClass));
                        continue;
                    }
                    classes.add(PsiLocation.fromPsiElement((PsiElement)psiClass));
                    continue;
                }
                classes.add(PsiLocation.fromPsiElement((PsiElement)psiClass));
                continue;
            }
            classes.clear();
            if (!junit5) {
                LinkedHashSet psiClasses = new LinkedHashSet();
                ConfigurationUtil.findAllTestClasses(classFilter, module, psiClasses);
                psiClasses.stream().map(PsiLocation::fromPsiElement).forEach(classes::add);
            }
            return;
        }
    }

    @Override
    protected String getFilters(Set<Location<?>> foundClasses, String packageName) {
        return foundClasses.isEmpty() ? this.getConfiguration().getPersistentData().getPatternPresentation() : "";
    }

    private PsiClass getTestClass(Project project, String className) {
        SourceScope sourceScope = this.getSourceScope();
        GlobalSearchScope searchScope = sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.allScope((Project)project);
        return JavaExecutionUtil.findMainClass((Project)project, (String)(className.contains(",") ? StringUtil.getPackageName((String)className, (char)',') : className), (GlobalSearchScope)searchScope);
    }

    @Override
    protected boolean configureByModule(Module module) {
        return module != null;
    }

    @Override
    public String suggestActionName() {
        return null;
    }

    @Override
    @Nullable
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        RefactoringElementListenerComposite composite = new RefactoringElementListenerComposite();
        JUnitConfiguration.Data data = configuration.getPersistentData();
        final Set<String> patterns = data.getPatterns();
        for (String pattern : patterns) {
            RefactoringElementListener listeners;
            final PsiClass testClass = this.getTestClass(configuration.getProject(), pattern.trim());
            if (testClass == null || !testClass.equals(element) || (listeners = RefactoringListeners.getListeners((PsiClass)testClass, (RefactoringListeners.Accessor)new RefactoringListeners.Accessor<PsiClass>(){
                private String myOldName;
                {
                    this.myOldName = testClass.getQualifiedName();
                }

                public void setName(String qualifiedName) {
                    LinkedHashSet<String> replaced = new LinkedHashSet<String>();
                    for (String currentPattern : patterns) {
                        if (this.myOldName.equals(currentPattern)) {
                            replaced.add(qualifiedName);
                            this.myOldName = qualifiedName;
                            continue;
                        }
                        replaced.add(currentPattern);
                    }
                    patterns.clear();
                    patterns.addAll(replaced);
                }

                public PsiClass getPsiElement() {
                    return testClass;
                }

                public void setPsiElement(PsiClass psiElement) {
                    if (psiElement == testClass) {
                        this.setName(psiElement.getQualifiedName());
                    }
                }
            })) == null) continue;
            composite.addListener(listeners);
        }
        return composite;
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return false;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.getConfiguration());
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)this.getConfiguration().getProject(), (Module)((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule());
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        Set<String> patterns = data.getPatterns();
        if (patterns.isEmpty()) {
            throw new RuntimeConfigurationWarning(JUnitBundle.message("no.pattern.error.message", new Object[0]));
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.getConfiguration().getProject());
        for (String pattern : patterns) {
            String className = pattern.contains(",") ? StringUtil.getPackageName((String)pattern, (char)',') : pattern;
            PsiClass psiClass = JavaExecutionUtil.findMainClass((Project)this.getConfiguration().getProject(), (String)className, (GlobalSearchScope)searchScope);
            if (psiClass != null && !JUnitUtil.isTestClass((PsiClass)psiClass)) {
                throw new RuntimeConfigurationWarning(JUnitBundle.message("class.not.test.error.message", className));
            }
            if (psiClass != null || pattern.contains("*")) continue;
            throw new RuntimeConfigurationWarning(JavaBundle.message((String)"class.not.found.error.message", (Object[])new Object[]{className}));
        }
    }
}

