/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Scopes {
    private Scopes() {
    }

    public static Type getType(@Nullable SearchScope scope) {
        if (scope instanceof ProjectScopeImpl || scope == null) {
            return Type.PROJECT;
        }
        if (scope instanceof ModuleWithDependenciesScope) {
            return Type.MODULE;
        }
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            return Type.DIRECTORY;
        }
        return Type.NAMED;
    }

    public static String getDescriptor(SearchScope scope) {
        if (scope instanceof ProjectScopeImpl || scope == null) {
            return "";
        }
        if (scope instanceof ModuleWithDependenciesScope) {
            return ((ModuleWithDependenciesScope)scope).getModule().getName();
        }
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)scope;
            String url = directoryScope.getDirectory().getPresentableUrl();
            return directoryScope.isWithSubdirectories() ? "*" + url : url;
        }
        return scope.getDisplayName();
    }

    public static SearchScope createScope(@NotNull Project project, @NotNull String descriptor, @NotNull Type scopeType) {
        if (project == null) {
            Scopes.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            Scopes.$$$reportNull$$$0(1);
        }
        if (scopeType == null) {
            Scopes.$$$reportNull$$$0(2);
        }
        if (scopeType == Type.PROJECT) {
            return GlobalSearchScope.projectScope((Project)project);
        }
        if (scopeType == Type.MODULE) {
            Module module = ModuleManager.getInstance((Project)project).findModuleByName(descriptor);
            if (module != null) {
                return GlobalSearchScope.moduleScope((Module)module);
            }
        } else {
            if (scopeType == Type.DIRECTORY) {
                boolean recursive = StringUtil.startsWithChar((CharSequence)descriptor, (char)'*');
                if (recursive) {
                    descriptor = descriptor.substring(1);
                }
                String path = FileUtil.toSystemIndependentName((String)descriptor.substring(1));
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
                if (virtualFile == null) {
                    return null;
                }
                return new GlobalSearchScopesCore.DirectoryScope(project, virtualFile, recursive);
            }
            if (scopeType == Type.NAMED) {
                return Scopes.findScopeByName(project, descriptor);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    public static SearchScope findScopeByName(@NotNull Project project, @NotNull String scopeName) {
        if (project == null) {
            Scopes.$$$reportNull$$$0(3);
        }
        if (scopeName == null) {
            Scopes.$$$reportNull$$$0(4);
        }
        List predefinedScopes = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, null, true, false, true, true, true);
        for (SearchScope predefinedScope : predefinedScopes) {
            if (!predefinedScope.getDisplayName().equals(scopeName)) continue;
            return predefinedScope;
        }
        for (NamedScope scope : ChangeListsScopesProvider.getInstance((Project)project).getFilteredScopes()) {
            if (!scope.getName().equals(scopeName)) continue;
            return GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope);
        }
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            for (NamedScope scope : holder.getEditableScopes()) {
                if (!scope.getName().equals(scopeName)) continue;
                return GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/Scopes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findScopeByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Type {
        PROJECT,
        MODULE,
        DIRECTORY,
        NAMED;

    }
}

