/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.XmlMatchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.ListNodeIterator;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.xml.util.XmlUtil;

public class XmlMatchingVisitor
extends XmlElementVisitor {
    private final GlobalMatchingVisitor myMatchingVisitor;

    public XmlMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitXmlAttribute(XmlAttribute attribute) {
        XmlAttribute another = (XmlAttribute)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.getMatchContext().pushResult();
        XmlElement name = attribute.getNameElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)name);
        try {
            if (!this.myMatchingVisitor.setResult(isTypedVar || this.myMatchingVisitor.matchText((PsiElement)name, (PsiElement)another.getNameElement()))) {
                return;
            }
            XmlAttributeValue valueElement = attribute.getValueElement();
            this.myMatchingVisitor.setResult(valueElement == null || this.myMatchingVisitor.matchOptionally((PsiElement)valueElement, (PsiElement)another.getValueElement()));
        }
        finally {
            this.myMatchingVisitor.scopeMatch((PsiElement)name, isTypedVar, (PsiElement)another);
        }
    }

    public void visitXmlAttributeValue(XmlAttributeValue value) {
        XmlAttributeValue another = (XmlAttributeValue)this.myMatchingVisitor.getElement();
        String text = value.getValue();
        if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text)) {
            SubstitutionHandler handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(text);
            String text2 = another.getText();
            int offset = StringUtil.isQuotedString((String)text2) ? 1 : 0;
            this.myMatchingVisitor.setResult(handler.handle((PsiElement)another, offset, text2.length() - offset, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(text, another.getValue()));
        }
    }

    public void visitXmlTag(XmlTag tag) {
        XmlTagChild[] children2;
        ListNodeIterator matchNodes;
        SsrFilteringNodeIterator matchNodes2;
        Object patternNodes;
        XmlToken name;
        XmlTag another = (XmlTag)this.myMatchingVisitor.getElement();
        CompiledPattern pattern = this.myMatchingVisitor.getMatchContext().getPattern();
        boolean isTypedVar = pattern.isTypedVar((PsiElement)(name = XmlUtil.getTokenOfType((PsiElement)tag, (IElementType)XmlTokenType.XML_NAME)));
        if (!this.myMatchingVisitor.setResult((isTypedVar || this.myMatchingVisitor.matchText(tag.getName(), another.getName())) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])tag.getAttributes(), (PsiElement[])another.getAttributes()))) {
            return;
        }
        XmlTagChild[] children1 = tag.getValue().getChildren();
        if (children1.length != 0 && (children1.length == 1 && pattern.isTypedVar((PsiElement)children1[0]) ? (patternNodes = new SsrFilteringNodeIterator((NodeIterator)new ArrayBackedNodeIterator((PsiElement[])tag.getValue().getChildren()))).current() != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((NodeIterator)patternNodes, (NodeIterator)(matchNodes2 = new SsrFilteringNodeIterator((NodeIterator)new ArrayBackedNodeIterator((PsiElement[])another.getValue().getChildren()))))) : (children1.length != 1 || !XmlMatchUtil.isWhiteSpace((PsiElement)children1[0])) && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((NodeIterator)(patternNodes = new ListNodeIterator(XmlMatchUtil.getElementsToMatch(children1))), matchNodes = new ListNodeIterator(XmlMatchUtil.getElementsToMatch(children2 = another.getValue().getChildren())))))) {
            return;
        }
        if (isTypedVar) {
            SubstitutionHandler handler = (SubstitutionHandler)pattern.getHandler((PsiElement)name);
            this.myMatchingVisitor.setResult(handler.handle((PsiElement)XmlUtil.getTokenOfType((PsiElement)another, (IElementType)XmlTokenType.XML_NAME), this.myMatchingVisitor.getMatchContext()));
        }
    }

    public void visitXmlText(XmlText text) {
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)text) ? this.myMatchingVisitor.handleTypedElement((PsiElement)text, this.myMatchingVisitor.getElement()) : this.myMatchingVisitor.matchSequentially(text.getFirstChild(), this.myMatchingVisitor.getElement().getFirstChild()));
    }

    public void visitXmlToken(XmlToken token) {
        if (token.getTokenType() == XmlTokenType.XML_DATA_CHARACTERS) {
            String text = token.getText();
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text) ? this.myMatchingVisitor.handleTypedElement((PsiElement)token, this.myMatchingVisitor.getElement()) : this.myMatchingVisitor.matchText(text, this.myMatchingVisitor.getElement().getText()));
        }
    }

    public void visitXmlComment(XmlComment comment) {
        super.visitXmlComment(comment);
        PsiElement element = this.myMatchingVisitor.getElement();
        if (!(element instanceof XmlComment)) {
            return;
        }
        XmlComment other = (XmlComment)element;
        XmlToken text = XmlUtil.getTokenOfType((PsiElement)comment, (IElementType)XmlTokenType.XML_COMMENT_CHARACTERS);
        assert (text != null);
        CompiledPattern pattern = this.myMatchingVisitor.getMatchContext().getPattern();
        boolean typedVar = pattern.isTypedVar((PsiElement)text);
        if (typedVar) {
            SubstitutionHandler handler = (SubstitutionHandler)pattern.getHandler((PsiElement)text);
            this.myMatchingVisitor.setResult(handler.handle((PsiElement)XmlUtil.getTokenOfType((PsiElement)other, (IElementType)XmlTokenType.XML_COMMENT_CHARACTERS), this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(StructuralSearchUtil.normalize(text.getText()), StructuralSearchUtil.normalize(other.getCommentText())));
        }
    }
}

