/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.DeleteNodesAction;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.TestModeOptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.AndPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ContainsPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ReferencePredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.impl.matcher.predicates.WithinPredicate;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternCompiler {
    private static final Key<LastResult> SSR_LAST_COMPILED_PATTERN = new Key("SSR_LAST_COMPILED_PATTERN");
    private static String ourLastSearchPlan;

    public static CompiledPattern compilePattern(Project project, MatchOptions options, boolean checkForErrors, boolean optimizeScope) throws MalformedPatternException, NoMatchFoundException {
        LastResult lastResult;
        if (!(checkForErrors || (lastResult = (LastResult)SSR_LAST_COMPILED_PATTERN.get((UserDataHolder)project)) == null || !options.equals(lastResult.options) || options.getScope() instanceof GlobalSearchScope && options.getScope() != lastResult.options.getScope())) {
            return lastResult.pattern;
        }
        return (CompiledPattern)ReadAction.compute(() -> PatternCompiler.doCompilePattern(project, options, checkForErrors, optimizeScope));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static CompiledPattern doCompilePattern(Project project, MatchOptions options, boolean checkForErrors, boolean optimizeScope) throws MalformedPatternException, NoMatchFoundException {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options.getFileType());
        assert (profile != null) : "no profile found for " + options.getFileType().getDescription();
        CompiledPattern result = profile.createCompiledPattern();
        String[] prefixes = result.getTypedVarPrefixes();
        assert (prefixes.length > 0);
        CompileContext context = new CompileContext(result, options, project);
        List<PsiElement> elements = PatternCompiler.compileByAllPrefixes(project, options, result, context, prefixes, checkForErrors);
        CompiledPattern pattern = context.getPattern();
        try {
            PatternCompiler.checkForUnknownVariables(pattern, elements);
            pattern.setNodes(elements);
            project.putUserData(SSR_LAST_COMPILED_PATTERN, (Object)new LastResult(options.copy(), result));
        }
        catch (MalformedPatternException e) {
            project.putUserData(SSR_LAST_COMPILED_PATTERN, (Object)new LastResult(options.copy(), null));
            throw e;
        }
        if (checkForErrors) {
            profile.checkSearchPattern(pattern);
        }
        if (optimizeScope) {
            PatternCompiler.optimizeScope(options, checkForErrors, context, result);
        }
        CompiledPattern compiledPattern = result;
        CompiledPattern compiledPattern2 = compiledPattern;
        if (compiledPattern2 == null) {
            PatternCompiler.$$$reportNull$$$0(0);
        }
        return compiledPattern2;
        finally {
            context.clear();
        }
    }

    private static void optimizeScope(MatchOptions options, boolean checkForErrors, CompileContext context, CompiledPattern result) throws NoMatchFoundException {
        OptimizingSearchHelper searchHelper = context.getSearchHelper();
        if (searchHelper.doOptimizing() && searchHelper.isScannedSomething()) {
            Set<VirtualFile> filesToScan = searchHelper.getFilesSetToScan();
            GlobalSearchScope scope = (GlobalSearchScope)options.getScope();
            assert (scope != null);
            if (checkForErrors && filesToScan.isEmpty()) {
                throw new NoMatchFoundException(SSRBundle.message("ssr.will.not.find.anything", scope.getDisplayName()));
            }
            result.setScope((SearchScope)(scope.isSearchInLibraries() ? GlobalSearchScope.filesWithLibrariesScope((Project)context.getProject(), filesToScan) : GlobalSearchScope.filesWithoutLibrariesScope((Project)context.getProject(), filesToScan)));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourLastSearchPlan = ((TestModeOptimizingSearchHelper)searchHelper).getSearchPlan();
        }
    }

    private static void checkForUnknownVariables(final CompiledPattern pattern, List<? extends PsiElement> elements) throws MalformedPatternException {
        for (PsiElement psiElement : elements) {
            pattern.putVariableNode("__context__", psiElement);
            psiElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element.getUserData(CompiledPattern.HANDLER_KEY) != null) {
                        return;
                    }
                    super.visitElement(element);
                    if (!(element instanceof LeafElement)) {
                        return;
                    }
                    String text = element.getText();
                    if (!pattern.isTypedVar(text)) {
                        for (String prefix : pattern.getTypedVarPrefixes()) {
                            if (!text.contains(prefix)) continue;
                            throw new MalformedPatternException();
                        }
                        return;
                    }
                    MatchingHandler handler = pattern.getHandler(pattern.getTypedVarString(element));
                    if (handler == null) {
                        throw new MalformedPatternException();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$1", "visitElement"));
                }
            });
            psiElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.collectNode(element, element.getUserData(CompiledPattern.HANDLER_KEY));
                    super.visitElement(element);
                    if (element instanceof LeafElement) {
                        this.collectNode(element, pattern.getHandler(pattern.getTypedVarString(element)));
                    }
                }

                private void collectNode(PsiElement element, Object handler) {
                    if (handler instanceof DelegatingHandler) {
                        handler = ((DelegatingHandler)handler).getDelegate();
                    }
                    if (handler instanceof SubstitutionHandler) {
                        pattern.putVariableNode(((SubstitutionHandler)handler).getName(), element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$2", "visitElement"));
                }
            });
        }
    }

    public static String getLastSearchPlan() {
        return ourLastSearchPlan;
    }

    @NotNull
    private static List<PsiElement> compileByAllPrefixes(Project project, MatchOptions options, CompiledPattern pattern, CompileContext context, String @NotNull [] applicablePrefixes, boolean checkForErrors) throws MalformedPatternException {
        if (applicablePrefixes == null) {
            PatternCompiler.$$$reportNull$$$0(1);
        }
        if (applicablePrefixes.length == 0) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PatternCompiler.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<PsiElement> elements = PatternCompiler.doCompile(project, options, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context, checkForErrors);
        if (elements.isEmpty()) {
            List<PsiElement> list = elements;
            if (list == null) {
                PatternCompiler.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiFile file = elements.get(0).getContainingFile();
        if (file == null) {
            List<PsiElement> list = elements;
            if (list == null) {
                PatternCompiler.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiElement last = elements.get(elements.size() - 1);
        Pattern[] patterns = new Pattern[applicablePrefixes.length];
        for (int i = 0; i < applicablePrefixes.length; ++i) {
            patterns[i] = Pattern.compile(StructuralSearchUtil.shieldRegExpMetaChars(applicablePrefixes[i]) + "\\w+\\b");
        }
        int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file, patterns);
        int patternEndOffset = last.getTextRange().getEndOffset();
        if (elements.isEmpty() || PatternCompiler.checkErrorElements((PsiElement)file, patternEndOffset, patternEndOffset, varEndOffsets, true) != Boolean.TRUE) {
            List<PsiElement> list = elements;
            if (list == null) {
                PatternCompiler.$$$reportNull$$$0(5);
            }
            return list;
        }
        int varCount = varEndOffsets.length;
        String[] prefixSequence = new String[varCount];
        for (int i = 0; i < varCount; ++i) {
            prefixSequence[i] = applicablePrefixes[0];
        }
        List<PsiElement> finalElements = PatternCompiler.compileByPrefixes(project, options, pattern, context, applicablePrefixes, patterns, prefixSequence, 0, checkForErrors);
        List<PsiElement> list = finalElements != null ? finalElements : PatternCompiler.doCompile(project, options, pattern, new ConstantPrefixProvider(applicablePrefixes[0]), context, checkForErrors);
        if (list == null) {
            PatternCompiler.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static List<PsiElement> compileByPrefixes(Project project, MatchOptions options, CompiledPattern pattern, CompileContext context, String[] applicablePrefixes, Pattern[] substitutionPatterns, String[] prefixSequence, int index, boolean checkForErrors) throws MalformedPatternException {
        if (index >= prefixSequence.length) {
            List<PsiElement> elements = PatternCompiler.doCompile(project, options, pattern, new ArrayPrefixProvider(prefixSequence), context, checkForErrors);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiElement parent = elements.get(0).getParent();
            PsiElement last = elements.get(elements.size() - 1);
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(parent.getContainingFile(), substitutionPatterns);
            int patternEndOffset = last.getTextRange().getEndOffset();
            return PatternCompiler.checkErrorElements(parent, patternEndOffset, patternEndOffset, varEndOffsets, false) != Boolean.TRUE ? elements : null;
        }
        String[] alternativeVariant = null;
        String[] stringArray = applicablePrefixes;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            List<PsiElement> finalElements;
            int patternEndOffset;
            String applicablePrefix;
            prefixSequence[index] = applicablePrefix = stringArray[i];
            List<PsiElement> elements = PatternCompiler.doCompile(project, options, pattern, new ArrayPrefixProvider(prefixSequence), context, checkForErrors);
            if (elements.isEmpty()) {
                return elements;
            }
            PsiFile file = elements.get(0).getContainingFile();
            if (file == null) {
                return elements;
            }
            int[] varEndOffsets = PatternCompiler.findAllTypedVarOffsets(file, substitutionPatterns);
            int offset = varEndOffsets[index];
            Boolean result = PatternCompiler.checkErrorElements((PsiElement)file, offset, patternEndOffset = elements.get(elements.size() - 1).getTextRange().getEndOffset(), varEndOffsets, false);
            if (result == Boolean.TRUE || result != Boolean.FALSE && (result != null || alternativeVariant != null) || (finalElements = PatternCompiler.compileByPrefixes(project, options, pattern, context, applicablePrefixes, substitutionPatterns, prefixSequence, index + 1, checkForErrors)) == null) continue;
            if (result == Boolean.FALSE) {
                return finalElements;
            }
            alternativeVariant = new String[prefixSequence.length];
            System.arraycopy(prefixSequence, 0, alternativeVariant, 0, prefixSequence.length);
        }
        return alternativeVariant != null ? PatternCompiler.compileByPrefixes(project, options, pattern, context, applicablePrefixes, substitutionPatterns, alternativeVariant, index + 1, checkForErrors) : null;
    }

    private static int @NotNull [] findAllTypedVarOffsets(PsiFile file, final Pattern[] substitutionPatterns) {
        final TIntHashSet result = new TIntHashSet();
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                if (element instanceof LeafElement) {
                    String text = element.getText();
                    for (Pattern pattern : substitutionPatterns) {
                        Matcher matcher = pattern.matcher(text);
                        while (matcher.find()) {
                            result.add(element.getTextRange().getStartOffset() + matcher.end());
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$3", "visitElement"));
            }
        });
        int[] resultArray = result.toArray();
        Arrays.sort(resultArray);
        if (resultArray == null) {
            PatternCompiler.$$$reportNull$$$0(7);
        }
        return resultArray;
    }

    @Nullable
    private static Boolean checkErrorElements(PsiElement element, final int offset, final int patternEndOffset, int[] varEndOffsets, final boolean strict) {
        final TIntArrayList errorOffsets = new TIntArrayList();
        final boolean[] containsErrorTail = new boolean[]{false};
        final TIntHashSet varEndOffsetsSet = new TIntHashSet(varEndOffsets);
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.visitErrorElement(element);
                int startOffset = element.getTextRange().getStartOffset();
                if ((strict || !varEndOffsetsSet.contains(startOffset)) && startOffset != patternEndOffset) {
                    errorOffsets.add(startOffset);
                }
                if (startOffset == offset) {
                    containsErrorTail[0] = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$4", "visitErrorElement"));
            }
        });
        for (int i = 0; i < errorOffsets.size(); ++i) {
            int errorOffset = errorOffsets.get(i);
            if (errorOffset > offset) continue;
            return true;
        }
        return containsErrorTail[0] ? null : Boolean.valueOf(false);
    }

    private static List<PsiElement> doCompile(Project project, MatchOptions options, CompiledPattern result, PrefixProvider prefixProvider, CompileContext context, boolean checkForErrors) throws MalformedPatternException {
        GlobalCompilingVisitor compilingVisitor;
        SmartList elements;
        block28: {
            PsiElement[] patternElements;
            result.clearHandlers();
            StringBuilder buf = new StringBuilder();
            Template template = TemplateManager.getInstance((Project)project).createTemplate("", "", options.getSearchPattern());
            int segmentsCount = template.getSegmentsCount();
            String text = template.getTemplateText();
            int prevOffset = 0;
            THashSet variableNames = new THashSet();
            for (int i = 0; i < segmentsCount; ++i) {
                int offset = template.getSegmentOffset(i);
                String name = template.getSegmentName(i);
                String prefix = prefixProvider.getPrefix(i);
                if (prefix == null) {
                    if (checkForErrors) {
                        throw new MalformedPatternException();
                    }
                    return Collections.emptyList();
                }
                PsiElement[] compiledName = prefix + name;
                buf.append(text, prevOffset, offset).append((String)compiledName);
                int repeated = !variableNames.add(name) ? 1 : 0;
                SubstitutionHandler existing = (SubstitutionHandler)result.getHandler((String)compiledName);
                if (existing != null) {
                    existing.setRepeatedVar(repeated != 0);
                } else {
                    MatchPredicate predicate;
                    SubstitutionHandler handler;
                    MatchVariableConstraint constraint;
                    block27: {
                        constraint = options.getVariableConstraint(name);
                        if (constraint == null) {
                            constraint = options.addNewVariableConstraint(name);
                        }
                        handler = result.createSubstitutionHandler(name, (String)compiledName, constraint.isPartOfSearchResults(), constraint.getMinCount(), constraint.getMaxCount(), constraint.isGreedy());
                        handler.setRepeatedVar(repeated != 0);
                        if (constraint.isWithinHierarchy()) {
                            handler.setSubtype(true);
                        }
                        if (constraint.isStrictlyWithinHierarchy()) {
                            handler.setStrictSubtype(true);
                        }
                        if (!StringUtil.isEmptyOrSpaces((String)constraint.getRegExp())) {
                            predicate = new RegExpPredicate(constraint.getRegExp(), options.isCaseSensitiveMatch(), name, constraint.isWholeWordsOnly(), constraint.isPartOfSearchResults());
                            if (constraint.isInvertRegExp()) {
                                predicate = new NotPredicate(predicate);
                            }
                            PatternCompiler.addPredicate(handler, predicate);
                        }
                        if (!StringUtil.isEmptyOrSpaces((String)constraint.getReferenceConstraint())) {
                            try {
                                predicate = new ReferencePredicate(constraint.getReferenceConstraint(), options.getFileType(), project);
                                if (constraint.isInvertReference()) {
                                    predicate = new NotPredicate(predicate);
                                }
                                PatternCompiler.addPredicate(handler, predicate);
                            }
                            catch (MalformedPatternException e) {
                                if (!checkForErrors) break block27;
                                throw e;
                            }
                        }
                    }
                    PatternCompiler.addExtensionPredicates(options, constraint, handler);
                    PatternCompiler.addScriptConstraint(project, name, constraint, handler, (Set<String>)variableNames, options, checkForErrors);
                    if (!StringUtil.isEmptyOrSpaces((String)constraint.getContainsConstraint())) {
                        predicate = new ContainsPredicate(name, constraint.getContainsConstraint());
                        if (constraint.isInvertContainsConstraint()) {
                            predicate = new NotPredicate(predicate);
                        }
                        PatternCompiler.addPredicate(handler, predicate);
                    }
                    if (!StringUtil.isEmptyOrSpaces((String)constraint.getWithinConstraint())) assert (false);
                }
                prevOffset = offset;
            }
            MatchVariableConstraint constraint = options.getVariableConstraint("__context__");
            if (constraint != null) {
                SubstitutionHandler handler = result.createSubstitutionHandler("__context__", "__context__", constraint.isPartOfSearchResults(), constraint.getMinCount(), constraint.getMaxCount(), constraint.isGreedy());
                if (!StringUtil.isEmptyOrSpaces((String)constraint.getWithinConstraint())) {
                    MatchPredicate predicate = new WithinPredicate(constraint.getWithinConstraint(), options.getFileType(), project);
                    if (constraint.isInvertWithinConstraint()) {
                        predicate = new NotPredicate(predicate);
                    }
                    PatternCompiler.addPredicate(handler, predicate);
                }
                PatternCompiler.addExtensionPredicates(options, constraint, handler);
                PatternCompiler.addScriptConstraint(project, "__context__", constraint, handler, (Set<String>)variableNames, options, checkForErrors);
            }
            buf.append(text.substring(prevOffset));
            try {
                PatternContextInfo contextInfo = new PatternContextInfo(PatternTreeContext.Block, options.getPatternContext(), constraint != null ? constraint.getContextConstraint() : null);
                patternElements = MatcherImplUtil.createTreeFromText(buf.toString(), contextInfo, options.getFileType(), options.getDialect(), project, false);
                if (patternElements.length == 0 && checkForErrors) {
                    throw new MalformedPatternException();
                }
            }
            catch (IncorrectOperationException e) {
                if (checkForErrors) {
                    throw new MalformedPatternException(e.getMessage());
                }
                return Collections.emptyList();
            }
            NodeFilter filter = LexicalNodesFilter.getInstance();
            elements = new SmartList();
            for (PsiElement element : patternElements) {
                if (filter.accepts(element)) continue;
                elements.add(element);
            }
            compilingVisitor = new GlobalCompilingVisitor();
            try {
                compilingVisitor.compile(elements.toArray(PsiElement.EMPTY_ARRAY), context);
            }
            catch (MalformedPatternException e) {
                if (!checkForErrors) break block28;
                throw e;
            }
        }
        new DeleteNodesAction(compilingVisitor.getLexicalNodes()).run();
        return elements;
    }

    private static void addExtensionPredicates(MatchOptions options, MatchVariableConstraint constraint, SubstitutionHandler handler) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options.getFileType());
        assert (profile != null);
        for (MatchPredicate matchPredicate : profile.getCustomPredicates(constraint, handler.getName(), options)) {
            PatternCompiler.addPredicate(handler, matchPredicate);
        }
    }

    private static void addScriptConstraint(Project project, String name, MatchVariableConstraint constraint, SubstitutionHandler handler, Set<String> variableNames, MatchOptions matchOptions, boolean checkForErrors) throws MalformedPatternException {
        if (constraint.getScriptCodeConstraint() != null && constraint.getScriptCodeConstraint().length() > 2) {
            String problem;
            String script = StringUtil.unquoteString((String)constraint.getScriptCodeConstraint());
            if (checkForErrors && (problem = ScriptSupport.checkValidScript(script, matchOptions)) != null) {
                throw new MalformedPatternException("Script constraint for " + constraint.getName() + " has problem " + problem);
            }
            PatternCompiler.addPredicate(handler, new ScriptPredicate(project, name, script, variableNames, matchOptions));
        }
    }

    private static void addPredicate(SubstitutionHandler handler, @NotNull MatchPredicate predicate) {
        if (predicate == null) {
            PatternCompiler.$$$reportNull$$$0(8);
        }
        handler.setPredicate(handler.getPredicate() == null ? predicate : new AndPredicate(handler.getPredicate(), predicate));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicablePrefixes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompilePattern";
                break;
            }
            case 1: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "compileByAllPrefixes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTypedVarOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compileByAllPrefixes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPredicate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArrayPrefixProvider
    implements PrefixProvider {
        private final String[] myPrefixes;

        ArrayPrefixProvider(String @NotNull [] prefixes) {
            if (prefixes == null) {
                ArrayPrefixProvider.$$$reportNull$$$0(0);
            }
            this.myPrefixes = prefixes;
        }

        @Override
        public String getPrefix(int varIndex) {
            if (varIndex >= this.myPrefixes.length) {
                return null;
            }
            return this.myPrefixes[varIndex];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$ArrayPrefixProvider", "<init>"));
        }
    }

    private static class ConstantPrefixProvider
    implements PrefixProvider {
        private final String myPrefix;

        ConstantPrefixProvider(@NotNull String prefix) {
            if (prefix == null) {
                ConstantPrefixProvider.$$$reportNull$$$0(0);
            }
            this.myPrefix = prefix;
        }

        @Override
        @NotNull
        public String getPrefix(int varIndex) {
            String string = this.myPrefix;
            if (string == null) {
                ConstantPrefixProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$ConstantPrefixProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/PatternCompiler$ConstantPrefixProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface PrefixProvider {
        public String getPrefix(int var1);
    }

    private static class LastResult {
        public final MatchOptions options;
        public final CompiledPattern pattern;

        private LastResult(MatchOptions options, CompiledPattern pattern) {
            this.options = options;
            this.pattern = pattern;
        }
    }
}

