/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ReplacementBuilder {
    private final String replacement;
    private final MultiMap<String, ParameterInfo> parameterizations = MultiMap.createLinked();
    private final Map<String, ScriptSupport> replacementVarsMap = new HashMap<String, ScriptSupport>();
    private final ReplaceOptions options;
    private final Project myProject;

    ReplacementBuilder(Project project, ReplaceOptions options) {
        this.myProject = project;
        this.options = options;
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "", options.getReplacement());
        this.replacement = template.getTemplateText();
        int prevOffset = 0;
        for (int i = 0; i < template.getSegmentsCount(); ++i) {
            int pos;
            String name;
            int offset = template.getSegmentOffset(i);
            ParameterInfo info = new ParameterInfo(name, offset, options.getVariableDefinition(name = template.getSegmentName(i)) != null);
            for (pos = offset - 1; pos >= prevOffset && pos < this.replacement.length() && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos)); --pos) {
            }
            if (pos >= 0) {
                if (this.replacement.charAt(pos) == ',') {
                    info.setHasCommaBefore(true);
                }
                while (pos > prevOffset && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos - 1))) {
                    --pos;
                }
                info.setBeforeDelimiterPos(pos);
            }
            for (pos = offset; pos < this.replacement.length() && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos)); ++pos) {
            }
            if (pos < this.replacement.length()) {
                char ch = this.replacement.charAt(pos);
                if (ch == ';') {
                    info.setStatementContext(true);
                } else if (ch == ',' || ch == ')') {
                    info.setArgumentContext(true);
                    info.setHasCommaAfter(ch == ',');
                }
            }
            info.setAfterDelimiterPos(pos);
            prevOffset = offset;
            this.parameterizations.putValue((Object)name, (Object)info);
        }
        LanguageFileType fileType = options.getMatchOptions().getFileType();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
        if (profile != null) {
            try {
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(options.getReplacement(), new PatternContextInfo(PatternTreeContext.Block, options.getMatchOptions().getPatternContext()), fileType, options.getMatchOptions().getDialect(), project, false);
                if (elements.length > 0) {
                    PsiElement patternNode = elements[0].getParent();
                    patternNode.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(@NotNull PsiElement element) {
                            String text;
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (StructuralSearchUtil.isTypedVariable(text = element.getText())) {
                                Collection<ParameterInfo> infos = ReplacementBuilder.this.findParameterization(Replacer.stripTypedVariableDecoration(text));
                                for (ParameterInfo info : infos) {
                                    if (info.getElement() != null) continue;
                                    info.setElement(element);
                                    return;
                                }
                            }
                            super.visitElement(element);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/plugin/replace/impl/ReplacementBuilder$1", "visitElement"));
                        }
                    });
                    profile.provideAdditionalReplaceOptions(patternNode, options, this);
                }
            }
            catch (IncorrectOperationException e) {
                throw new MalformedPatternException(e.getMessage());
            }
        }
    }

    String process(MatchResult match, ReplacementInfo replacementInfo, LanguageFileType type) {
        if (this.parameterizations.isEmpty()) {
            return this.replacement;
        }
        StringBuilder result = new StringBuilder(this.replacement);
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(type);
        assert (profile != null);
        SmartList sorted = new SmartList(this.parameterizations.values());
        Collections.sort(sorted, Comparator.comparingInt(ParameterInfo::getStartIndex).reversed());
        for (ParameterInfo info : sorted) {
            MatchResult r = replacementInfo.getNamedMatchResult(info.getName());
            if (info.isReplacementVariable()) {
                Replacer.insertSubstitution(result, 0, info, this.generateReplacement(info, match));
                continue;
            }
            if (r != null) {
                profile.handleSubstitution(info, r, result, replacementInfo);
                continue;
            }
            profile.handleNoSubstitution(info, result);
        }
        return result.toString();
    }

    private String generateReplacement(ParameterInfo info, MatchResult match) {
        ScriptSupport scriptSupport = this.replacementVarsMap.get(info.getName());
        if (scriptSupport == null) {
            String constraint = this.options.getVariableDefinition(info.getName()).getScriptCodeConstraint();
            List variableNames = ContainerUtil.map(this.options.getVariableDefinitions(), o -> o.getName());
            scriptSupport = new ScriptSupport(this.myProject, StringUtil.unquoteString((String)constraint), info.getName(), variableNames, this.options.getMatchOptions());
            this.replacementVarsMap.put(info.getName(), scriptSupport);
        }
        return scriptSupport.evaluate(match, null);
    }

    public Collection<ParameterInfo> findParameterization(String name) {
        return this.parameterizations.get((Object)name);
    }

    public ParameterInfo findParameterization(PsiElement element) {
        if (element == null) {
            return null;
        }
        String text = element.getText();
        if (!StructuralSearchUtil.isTypedVariable(text)) {
            return null;
        }
        return this.findParameterization(Replacer.stripTypedVariableDecoration(text)).stream().filter(info -> info.getElement() == element).findFirst().orElse(null);
    }
}

