/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.PatternContext;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeInfo {
    public static final FileTypeInfo[] EMPTY_ARRAY = new FileTypeInfo[0];
    private static final Pattern CLEANUP = Pattern.compile("(?i)\\s+file(?:s)?$");
    private final LanguageFileType myFileType;
    private final Language myDialect;
    private final PatternContext myContext;
    private final boolean myNested;
    private final String myDescription;

    public FileTypeInfo(@NotNull LanguageFileType fileType, @NotNull Language dialect, @Nullable PatternContext context, boolean nested) {
        if (fileType == null) {
            FileTypeInfo.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            FileTypeInfo.$$$reportNull$$$0(1);
        }
        this.myFileType = fileType;
        this.myDialect = dialect;
        this.myContext = context;
        this.myNested = nested;
        this.myDescription = FileTypeInfo.getDescription(fileType);
    }

    @NotNull
    public LanguageFileType getFileType() {
        LanguageFileType languageFileType = this.myFileType;
        if (languageFileType == null) {
            FileTypeInfo.$$$reportNull$$$0(2);
        }
        return languageFileType;
    }

    @Nullable
    public Language getDialect() {
        return this.myDialect;
    }

    @Nullable
    public PatternContext getContext() {
        return this.myContext;
    }

    @NotNull
    public String getText() {
        if (this.myNested) {
            if (this.myDialect != null && this.myDialect != this.myFileType.getLanguage()) {
                String string = this.myDialect.getDisplayName();
                if (string == null) {
                    FileTypeInfo.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (this.myContext != null) {
                String string = this.myDescription + " - " + this.myContext.getDisplayName();
                if (string == null) {
                    FileTypeInfo.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        String string = this.myDescription;
        if (string == null) {
            FileTypeInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getSearchText() {
        String string = this.myDialect != null ? this.myDialect.getDisplayName() : this.myFileType.getName();
        if (string == null) {
            FileTypeInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isNested() {
        return this.myNested;
    }

    public boolean isEqualTo(@NotNull LanguageFileType fileType, @Nullable Language dialect, @Nullable PatternContext context) {
        if (fileType == null) {
            FileTypeInfo.$$$reportNull$$$0(7);
        }
        return !(this.myFileType != fileType || dialect != null && this.myDialect != dialect || context != null && this.myContext != context);
    }

    @NotNull
    private static String getDescription(@NotNull LanguageFileType fileType) {
        if (fileType == null) {
            FileTypeInfo.$$$reportNull$$$0(8);
        }
        String description = fileType.getDescription();
        String string = StringUtil.capitalizeWords((String)CLEANUP.matcher(description).replaceAll(""), (boolean)true);
        if (string == null) {
            FileTypeInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileTypeInfo)) {
            return false;
        }
        FileTypeInfo info = (FileTypeInfo)o;
        return this.myFileType == info.myFileType && this.myDialect == info.myDialect && this.myContext == info.myContext;
    }

    public int hashCode() {
        return Objects.hash(this.myFileType, this.myDialect, this.myContext);
    }

    public String toString() {
        return this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/FileTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/FileTypeInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

