/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.structuralsearch.plugin.ui.filters.FilterTable;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TextFieldWithAutoCompletion;
import java.awt.Component;
import java.awt.Container;
import java.util.Collections;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class ReferenceFilter
extends FilterAction {
    public ReferenceFilter(FilterTable filterTable) {
        super(SSRBundle.messagePointer("reference.filter.name", new Object[0]), filterTable);
    }

    @Override
    public boolean hasFilter() {
        NamedScriptableDefinition variable = this.myTable.getVariable();
        if (!(variable instanceof MatchVariableConstraint)) {
            return false;
        }
        MatchVariableConstraint constraint = (MatchVariableConstraint)variable;
        return !StringUtil.isEmpty((String)constraint.getReferenceConstraint());
    }

    @Override
    public void clearFilter() {
        NamedScriptableDefinition variable = this.myTable.getVariable();
        if (!(variable instanceof MatchVariableConstraint)) {
            return;
        }
        MatchVariableConstraint constraint = (MatchVariableConstraint)variable;
        constraint.setReferenceConstraint("");
        constraint.setInvertReference(false);
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        return this.myTable.getVariable() instanceof MatchVariableConstraint && this.myTable.getProfile().isApplicableConstraint("REFERENCE", nodes, completePattern, target);
    }

    @Override
    protected void setLabel(SimpleColoredComponent component) {
        MatchVariableConstraint constraint = (MatchVariableConstraint)this.myTable.getVariable();
        component.append("reference=");
        if (constraint.isInvertReference()) {
            component.append("!");
        }
        component.append(constraint.getReferenceConstraint());
    }

    @Override
    public FilterEditor getEditor() {
        return new FilterEditor<MatchVariableConstraint>(this.myTable.getVariable(), this.myTable.getConstraintChangedCallback()){
            private final JLabel myLabel;
            private final TextFieldWithAutoCompletion<String> textField;
            private final String shortcut;
            private final ContextHelpLabel myHelpLabel;
            {
                this.myLabel = new JLabel(SSRBundle.message("reference.label", new Object[0]));
                this.textField = TextFieldWithAutoCompletion.create((Project)ReferenceFilter.this.myTable.getProject(), Collections.emptyList(), (boolean)false, (String)"");
                this.shortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
                this.myHelpLabel = ContextHelpLabel.create((String)SSRBundle.message("reference.filter.help.text", this.shortcut));
            }

            @Override
            protected void layoutComponents() {
                this.textField.setVariants(ConfigurationManager.getInstance(ReferenceFilter.this.myTable.getProject()).getAllConfigurationNames());
                GroupLayout layout = new GroupLayout((Container)((Object)this));
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.myLabel).addComponent((Component)this.textField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myLabel).addComponent((Component)this.textField).addComponent((Component)this.myHelpLabel));
            }

            @Override
            protected void loadValues() {
                this.textField.setText((((MatchVariableConstraint)this.myConstraint).isInvertReference() ? "!" : "") + ((MatchVariableConstraint)this.myConstraint).getReferenceConstraint());
            }

            @Override
            protected void saveValues() {
                String text = this.textField.getText();
                if (text.startsWith("!")) {
                    ((MatchVariableConstraint)this.myConstraint).setReferenceConstraint(text.substring(1));
                    ((MatchVariableConstraint)this.myConstraint).setInvertReference(true);
                } else {
                    ((MatchVariableConstraint)this.myConstraint).setReferenceConstraint(text);
                    ((MatchVariableConstraint)this.myConstraint).setInvertReference(false);
                }
            }

            public JComponent getPreferredFocusedComponent() {
                return this.textField;
            }

            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.textField};
            }
        };
    }
}

