/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.CannotRestoreValue;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.IntSource;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.PropertyChecker;
import org.jetbrains.jetCheck.StructureElement;

class DataSerializer {
    DataSerializer() {
    }

    private static int readINT(ByteArrayInputStream record) {
        int val = DataSerializer.readWithEof(record);
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = DataSerializer.readWithEof(record);
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    private static int readWithEof(ByteArrayInputStream record) {
        if (record.available() <= 0) {
            throw new EOFException();
        }
        return record.read();
    }

    static void writeINT(ByteArrayOutputStream record, int val) {
        if (0 > val || val >= 192) {
            record.write(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.write(val & 0x7F | 0x80);
                val >>>= 7;
            }
        }
        record.write(val);
    }

    static String serialize(Iteration iteration, StructureElement node) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataSerializer.writeINT(data, (int)(iteration.iterationSeed >> 32));
        DataSerializer.writeINT(data, (int)iteration.iterationSeed);
        DataSerializer.writeINT(data, iteration.sizeHint);
        node.serialize(data);
        return Base64.getEncoder().encodeToString(data.toByteArray());
    }

    static PropertyChecker.Parameters deserializeInto(String data, PropertyChecker.Parameters parameters) {
        ByteArrayInputStream stream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
        int seedHigh = DataSerializer.readINT(stream);
        int seedLow = DataSerializer.readINT(stream);
        long globalSeed = (long)seedHigh << 32 | (long)seedLow & 0xFFFFFFFFL;
        int hint = DataSerializer.readINT(stream);
        SerializedIntSource serializedData = new SerializedIntSource(stream);
        return new PropertyChecker.Parameters(globalSeed, serializedData, __ -> hint, 1, parameters.silent, parameters.printValues, parameters.printData);
    }

    @NotNull
    static CannotRestoreValue errorRestoringSerialized() {
        return new CannotRestoreValue("Error restoring from serialized \"rechecking\" data. Possible cause: either the test or the environment it depends on has changed.");
    }

    static class SerializedIntSource
    implements IntSource {
        private final ByteArrayInputStream stream;

        SerializedIntSource(ByteArrayInputStream stream) {
            this.stream = stream;
        }

        @Override
        public int drawInt(IntDistribution dist) {
            int i = DataSerializer.readINT(this.stream);
            if (!dist.isValidValue(i)) {
                throw DataSerializer.errorRestoringSerialized();
            }
            return i;
        }
    }

    static class EOFException
    extends RuntimeException {
        EOFException() {
        }
    }
}

