/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.StatisticsEventLogUtil;
import com.intellij.internal.statistic.connect.SettingsConnectionService;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.LogEventCompositeFilter;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventSnapshotBuildFilter;
import com.intellij.internal.statistic.eventLog.LogEventWhitelistFilter;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogUploadSettingsService
extends SettingsConnectionService
implements EventLogSettingsService {
    private static final String APPROVED_GROUPS_SERVICE = "white-list-service";
    private static final String DICTIONARY_SERVICE = "dictionary-service";
    private static final String PERCENT_TRAFFIC = "percent-traffic";
    @NotNull
    private final EventLogApplicationInfo myApplicationInfo;

    public EventLogUploadSettingsService(@NotNull String recorderId, @NotNull EventLogApplicationInfo appInfo) {
        if (recorderId == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(0);
        }
        if (appInfo == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(1);
        }
        super(EventLogUploadSettingsService.getConfigUrl(recorderId, appInfo.getTemplateUrl(), appInfo.isTest()), null, appInfo.getUserAgent(), appInfo.getLogger(), appInfo.getEventLogger());
        this.myApplicationInfo = appInfo;
    }

    @NotNull
    private static String getConfigUrl(@NotNull String recorderId, @NotNull String templateUrl, boolean isTest) {
        if (recorderId == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(2);
        }
        if (templateUrl == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(3);
        }
        if (isTest) {
            String string = String.format(templateUrl, "test/" + recorderId);
            if (string == null) {
                EventLogUploadSettingsService.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = String.format(templateUrl, recorderId);
        if (string == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public String @NotNull [] getAttributeNames() {
        String[] additionalOptions = new String[]{PERCENT_TRAFFIC, APPROVED_GROUPS_SERVICE, DICTIONARY_SERVICE};
        String[] stringArray = StatisticsEventLogUtil.mergeArrays(super.getAttributeNames(), additionalOptions);
        if (stringArray == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @Override
    public int getPermittedTraffic() {
        String permitted = this.getSettingValue(PERCENT_TRAFFIC);
        if (permitted != null) {
            try {
                return Integer.parseInt(permitted);
            }
            catch (NumberFormatException e) {
                this.myApplicationInfo.getLogger().trace("Permitted traffic is not defined or has invalid format: '" + permitted + "'");
            }
        }
        return 0;
    }

    @Override
    @Nullable
    public String getDictionaryServiceUrl() {
        return this.getSettingValue(DICTIONARY_SERVICE);
    }

    @Override
    @NotNull
    public LogEventFilter getEventFilter() {
        FUSWhitelist whitelist = EventLogUploadSettingsService.notNull(this.getWhitelistedGroups(), FUSWhitelist.empty());
        return new LogEventCompositeFilter(new LogEventWhitelistFilter(whitelist), LogEventSnapshotBuildFilter.INSTANCE);
    }

    private static FUSWhitelist notNull(@Nullable FUSWhitelist whitelist, @NotNull FUSWhitelist defaultValue) {
        if (defaultValue == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(7);
        }
        return whitelist != null ? whitelist : defaultValue;
    }

    @Override
    @NotNull
    public EventLogApplicationInfo getApplicationInfo() {
        EventLogApplicationInfo eventLogApplicationInfo = this.myApplicationInfo;
        if (eventLogApplicationInfo == null) {
            EventLogUploadSettingsService.$$$reportNull$$$0(8);
        }
        return eventLogApplicationInfo;
    }

    @Nullable
    protected FUSWhitelist getWhitelistedGroups() {
        String productUrl = this.getWhiteListProductUrl();
        if (productUrl == null) {
            return null;
        }
        String userAgent = this.myApplicationInfo.getUserAgent();
        return FUStatisticsWhiteListGroupsService.getApprovedGroups(userAgent, productUrl);
    }

    @NonNls
    @Nullable
    public String getWhiteListProductUrl() {
        String approvedGroupsServiceUrl = this.getSettingValue(APPROVED_GROUPS_SERVICE);
        if (approvedGroupsServiceUrl == null) {
            return null;
        }
        return approvedGroupsServiceUrl + this.myApplicationInfo.getProductCode() + ".json";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateUrl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogUploadSettingsService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogUploadSettingsService";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigUrl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

