/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus;

import com.intellij.internal.statistic.StatisticsEventLogUtil;
import com.intellij.internal.statistic.eventLog.EventLogBuildNumber;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUSWhitelist {
    private Map<String, GroupFilterCondition> myGroups;

    public FUSWhitelist() {
    }

    private FUSWhitelist(@NotNull Map<String, GroupFilterCondition> groups) {
        if (groups == null) {
            FUSWhitelist.$$$reportNull$$$0(0);
        }
        this.myGroups = groups;
    }

    @NotNull
    public static FUSWhitelist create(@NotNull Map<String, GroupFilterCondition> groups) {
        if (groups == null) {
            FUSWhitelist.$$$reportNull$$$0(1);
        }
        return new FUSWhitelist(groups);
    }

    @NotNull
    public static FUSWhitelist empty() {
        return new FUSWhitelist(Collections.emptyMap());
    }

    public boolean accepts(@NotNull String groupId, @Nullable String version, @NotNull String build) {
        if (groupId == null) {
            FUSWhitelist.$$$reportNull$$$0(2);
        }
        if (build == null) {
            FUSWhitelist.$$$reportNull$$$0(3);
        }
        if (!this.myGroups.containsKey(groupId)) {
            return false;
        }
        int parsedVersion = FUSWhitelist.tryToParse(version, -1);
        if (parsedVersion < 0) {
            return false;
        }
        GroupFilterCondition condition = this.myGroups.get(groupId);
        return condition.accepts(build, parsedVersion);
    }

    public int getSize() {
        return this.myGroups.size();
    }

    public boolean isEmpty() {
        return this.myGroups.isEmpty();
    }

    private static int tryToParse(@Nullable String value, int defaultValue) {
        try {
            if (value != null) {
                return Integer.parseInt(value.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FUSWhitelist whitelist = (FUSWhitelist)o;
        return Objects.equals(this.myGroups, whitelist.myGroups);
    }

    public int hashCode() {
        return Objects.hash(this.myGroups);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/service/fus/FUSWhitelist";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accepts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class VersionRange {
        private final int myFrom;
        private final int myTo;

        public VersionRange(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public static VersionRange create(@Nullable String from, @Nullable String to) {
            return new VersionRange(from == null ? 0 : FUSWhitelist.tryToParse(from, Integer.MAX_VALUE), to == null ? Integer.MAX_VALUE : FUSWhitelist.tryToParse(to, 0));
        }

        public boolean contains(int current) {
            return current >= this.myFrom && current < this.myTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionRange range = (VersionRange)o;
            return this.myFrom == range.myFrom && this.myTo == range.myTo;
        }

        public int hashCode() {
            return Objects.hash(this.myFrom, this.myTo);
        }
    }

    public static class BuildRange {
        private final EventLogBuildNumber myFrom;
        private final EventLogBuildNumber myTo;

        public BuildRange(@Nullable EventLogBuildNumber from, @Nullable EventLogBuildNumber to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public static BuildRange create(@Nullable String from, @Nullable String to) {
            return new BuildRange(StatisticsEventLogUtil.isNotEmpty(from) ? EventLogBuildNumber.fromString(from) : null, StatisticsEventLogUtil.isNotEmpty(to) ? EventLogBuildNumber.fromString(to) : null);
        }

        public boolean contains(@NotNull EventLogBuildNumber build) {
            if (build == null) {
                BuildRange.$$$reportNull$$$0(0);
            }
            return !(this.myTo != null && this.myTo.compareTo(build) <= 0 || this.myFrom != null && this.myFrom.compareTo(build) > 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildRange range = (BuildRange)o;
            return Objects.equals(this.myFrom, range.myFrom) && Objects.equals(this.myTo, range.myTo);
        }

        public int hashCode() {
            return Objects.hash(this.myFrom, this.myTo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "build", "com/intellij/internal/statistic/service/fus/FUSWhitelist$BuildRange", "contains"));
        }
    }

    public static class GroupFilterCondition {
        private final List<BuildRange> builds;
        private final List<VersionRange> versions;

        public GroupFilterCondition(@NotNull List<BuildRange> builds, @NotNull List<VersionRange> versions) {
            if (builds == null) {
                GroupFilterCondition.$$$reportNull$$$0(0);
            }
            if (versions == null) {
                GroupFilterCondition.$$$reportNull$$$0(1);
            }
            this.builds = builds;
            this.versions = versions;
        }

        public boolean accepts(@NotNull String build, int version) {
            if (build == null) {
                GroupFilterCondition.$$$reportNull$$$0(2);
            }
            if (!this.isValid()) {
                return false;
            }
            return this.acceptsBuild(build) && this.acceptsVersion(version);
        }

        private boolean acceptsBuild(@NotNull String build) {
            if (build == null) {
                GroupFilterCondition.$$$reportNull$$$0(3);
            }
            if (this.builds.isEmpty()) {
                return true;
            }
            EventLogBuildNumber number = EventLogBuildNumber.fromString(build);
            return number != null && this.builds.stream().anyMatch(b -> b.contains(number));
        }

        private boolean acceptsVersion(int version) {
            if (this.versions.isEmpty()) {
                return true;
            }
            return version > 0 && this.versions.stream().anyMatch(v -> v.contains(version));
        }

        private boolean isValid() {
            return !this.builds.isEmpty() || !this.versions.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupFilterCondition condition = (GroupFilterCondition)o;
            return Objects.equals(this.builds, condition.builds) && Objects.equals(this.versions, condition.versions);
        }

        public int hashCode() {
            return Objects.hash(this.builds, this.versions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builds";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "build";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/service/fus/FUSWhitelist$GroupFilterCondition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accepts";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptsBuild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

