/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.decompose;

import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraph;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraphNode;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class GenericDominatorEngine {
    private final IGraph graph;
    private final VBStyleCollection<IGraphNode, IGraphNode> colOrderedIDoms = new VBStyleCollection();
    private Set<? extends IGraphNode> setRoots;

    public GenericDominatorEngine(IGraph graph) {
        this.graph = graph;
    }

    public void initialize() {
        this.calcIDoms();
    }

    private void orderNodes() {
        this.setRoots = this.graph.getRoots();
        for (IGraphNode iGraphNode : this.graph.getReversePostOrderList()) {
            this.colOrderedIDoms.addWithKey(null, iGraphNode);
        }
    }

    private static IGraphNode getCommonIDom(IGraphNode node1, IGraphNode node2, VBStyleCollection<IGraphNode, IGraphNode> orderedIDoms) {
        if (node1 == null) {
            return node2;
        }
        if (node2 == null) {
            return node1;
        }
        int index1 = orderedIDoms.getIndexByKey(node1);
        int index2 = orderedIDoms.getIndexByKey(node2);
        while (index1 != index2) {
            IGraphNode nodeOld;
            if (index1 > index2) {
                nodeOld = node1;
                if (nodeOld == (node1 = orderedIDoms.getWithKey(node1))) {
                    return null;
                }
                index1 = orderedIDoms.getIndexByKey(node1);
                continue;
            }
            nodeOld = node2;
            if (nodeOld == (node2 = orderedIDoms.getWithKey(node2))) {
                return null;
            }
            index2 = orderedIDoms.getIndexByKey(node2);
        }
        return node1;
    }

    private void calcIDoms() {
        boolean changed;
        this.orderNodes();
        ArrayList<IGraphNode> lstNodes = this.colOrderedIDoms.getLstKeys();
        do {
            changed = false;
            for (IGraphNode node : lstNodes) {
                IGraphNode oldidom;
                IGraphNode idom = null;
                if (!this.setRoots.contains(node)) {
                    for (IGraphNode iGraphNode : node.getPredecessors()) {
                        if (this.colOrderedIDoms.getWithKey(iGraphNode) != null && (idom = GenericDominatorEngine.getCommonIDom(idom, iGraphNode, this.colOrderedIDoms)) == null) break;
                    }
                }
                if (idom == null) {
                    idom = node;
                }
                if (idom.equals(oldidom = this.colOrderedIDoms.putWithKey(idom, node))) continue;
                changed = true;
            }
        } while (changed);
    }

    public boolean isDominator(IGraphNode node, IGraphNode dom) {
        while (!node.equals(dom)) {
            IGraphNode idom = this.colOrderedIDoms.getWithKey(node);
            if (idom == node) {
                return false;
            }
            if (idom == null) {
                throw new RuntimeException("Inconsistent idom sequence discovered!");
            }
            node = idom;
        }
        return true;
    }
}

