/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.DefaultTaskContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GradleVersion;

public class TasksFactory {
    private final Map<Project, Set<Task>> allTasks = new HashMap<Project, Set<Task>>();
    private final Set<Project> processedRootProjects = new HashSet<Project>();

    private void collectTasks(Project root) {
        TaskContainer tasks;
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.0")) < 0 && (tasks = root.getTasks()) instanceof DefaultTaskContainer) {
            ((DefaultTaskContainer)tasks).discoverTasks();
            SortedSet taskNames = tasks.getNames();
            for (String taskName : taskNames) {
                tasks.findByName(taskName);
            }
        }
        this.allTasks.putAll(root.getAllTasks(true));
    }

    public Set<Task> getTasks(Project project) {
        Project rootProject = project.getRootProject();
        if (this.processedRootProjects.add(rootProject)) {
            this.collectTasks(rootProject);
        }
        LinkedHashSet<Task> tasks = new LinkedHashSet<Task>((Collection)this.allTasks.get(project));
        for (Project subProject : project.getSubprojects()) {
            tasks.addAll((Collection<Task>)this.allTasks.get(subProject));
        }
        return tasks;
    }
}

