/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ExactVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.InverseVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.SubVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionRangeSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;

public class DefaultVersionSelectorScheme
implements VersionSelectorScheme {
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;

    @Deprecated
    public DefaultVersionSelectorScheme(VersionComparator versionComparator) {
        this(versionComparator, new VersionParser());
    }

    public DefaultVersionSelectorScheme(VersionComparator versionComparator, VersionParser versionParser) {
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
    }

    @Override
    public VersionSelector parseSelector(String selectorString) {
        if (VersionRangeSelector.ALL_RANGE.matcher(selectorString).matches()) {
            return new VersionRangeSelector(selectorString, this.versionComparator.asVersionComparator(), this.versionParser);
        }
        if (selectorString.endsWith("+")) {
            return new SubVersionSelector(selectorString);
        }
        if (selectorString.startsWith("latest.")) {
            return new LatestVersionSelector(selectorString);
        }
        return new ExactVersionSelector(selectorString);
    }

    @Override
    public String renderSelector(VersionSelector selector) {
        return selector.getSelector();
    }

    @Override
    public VersionSelector complementForRejection(VersionSelector selector) {
        return new InverseVersionSelector(selector);
    }
}

