/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.Describables;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;

class DependencyState {
    private final ComponentSelector requested;
    private final DependencyMetadata dependency;
    private final List<ComponentSelectionDescriptorInternal> ruleDescriptors;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final int hashCode;
    private ModuleIdentifier moduleIdentifier;
    public ModuleVersionResolveException failure;
    private boolean reasonsAlreadyAdded;

    DependencyState(DependencyMetadata dependency, ComponentSelectorConverter componentSelectorConverter) {
        this(dependency, dependency.getSelector(), null, componentSelectorConverter);
    }

    private DependencyState(DependencyMetadata dependency, ComponentSelector requested, List<ComponentSelectionDescriptorInternal> ruleDescriptors, ComponentSelectorConverter componentSelectorConverter) {
        this.dependency = dependency;
        this.requested = requested;
        this.ruleDescriptors = ruleDescriptors;
        this.componentSelectorConverter = componentSelectorConverter;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int hashCode = this.dependency.hashCode();
        hashCode = 31 * hashCode + this.requested.hashCode();
        return hashCode;
    }

    public ComponentSelector getRequested() {
        return this.requested;
    }

    public DependencyMetadata getDependency() {
        return this.dependency;
    }

    public ModuleIdentifier getModuleIdentifier() {
        if (this.moduleIdentifier == null) {
            this.moduleIdentifier = this.componentSelectorConverter.getModule(this.dependency.getSelector());
        }
        return this.moduleIdentifier;
    }

    public DependencyState withTarget(ComponentSelector target, List<ComponentSelectionDescriptorInternal> ruleDescriptors) {
        DependencyMetadata targeted = this.dependency.withTarget(target);
        return new DependencyState(targeted, this.requested, ruleDescriptors, this.componentSelectorConverter);
    }

    public List<ComponentSelectionDescriptorInternal> getRuleDescriptors() {
        return this.ruleDescriptors;
    }

    public boolean isForced() {
        if (this.ruleDescriptors != null) {
            for (ComponentSelectionDescriptorInternal ruleDescriptor : this.ruleDescriptors) {
                if (!ruleDescriptor.isEquivalentToForce()) continue;
                return true;
            }
        }
        return this.isDependencyForced();
    }

    private boolean isDependencyForced() {
        return this.dependency instanceof ForcingDependencyMetadata && ((ForcingDependencyMetadata)this.dependency).isForce();
    }

    public boolean isFromLock() {
        return this.dependency instanceof LocalOriginDependencyMetadata && ((LocalOriginDependencyMetadata)this.dependency).isFromLock();
    }

    void addSelectionReasons(List<ComponentSelectionDescriptorInternal> reasons) {
        if (this.reasonsAlreadyAdded) {
            return;
        }
        this.reasonsAlreadyAdded = true;
        this.addMainReason(reasons);
        if (this.ruleDescriptors != null) {
            this.addRuleDescriptors(reasons);
        }
        if (this.isDependencyForced()) {
            DependencyState.maybeAddReason(reasons, ComponentSelectionReasons.FORCED);
        }
    }

    private void addRuleDescriptors(List<ComponentSelectionDescriptorInternal> reasons) {
        for (ComponentSelectionDescriptorInternal descriptor : this.ruleDescriptors) {
            DependencyState.maybeAddReason(reasons, descriptor);
        }
    }

    private void addMainReason(List<ComponentSelectionDescriptorInternal> reasons) {
        ComponentSelectionDescriptorInternal dependencyDescriptor = reasons != null && reasons.contains(ComponentSelectionReasons.BY_ANCESTOR) ? ComponentSelectionReasons.BY_ANCESTOR : (this.dependency.isConstraint() ? ComponentSelectionReasons.CONSTRAINT : ComponentSelectionReasons.REQUESTED);
        String reason = this.dependency.getReason();
        if (reason != null) {
            dependencyDescriptor = dependencyDescriptor.withDescription(Describables.of(reason));
        }
        DependencyState.maybeAddReason(reasons, dependencyDescriptor);
    }

    private static void maybeAddReason(List<ComponentSelectionDescriptorInternal> reasons, ComponentSelectionDescriptorInternal reason) {
        if (reasons.isEmpty()) {
            reasons.add(reason);
        } else if (DependencyState.isNewReason(reasons, reason)) {
            reasons.add(reason);
        }
    }

    private static boolean isNewReason(List<ComponentSelectionDescriptorInternal> reasons, ComponentSelectionDescriptorInternal reason) {
        return reasons.size() == 1 && !reason.equals(reasons.get(0)) || !reasons.contains(reason);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

