/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.descriptor;

import java.net.URI;
import java.util.Collection;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.descriptor.UrlRepositoryDescriptor;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;

public final class IvyRepositoryDescriptor
extends UrlRepositoryDescriptor {
    public final ImmutableList<String> ivyPatterns;
    public final ImmutableList<String> artifactPatterns;
    public final String layoutType;
    public final boolean m2Compatible;

    private IvyRepositoryDescriptor(String name, URI url, ImmutableList<String> metadataSources, boolean authenticated, ImmutableList<String> authenticationSchemes, ImmutableList<String> ivyPatterns, ImmutableList<String> artifactPatterns, String layoutType, boolean m2Compatible) {
        super(name, url, metadataSources, authenticated, authenticationSchemes);
        this.ivyPatterns = ivyPatterns;
        this.artifactPatterns = artifactPatterns;
        this.layoutType = layoutType;
        this.m2Compatible = m2Compatible;
    }

    @Override
    public RepositoryDescriptor.Type getType() {
        return RepositoryDescriptor.Type.IVY;
    }

    @Override
    protected void addProperties(ImmutableSortedMap.Builder<String, Object> builder) {
        super.addProperties(builder);
        builder.put((Object)Property.IVY_PATTERNS.name(), this.ivyPatterns);
        builder.put((Object)Property.ARTIFACT_PATTERNS.name(), this.artifactPatterns);
        builder.put((Object)Property.LAYOUT_TYPE.name(), (Object)this.layoutType);
        builder.put((Object)Property.M2_COMPATIBLE.name(), (Object)this.m2Compatible);
    }

    public static class Builder
    extends UrlRepositoryDescriptor.Builder<Builder> {
        private ImmutableList<String> ivyPatterns;
        private ImmutableList<String> artifactPatterns;
        private String layoutType;
        private Boolean m2Compatible;

        public Builder(String name, URI url) {
            super(name, url);
        }

        public Builder setIvyPatterns(Collection<String> ivyPatterns) {
            this.ivyPatterns = ImmutableList.copyOf(ivyPatterns);
            return this;
        }

        public Builder setArtifactPatterns(Collection<String> artifactPatterns) {
            this.artifactPatterns = ImmutableList.copyOf(artifactPatterns);
            return this;
        }

        public Builder setLayoutType(String layoutType) {
            this.layoutType = layoutType;
            return this;
        }

        public Builder setM2Compatible(boolean m2Compatible) {
            this.m2Compatible = m2Compatible;
            return this;
        }

        public IvyRepositoryDescriptor create() {
            return new IvyRepositoryDescriptor((String)Preconditions.checkNotNull((Object)this.name), this.url, (ImmutableList)Preconditions.checkNotNull((Object)this.metadataSources), (Boolean)Preconditions.checkNotNull((Object)this.authenticated), (ImmutableList)Preconditions.checkNotNull((Object)this.authenticationSchemes), (ImmutableList)Preconditions.checkNotNull(this.ivyPatterns), (ImmutableList)Preconditions.checkNotNull(this.artifactPatterns), (String)Preconditions.checkNotNull((Object)this.layoutType), (Boolean)Preconditions.checkNotNull((Object)this.m2Compatible));
        }
    }

    private static enum Property {
        IVY_PATTERNS,
        ARTIFACT_PATTERNS,
        LAYOUT_TYPE,
        M2_COMPATIBLE;

    }
}

