/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;

public abstract class AbstractDependencyMetadataAdapter<T extends DependencyMetadata>
implements DependencyMetadata<T> {
    private final List<ModuleDependencyMetadata> container;
    private final int originalIndex;
    private final ImmutableAttributesFactory attributesFactory;

    public AbstractDependencyMetadataAdapter(ImmutableAttributesFactory attributesFactory, List<ModuleDependencyMetadata> container, int originalIndex) {
        this.attributesFactory = attributesFactory;
        this.container = container;
        this.originalIndex = originalIndex;
    }

    protected ModuleDependencyMetadata getOriginalMetadata() {
        return this.container.get(this.originalIndex);
    }

    protected void updateMetadata(ModuleDependencyMetadata modifiedMetadata) {
        this.container.set(this.originalIndex, modifiedMetadata);
    }

    @Override
    public String getGroup() {
        return this.getOriginalMetadata().getSelector().getGroup();
    }

    @Override
    public String getName() {
        return this.getOriginalMetadata().getSelector().getModule();
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.getOriginalMetadata().getSelector().getVersionConstraint();
    }

    @Override
    public T version(Action<? super MutableVersionConstraint> configureAction) {
        DefaultMutableVersionConstraint mutableVersionConstraint = new DefaultMutableVersionConstraint(this.getVersionConstraint());
        configureAction.execute(mutableVersionConstraint);
        ModuleDependencyMetadata dependencyMetadata = this.getOriginalMetadata().withRequestedVersion(mutableVersionConstraint);
        this.updateMetadata(dependencyMetadata);
        return (T)((DependencyMetadata)Cast.uncheckedCast(this));
    }

    @Override
    public T because(String reason) {
        this.updateMetadata(this.getOriginalMetadata().withReason(reason));
        return (T)((DependencyMetadata)Cast.uncheckedCast(this));
    }

    @Override
    public ModuleIdentifier getModule() {
        return this.getOriginalMetadata().getSelector().getModuleIdentifier();
    }

    @Override
    public String getReason() {
        return this.getOriginalMetadata().getReason();
    }

    public String toString() {
        return this.getGroup() + ":" + this.getName() + ":" + this.getVersionConstraint();
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.getOriginalMetadata().getSelector().getAttributes();
    }

    @Override
    public T attributes(Action<? super AttributeContainer> configureAction) {
        ModuleComponentSelector selector = this.getOriginalMetadata().getSelector();
        AttributeContainerInternal attributes = this.attributesFactory.mutable((AttributeContainerInternal)selector.getAttributes());
        configureAction.execute(attributes);
        ModuleComponentSelector target = DefaultModuleComponentSelector.newSelector(selector.getModuleIdentifier(), selector.getVersionConstraint(), attributes.asImmutable(), selector.getRequestedCapabilities());
        ModuleDependencyMetadata metadata = (ModuleDependencyMetadata)this.getOriginalMetadata().withTarget(target);
        this.updateMetadata(metadata);
        return (T)((DependencyMetadata)Cast.uncheckedCast(this));
    }

    public void forced() {
        ModuleDependencyMetadata originalMetadata = this.getOriginalMetadata();
        if (originalMetadata instanceof ForcingDependencyMetadata) {
            this.updateMetadata((ModuleDependencyMetadata)((Object)((ForcingDependencyMetadata)((Object)originalMetadata)).forced()));
        }
    }
}

