/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.file.internal.FilePathUtil;
import org.gradle.api.internal.changedetection.state.ConfigurableNormalizer;
import org.gradle.api.internal.changedetection.state.FileZipInput;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.StreamZipInput;
import org.gradle.api.internal.changedetection.state.ZipEntry;
import org.gradle.api.internal.changedetection.state.ZipInput;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.IoActions;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.org.apache.commons.compress.utils.Lists;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipHasher
implements RegularFileHasher,
ConfigurableNormalizer {
    private static final Set<String> KNOWN_ZIP_EXTENSIONS = ImmutableSet.of((Object)".zip", (Object)".jar", (Object)".war", (Object)".rar", (Object)".ear", (Object)".apk", (Object[])new String[]{".aar"});
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipHasher.class);
    private final ResourceHasher resourceHasher;
    private final ResourceFilter resourceFilter;

    public static boolean isZipFile(String name) {
        for (String extension : KNOWN_ZIP_EXTENSIONS) {
            if (!FileUtils.hasExtensionIgnoresCase(name, extension)) continue;
            return true;
        }
        return false;
    }

    public ZipHasher(ResourceHasher resourceHasher, ResourceFilter resourceFilter) {
        this.resourceHasher = resourceHasher;
        this.resourceFilter = resourceFilter;
    }

    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        return this.hashZipContents(fileSnapshot);
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
        this.resourceHasher.appendConfigurationToHasher(hasher);
        this.resourceFilter.appendConfigurationToHasher(hasher);
    }

    @Nullable
    private HashCode hashZipContents(RegularFileSnapshot zipFileSnapshot) {
        try {
            List<FileSystemLocationFingerprint> fingerprints = this.fingerprintZipEntries(zipFileSnapshot.getAbsolutePath());
            if (fingerprints.isEmpty()) {
                return null;
            }
            Hasher hasher = Hashing.newHasher();
            FingerprintHashingStrategy.SORT.appendToHasher(hasher, fingerprints);
            return hasher.hash();
        }
        catch (Exception e) {
            return this.hashMalformedZip(zipFileSnapshot, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileSystemLocationFingerprint> fingerprintZipEntries(String zipFile) throws IOException {
        ArrayList arrayList;
        ZipInput input = null;
        try {
            input = FileZipInput.create(new File(zipFile));
            ArrayList fingerprints = Lists.newArrayList();
            this.fingerprintZipEntries("", fingerprints, input);
            arrayList = fingerprints;
        }
        catch (Throwable throwable) {
            IoActions.closeQuietly(input);
            throw throwable;
        }
        IoActions.closeQuietly(input);
        return arrayList;
    }

    private void fingerprintZipEntries(String parentName, List<FileSystemLocationFingerprint> fingerprints, ZipInput input) throws IOException {
        fingerprints.add(this.newZipMarker(parentName));
        for (ZipEntry zipEntry : input) {
            String fullName;
            ZipEntryRelativePath relativePath = new ZipEntryRelativePath(zipEntry);
            if (zipEntry.isDirectory() || this.resourceFilter.shouldBeIgnored(relativePath)) continue;
            String string = fullName = parentName.isEmpty() ? zipEntry.getName() : parentName + "/" + zipEntry.getName();
            if (ZipHasher.isZipFile(zipEntry.getName())) {
                this.fingerprintZipEntries(fullName, fingerprints, new StreamZipInput(zipEntry.getInputStream()));
                continue;
            }
            HashCode hash = this.resourceHasher.hash(zipEntry);
            if (hash == null) continue;
            fingerprints.add(new DefaultFileSystemLocationFingerprint(fullName, FileType.RegularFile, hash));
        }
    }

    private DefaultFileSystemLocationFingerprint newZipMarker(String relativePath) {
        return new DefaultFileSystemLocationFingerprint(relativePath, FileType.RegularFile, HashCode.fromInt(0));
    }

    private HashCode hashMalformedZip(RegularFileSnapshot zipFileSnapshot, Exception e) {
        LOGGER.debug("Malformed archive '{}'. Falling back to full content hash instead of entry hashing.", (Object)zipFileSnapshot.getName(), (Object)e);
        return zipFileSnapshot.getHash();
    }

    private static class ZipEntryRelativePath
    implements Factory<String[]> {
        private final ZipEntry zipEntry;

        private ZipEntryRelativePath(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }

        @Override
        public String[] create() {
            return FilePathUtil.getPathSegments(this.zipEntry.getName());
        }
    }
}

