/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.model;

import groovy.lang.GroovyObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.Transformer;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.com.google.common.cache.CacheLoader;
import org.gradle.internal.impldep.com.google.common.cache.LoadingCache;
import org.gradle.internal.impldep.com.google.common.util.concurrent.UncheckedExecutionException;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.internal.state.Managed;
import org.gradle.internal.state.ManagedFactory;
import org.gradle.model.internal.asm.AsmClassGenerator;
import org.gradle.model.internal.asm.ClassGeneratorSuffixRegistry;
import org.gradle.model.internal.inspect.FormattingValidationProblemCollector;
import org.gradle.model.internal.inspect.ValidationProblemCollector;
import org.gradle.model.internal.type.ModelType;

public class NamedObjectInstantiator
implements ManagedFactory {
    private static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{Named.class.getName()});
    private static final Type OBJECT = Type.getType(Object.class);
    private static final Type STRING = Type.getType(String.class);
    private static final Type CLASS_GENERATING_LOADER = Type.getType(ClassGeneratingLoader.class);
    private static final Type MANAGED = Type.getType(Managed.class);
    private static final String[] INTERFACES_FOR_ABSTRACT_CLASS = new String[]{MANAGED.getInternalName()};
    private static final String RETURN_VOID = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
    private static final String RETURN_STRING = Type.getMethodDescriptor((Type)STRING, (Type[])new Type[0]);
    private static final String RETURN_CLASS = Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]);
    private static final String RETURN_BOOLEAN = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
    private static final String RETURN_OBJECT = Type.getMethodDescriptor((Type)OBJECT, (Type[])new Type[0]);
    private static final String RETURN_INT = Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]);
    private static final String RETURN_VOID_FROM_STRING = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING});
    private static final String RETURN_OBJECT_FROM_STRING = Type.getMethodDescriptor((Type)OBJECT, (Type[])new Type[]{STRING});
    private static final String NAME_FIELD = "_gr_name_";
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final CrossBuildInMemoryCache<Class<?>, LoadingCache<String, Object>> generatedTypes;
    private final String implSuffix;
    private final String factorySuffix;
    private final Transformer<LoadingCache<String, Object>, Class<?>> cacheFactory = new Transformer<LoadingCache<String, Object>, Class<?>>(){

        @Override
        public LoadingCache<String, Object> transform(Class<?> type) {
            return CacheBuilder.newBuilder().build((CacheLoader)NamedObjectInstantiator.this.loaderFor(type));
        }
    };

    public NamedObjectInstantiator(CrossBuildInMemoryCacheFactory cacheFactory) {
        this.implSuffix = ClassGeneratorSuffixRegistry.assign("$Impl");
        this.factorySuffix = ClassGeneratorSuffixRegistry.assign(this.implSuffix + "Factory");
        this.generatedTypes = cacheFactory.newClassMap();
    }

    public <T extends Named> T named(Class<T> type, String name) throws ObjectInstantiationException {
        try {
            return (T)((Named)type.cast(this.generatedTypes.get(type, this.cacheFactory).getUnchecked((Object)name)));
        }
        catch (UncheckedExecutionException e) {
            throw new ObjectInstantiationException(type, e.getCause());
        }
        catch (Exception e) {
            throw new ObjectInstantiationException(type, (Throwable)e);
        }
    }

    @Override
    public <T> T fromState(Class<T> type, Object state) {
        if (!Named.class.isAssignableFrom(type)) {
            return null;
        }
        return this.named((Class)Cast.uncheckedCast(type), (String)state);
    }

    @Override
    public int getId() {
        return FACTORY_ID;
    }

    private ClassGeneratingLoader loaderFor(Class<?> publicClass) {
        String[] interfaces;
        Type superClass;
        FormattingValidationProblemCollector problemCollector = new FormattingValidationProblemCollector("Named implementation class", ModelType.of(publicClass));
        this.visitFields(publicClass, problemCollector);
        if (problemCollector.hasProblems()) {
            throw new GradleException(problemCollector.format());
        }
        AsmClassGenerator generator = new AsmClassGenerator(publicClass, this.implSuffix);
        Type implementationType = generator.getGeneratedType();
        ClassWriter visitor = generator.getVisitor();
        Type publicType = Type.getType(publicClass);
        if (publicClass.isInterface()) {
            superClass = OBJECT;
            interfaces = new String[]{publicType.getInternalName(), MANAGED.getInternalName()};
        } else {
            superClass = publicType;
            interfaces = INTERFACES_FOR_ABSTRACT_CLASS;
        }
        visitor.visit(49, 4097, implementationType.getInternalName(), null, superClass.getInternalName(), interfaces);
        visitor.visitField(2, NAME_FIELD, STRING.getDescriptor(), null, null);
        MethodVisitor methodVisitor = visitor.visitMethod(1, CONSTRUCTOR_NAME, RETURN_VOID_FROM_STRING, null, EMPTY_STRINGS);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, superClass.getInternalName(), CONSTRUCTOR_NAME, RETURN_VOID, false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, implementationType.getInternalName(), NAME_FIELD, STRING.getDescriptor());
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = visitor.visitMethod(1, "getName", RETURN_STRING, null, EMPTY_STRINGS);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, implementationType.getInternalName(), NAME_FIELD, STRING.getDescriptor());
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = visitor.visitMethod(1, "toString", RETURN_STRING, null, EMPTY_STRINGS);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, implementationType.getInternalName(), NAME_FIELD, STRING.getDescriptor());
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        visitor.visitEnd();
        methodVisitor = visitor.visitMethod(1, "unpackState", RETURN_OBJECT, null, EMPTY_STRINGS);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, implementationType.getInternalName(), NAME_FIELD, STRING.getDescriptor());
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = visitor.visitMethod(1, "publicType", RETURN_CLASS, null, EMPTY_STRINGS);
        methodVisitor.visitLdcInsn((Object)publicType);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = visitor.visitMethod(1, "immutable", RETURN_BOOLEAN, null, EMPTY_STRINGS);
        methodVisitor.visitLdcInsn((Object)true);
        methodVisitor.visitInsn(172);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = visitor.visitMethod(1, "getFactoryId", RETURN_INT, null, EMPTY_STRINGS);
        methodVisitor.visitLdcInsn((Object)FACTORY_ID);
        methodVisitor.visitInsn(172);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        Class implClass = generator.define();
        generator = new AsmClassGenerator(publicClass, this.factorySuffix);
        visitor = generator.getVisitor();
        visitor.visit(49, 4097, generator.getGeneratedType().getInternalName(), null, CLASS_GENERATING_LOADER.getInternalName(), EMPTY_STRINGS);
        methodVisitor = visitor.visitMethod(1, CONSTRUCTOR_NAME, RETURN_VOID, null, EMPTY_STRINGS);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, CLASS_GENERATING_LOADER.getInternalName(), CONSTRUCTOR_NAME, RETURN_VOID, false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = visitor.visitMethod(1, "load", RETURN_OBJECT_FROM_STRING, null, EMPTY_STRINGS);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, implementationType.getInternalName());
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, implementationType.getInternalName(), CONSTRUCTOR_NAME, RETURN_VOID_FROM_STRING, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        visitor.visitEnd();
        Class factoryClass = generator.define();
        try {
            return (ClassGeneratingLoader)((Object)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private void visitFields(Class<?> type, ValidationProblemCollector collector) {
        if (type.equals(Object.class)) {
            return;
        }
        if (type.getSuperclass() != null) {
            this.visitFields(type.getSuperclass(), collector);
        }
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || GroovyObject.class.isAssignableFrom(type) && field.getName().equals("metaClass")) continue;
            collector.add(field, "A Named implementation class must not define any instance fields.");
        }
    }

    protected static abstract class ClassGeneratingLoader
    extends CacheLoader<String, Object> {
        protected ClassGeneratingLoader() {
        }

        public abstract Object load(String var1);
    }
}

