/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ScalarSupplier;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public class DefaultProperty<T>
extends AbstractProperty<T>
implements Property<T> {
    private final Class<T> type;
    private final ValueSanitizer<T> sanitizer;
    private ScalarSupplier<? extends T> convention = Providers.noValue();
    private ScalarSupplier<? extends T> value;

    public DefaultProperty(Class<T> type) {
        this.applyDefaultValue();
        this.type = type;
        this.sanitizer = ValueSanitizers.forType(type);
    }

    @Override
    protected ValueSupplier getSupplier() {
        return this.value;
    }

    @Override
    public Object unpackState() {
        return this.getProvider();
    }

    @Override
    public Class<?> publicType() {
        return Property.class;
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.PropertyManagedFactory.FACTORY_ID;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            this.set(object);
        }
    }

    @Override
    public void set(T value) {
        if (value == null) {
            if (this.beforeReset()) {
                this.value = this.convention;
            }
            return;
        }
        if (this.beforeMutate()) {
            this.value = Providers.fixedValue(this.getValidationDisplayName(), value, this.type, this.sanitizer);
        }
    }

    @Override
    public Property<T> value(@Nullable T value) {
        this.set(value);
        return this;
    }

    @Override
    public Property<T> value(Provider<? extends T> provider) {
        this.set(provider);
        return this;
    }

    public ProviderInternal<? extends T> getProvider() {
        return this.value.asProvider();
    }

    public DefaultProperty<T> provider(Provider<? extends T> provider) {
        this.set(provider);
        return this;
    }

    @Override
    public void set(Provider<? extends T> provider) {
        if (!this.beforeMutate()) {
            return;
        }
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal<T> p = Providers.internal(provider);
        this.value = p.asSupplier(this.getValidationDisplayName(), this.type, this.sanitizer);
    }

    @Override
    public Property<T> convention(T value) {
        if (value == null) {
            this.applyConvention(Providers.noValue());
        } else {
            this.applyConvention(Providers.fixedValue(this.getValidationDisplayName(), value, this.type, this.sanitizer));
        }
        return this;
    }

    @Override
    public Property<T> convention(Provider<? extends T> valueProvider) {
        ProviderInternal<T> providerInternal = Providers.internal(valueProvider);
        ScalarSupplier<? extends T> conventionSupplier = providerInternal.asSupplier(this.getValidationDisplayName(), this.type, this.sanitizer);
        this.applyConvention(conventionSupplier);
        return this;
    }

    private void applyConvention(ScalarSupplier<? extends T> conventionSupplier) {
        if (this.shouldApplyConvention()) {
            this.value = conventionSupplier;
        }
        this.convention = conventionSupplier;
    }

    @Override
    protected void applyDefaultValue() {
        this.value = Providers.noValue();
    }

    @Override
    protected void makeFinal() {
        this.value = this.value.withFinalValue();
        this.convention = Providers.noValue();
    }

    @Override
    public T get() {
        this.beforeRead();
        return this.value.get(this.getDisplayName());
    }

    @Override
    public T getOrNull() {
        this.beforeRead();
        return this.value.getOrNull();
    }

    @Override
    public T getOrElse(T defaultValue) {
        this.beforeRead();
        T t = this.value.getOrNull();
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    @Override
    public boolean isPresent() {
        this.beforeRead();
        return this.value.isPresent();
    }

    @Override
    protected String describeContents() {
        return String.format("property(%s, %s)", this.type, this.value);
    }
}

