/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.classpath.DefaultClasspathEntrySnapshotter;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.vfs.VirtualFileSystem;

public class CachingClasspathEntrySnapshotter
implements ClasspathEntrySnapshotter {
    private final DefaultClasspathEntrySnapshotter snapshotter;
    private final VirtualFileSystem virtualFileSystem;
    private final ClasspathEntrySnapshotCache cache;

    public CachingClasspathEntrySnapshotter(FileHasher fileHasher, StreamHasher streamHasher, VirtualFileSystem virtualFileSystem, ClassDependenciesAnalyzer analyzer, ClasspathEntrySnapshotCache cache, FileOperations fileOperations) {
        this.snapshotter = new DefaultClasspathEntrySnapshotter(fileHasher, streamHasher, analyzer, fileOperations);
        this.virtualFileSystem = virtualFileSystem;
        this.cache = cache;
    }

    @Override
    public ClasspathEntrySnapshot createSnapshot(File classpathEntry) {
        return this.cache.get(classpathEntry, () -> this.virtualFileSystem.read(classpathEntry.getAbsolutePath(), snapshot -> this.snapshotter.createSnapshot(snapshot.getHash(), classpathEntry)));
    }
}

