/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.execution.EmptySourceTaskSkipper;
import org.gradle.internal.Cast;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.impl.OutputsCleaner;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmptySourceTaskSkipper
implements EmptySourceTaskSkipper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEmptySourceTaskSkipper.class);
    private final BuildOutputCleanupRegistry buildOutputCleanupRegistry;
    private final Deleter deleter;
    private final OutputChangeListener outputChangeListener;
    private final TaskInputsListener taskInputsListener;

    public DefaultEmptySourceTaskSkipper(BuildOutputCleanupRegistry buildOutputCleanupRegistry, Deleter deleter, OutputChangeListener outputChangeListener, TaskInputsListener taskInputsListener) {
        this.buildOutputCleanupRegistry = buildOutputCleanupRegistry;
        this.deleter = deleter;
        this.outputChangeListener = outputChangeListener;
        this.taskInputsListener = taskInputsListener;
    }

    @Override
    public Optional<ExecutionOutcome> skipIfEmptySources(TaskInternal task, boolean hasSourceFiles, FileCollection inputFiles, FileCollection sourceFiles, Map<String, FileCollectionFingerprint> outputFileSnapshots) {
        if (hasSourceFiles && sourceFiles.isEmpty()) {
            ExecutionOutcome skipOutcome;
            if (outputFileSnapshots.isEmpty()) {
                LOGGER.info("Skipping {} as it has no source files and no previous output files.", (Object)task);
                skipOutcome = ExecutionOutcome.SHORT_CIRCUITED;
            } else {
                this.outputChangeListener.beforeOutputChange();
                OutputsCleaner outputsCleaner = new OutputsCleaner(this.deleter, this.buildOutputCleanupRegistry::isOutputOwnedByBuild, this.buildOutputCleanupRegistry::isOutputOwnedByBuild);
                for (FileCollectionFingerprint outputFingerprints : outputFileSnapshots.values()) {
                    try {
                        outputsCleaner.cleanupOutputs(outputFingerprints);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                if (outputsCleaner.getDidWork()) {
                    LOGGER.info("Cleaned previous output of {} as it has no source files.", (Object)task);
                    skipOutcome = ExecutionOutcome.EXECUTED_NON_INCREMENTALLY;
                } else {
                    skipOutcome = ExecutionOutcome.SHORT_CIRCUITED;
                }
            }
            this.taskInputsListener.onExecute(task, Cast.cast(FileCollectionInternal.class, sourceFiles));
            return Optional.of(skipOutcome);
        }
        this.taskInputsListener.onExecute(task, Cast.cast(FileCollectionInternal.class, inputFiles));
        return Optional.empty();
    }
}

