/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultGroovySourceSet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.GroovyRuntime;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.javadoc.Groovydoc;

public class GroovyBasePlugin
implements Plugin<Project> {
    public static final String GROOVY_RUNTIME_EXTENSION_NAME = "groovyRuntime";
    private final ObjectFactory objectFactory;
    private final ModuleRegistry moduleRegistry;
    private Project project;
    private GroovyRuntime groovyRuntime;

    @Inject
    public GroovyBasePlugin(ObjectFactory objectFactory, ModuleRegistry moduleRegistry) {
        this.objectFactory = objectFactory;
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureGroovyRuntimeExtension();
        this.configureCompileDefaults();
        this.configureSourceSetDefaults();
        this.configureGroovydoc();
    }

    private void configureGroovyRuntimeExtension() {
        this.groovyRuntime = this.project.getExtensions().create(GROOVY_RUNTIME_EXTENSION_NAME, GroovyRuntime.class, this.project);
    }

    private void configureCompileDefaults() {
        this.project.getTasks().withType(GroovyCompile.class).configureEach(new Action<GroovyCompile>(){

            @Override
            public void execute(final GroovyCompile compile) {
                compile.getConventionMapping().map("groovyClasspath", new Callable<Object>(){

                    @Override
                    public Object call() {
                        return GroovyBasePlugin.this.groovyRuntime.inferGroovyClasspath(compile.getClasspath());
                    }
                });
            }
        });
    }

    private void configureSourceSetDefaults() {
        this.project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets().all(new Action<SourceSet>(){

            @Override
            public void execute(final SourceSet sourceSet) {
                final DefaultGroovySourceSet groovySourceSet = new DefaultGroovySourceSet("groovy", ((DefaultSourceSet)sourceSet).getDisplayName(), GroovyBasePlugin.this.objectFactory);
                new DslObject(sourceSet).getConvention().getPlugins().put("groovy", groovySourceSet);
                groovySourceSet.getGroovy().srcDir("src/" + sourceSet.getName() + "/groovy");
                sourceSet.getResources().getFilter().exclude(new Spec<FileTreeElement>(){

                    @Override
                    public boolean isSatisfiedBy(FileTreeElement element) {
                        return groovySourceSet.getGroovy().contains(element.getFile());
                    }
                });
                sourceSet.getAllJava().source(groovySourceSet.getGroovy());
                sourceSet.getAllSource().source(groovySourceSet.getGroovy());
                NamedDomainObjectProvider compileTask = GroovyBasePlugin.this.project.getTasks().register(sourceSet.getCompileTaskName("groovy"), GroovyCompile.class, new Action<GroovyCompile>(){

                    @Override
                    public void execute(GroovyCompile compile) {
                        JvmPluginsHelper.configureForSourceSet(sourceSet, groovySourceSet.getGroovy(), compile, compile.getOptions(), GroovyBasePlugin.this.project);
                        compile.setDescription("Compiles the " + sourceSet.getName() + " Groovy source.");
                        compile.setSource(groovySourceSet.getGroovy());
                    }
                });
                JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, groovySourceSet.getGroovy(), GroovyBasePlugin.this.project, (TaskProvider<? extends AbstractCompile>)compileTask, compileTask.map(new Transformer<CompileOptions, GroovyCompile>(){

                    @Override
                    public CompileOptions transform(GroovyCompile groovyCompile) {
                        return groovyCompile.getOptions();
                    }
                }));
                GroovyBasePlugin.this.project.getTasks().named(sourceSet.getClassesTaskName(), new Action<Task>((TaskProvider)compileTask){
                    final /* synthetic */ TaskProvider val$compileTask;
                    {
                        this.val$compileTask = taskProvider;
                    }

                    @Override
                    public void execute(Task task) {
                        task.dependsOn(this.val$compileTask);
                    }
                });
                ((Configuration)GroovyBasePlugin.this.project.getConfigurations().findByName(sourceSet.getCompileClasspathConfigurationName())).attributes(attrs -> attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, GroovyBasePlugin.this.project.getObjects().named(LibraryElements.class, "classes+resources")));
            }
        });
    }

    private void configureGroovydoc() {
        this.project.getTasks().withType(Groovydoc.class).configureEach(new Action<Groovydoc>(){

            @Override
            public void execute(final Groovydoc groovydoc) {
                groovydoc.getConventionMapping().map("groovyClasspath", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        FileCollection groovyClasspath = GroovyBasePlugin.this.groovyRuntime.inferGroovyClasspath(groovydoc.getClasspath());
                        ConfigurableFileCollection jansi = GroovyBasePlugin.this.project.getObjects().fileCollection().from(GroovyBasePlugin.this.moduleRegistry.getExternalModule("jansi").getImplementationClasspath().getAsFiles());
                        return groovyClasspath.plus(jansi);
                    }
                });
                groovydoc.getConventionMapping().map("destinationDir", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return new File(GroovyBasePlugin.this.java(GroovyBasePlugin.this.project.getConvention()).getDocsDir(), "groovydoc");
                    }
                });
                groovydoc.getConventionMapping().map("docTitle", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return GroovyBasePlugin.this.project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle();
                    }
                });
                groovydoc.getConventionMapping().map("windowTitle", new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return GroovyBasePlugin.this.project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle();
                    }
                });
            }
        });
    }

    private JavaPluginConvention java(Convention convention) {
        return convention.getPlugin(JavaPluginConvention.class);
    }
}

